/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.jazz.command.tag;

import java.io.File;
import java.util.ArrayList;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFile;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmFileStatus;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.ScmTagParameters;
import org.apache.maven.scm.command.tag.AbstractTagCommand;
import org.apache.maven.scm.command.tag.TagScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.jazz.command.JazzScmCommand;
import org.apache.maven.scm.provider.jazz.command.consumer.DebugLoggerConsumer;
import org.apache.maven.scm.provider.jazz.command.consumer.ErrorConsumer;
import org.apache.maven.scm.provider.jazz.repository.JazzScmProviderRepository;

public class JazzTagCommand
extends AbstractTagCommand {
    protected ScmResult executeTagCommand(ScmProviderRepository repo, ScmFileSet fileSet, String tag2, ScmTagParameters scmTagParameters) throws ScmException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Executing tag command...");
        }
        JazzScmProviderRepository jazzRepo = (JazzScmProviderRepository)repo;
        this.getLogger().debug("Creating Snapshot...");
        DebugLoggerConsumer tagConsumer = new DebugLoggerConsumer(this.getLogger());
        ErrorConsumer errConsumer = new ErrorConsumer(this.getLogger());
        JazzScmCommand tagCreateSnapshotCmd = this.createTagCreateSnapshotCommand(jazzRepo, fileSet, tag2, scmTagParameters);
        int status2 = tagCreateSnapshotCmd.execute(tagConsumer, errConsumer);
        if (status2 != 0 || errConsumer.hasBeenFed()) {
            return new TagScmResult(tagCreateSnapshotCmd.getCommandString(), "Error code for Jazz SCM tag (SNAPSHOT) command - " + status2, errConsumer.getOutput(), false);
        }
        this.getLogger().debug("Creating Workspace from Snapshot...");
        JazzScmCommand tagCreateWorkspaceCmd = this.createTagCreateWorkspaceCommand(jazzRepo, fileSet, tag2);
        errConsumer = new ErrorConsumer(this.getLogger());
        status2 = tagCreateWorkspaceCmd.execute(tagConsumer, errConsumer);
        if (status2 != 0 || errConsumer.hasBeenFed()) {
            return new TagScmResult(tagCreateWorkspaceCmd.getCommandString(), "Error code for Jazz SCM tag (WORKSPACE) command - " + status2, errConsumer.getOutput(), false);
        }
        if (jazzRepo.isPushChangesAndHaveFlowTargets()) {
            this.getLogger().debug("Promoting and delivering...");
            this.getLogger().debug("Delivering...");
            JazzScmCommand tagDeliverCommand = this.createTagDeliverCommand(jazzRepo, fileSet, tag2);
            errConsumer = new ErrorConsumer(this.getLogger());
            status2 = tagDeliverCommand.execute(tagConsumer, errConsumer);
            if (status2 != 0 || errConsumer.hasBeenFed()) {
                return new TagScmResult(tagDeliverCommand.getCommandString(), "Error code for Jazz SCM deliver command - " + status2, errConsumer.getOutput(), false);
            }
            this.getLogger().debug("Promoting snapshot...");
            JazzScmCommand tagSnapshotPromoteCommand = this.createTagSnapshotPromoteCommand(jazzRepo, fileSet, tag2);
            errConsumer = new ErrorConsumer(this.getLogger());
            status2 = tagSnapshotPromoteCommand.execute(tagConsumer, errConsumer);
            if (status2 != 0 || errConsumer.hasBeenFed()) {
                return new TagScmResult(tagSnapshotPromoteCommand.getCommandString(), "Error code for Jazz SCM snapshot promote command - " + status2, errConsumer.getOutput(), false);
            }
        }
        ArrayList<ScmFile> taggedFiles = new ArrayList<ScmFile>(fileSet.getFileList().size());
        for (File f : fileSet.getFileList()) {
            taggedFiles.add(new ScmFile(f.getPath(), ScmFileStatus.TAGGED));
        }
        return new TagScmResult(tagCreateSnapshotCmd.getCommandString(), taggedFiles);
    }

    public JazzScmCommand createTagCreateSnapshotCommand(JazzScmProviderRepository repo, ScmFileSet fileSet, String tag2, ScmTagParameters scmTagParameters) {
        String message;
        JazzScmCommand command = new JazzScmCommand("create", "snapshot", repo, fileSet, this.getLogger());
        if (tag2 != null && !tag2.trim().equals("")) {
            command.addArgument("--name");
            command.addArgument(tag2);
        }
        if ((message = scmTagParameters.getMessage()) != null && !message.trim().equals("")) {
            command.addArgument("--description");
            command.addArgument(message);
        }
        command.addArgument(repo.getRepositoryWorkspace());
        return command;
    }

    public JazzScmCommand createTagSnapshotPromoteCommand(JazzScmProviderRepository repo, ScmFileSet fileSet, String tag2) {
        JazzScmCommand command = new JazzScmCommand("snapshot", "promote", repo, fileSet, this.getLogger());
        if (repo.getFlowTarget() != null && !repo.getFlowTarget().equals("")) {
            command.addArgument(repo.getFlowTarget());
        }
        if (tag2 != null && !tag2.trim().equals("")) {
            command.addArgument(tag2);
        }
        return command;
    }

    public JazzScmCommand createTagDeliverCommand(JazzScmProviderRepository repo, ScmFileSet fileSet, String tag2) {
        JazzScmCommand command = new JazzScmCommand("deliver", repo, fileSet, this.getLogger());
        if (repo.getWorkspace() != null && !repo.getWorkspace().equals("")) {
            command.addArgument("--source");
            command.addArgument(tag2);
        }
        if (repo.getFlowTarget() != null && !repo.getFlowTarget().equals("")) {
            command.addArgument("--target");
            command.addArgument(repo.getFlowTarget());
        }
        return command;
    }

    public JazzScmCommand createTagCreateWorkspaceCommand(JazzScmProviderRepository repo, ScmFileSet fileSet, String tag2) {
        JazzScmCommand command = new JazzScmCommand("create", "workspace", repo, fileSet, this.getLogger());
        if (tag2 != null && !tag2.trim().equals("")) {
            command.addArgument(tag2);
            command.addArgument("--snapshot");
            command.addArgument(tag2);
        }
        return command;
    }
}

