/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.perforce.command.blame;

import java.util.ArrayList;
import java.util.List;
import org.apache.maven.scm.command.blame.BlameLine;
import org.apache.maven.scm.log.ScmLogger;
import org.apache.maven.scm.util.AbstractConsumer;
import org.apache.regexp.RE;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PerforceBlameConsumer
extends AbstractConsumer {
    private static final String LINE_PATTERN = "(\\d+):";
    private RE lineRegexp;
    private List<BlameLine> lines = new ArrayList<BlameLine>();

    public PerforceBlameConsumer(ScmLogger logger) {
        super(logger);
        this.lineRegexp = new RE(LINE_PATTERN);
    }

    @Override
    public void consumeLine(String line) {
        if (this.lineRegexp.match(line)) {
            String revision = this.lineRegexp.getParen(1).trim();
            this.lines.add(new BlameLine(null, revision, null));
        }
    }

    public List<BlameLine> getLines() {
        return this.lines;
    }
}

