/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.perforce.command.changelog;

import java.util.ArrayList;
import java.util.List;
import org.apache.maven.scm.ChangeFile;
import org.apache.maven.scm.ChangeSet;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.log.ScmLogger;
import org.apache.maven.scm.util.AbstractConsumer;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PerforceDescribeConsumer
extends AbstractConsumer {
    private List<ChangeSet> entries;
    private static final int GET_REVISION = 1;
    private static final int GET_COMMENT_BEGIN = 2;
    private static final int GET_COMMENT = 3;
    private static final int GET_AFFECTED_FILES = 4;
    private static final int GET_FILES_BEGIN = 5;
    private static final int GET_FILE = 6;
    private int status;
    private String currentRevision;
    private ChangeSet currentChange;
    private String currentFile;
    private String repoPath;
    private String userDatePattern;
    private static final String REVISION_PATTERN = "^Change (\\d+) by (.*)@[^ ]+ on (.*)";
    private static final String COMMENT_DELIMITER = "";
    private static final String CHANGELIST_DELIMITER = "";
    private static final String FILE_PATTERN = "^\\.\\.\\. (.*)#(\\d+) ";
    private RE revisionRegexp;
    private RE fileRegexp;

    public PerforceDescribeConsumer(String repoPath, String userDatePattern, ScmLogger logger) {
        block2: {
            super(logger);
            this.entries = new ArrayList<ChangeSet>();
            this.status = 1;
            this.repoPath = repoPath;
            this.userDatePattern = userDatePattern;
            try {
                this.revisionRegexp = new RE(REVISION_PATTERN);
                this.fileRegexp = new RE(FILE_PATTERN);
            }
            catch (RESyntaxException ignored) {
                if (!this.getLogger().isErrorEnabled()) break block2;
                this.getLogger().error("Could not create regexps to parse Perforce descriptions", ignored);
            }
        }
    }

    public List<ChangeSet> getModifications() throws ScmException {
        return this.entries;
    }

    @Override
    public void consumeLine(String line) {
        switch (this.status) {
            case 1: {
                this.processGetRevision(line);
                break;
            }
            case 2: {
                this.status = 3;
                break;
            }
            case 3: {
                this.processGetComment(line);
                break;
            }
            case 4: {
                this.processGetAffectedFiles(line);
                break;
            }
            case 5: {
                this.status = 6;
                break;
            }
            case 6: {
                this.processGetFile(line);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown state: " + this.status);
            }
        }
    }

    private void addEntry(ChangeSet entry, ChangeFile file) {
        entry.addFile(file);
    }

    private void processGetFile(String line) {
        if (line.equals("")) {
            this.entries.add(0, this.currentChange);
            this.status = 1;
            return;
        }
        if (!this.fileRegexp.match(line)) {
            return;
        }
        this.currentFile = this.fileRegexp.getParen(1);
        if (this.currentFile.startsWith(this.repoPath)) {
            this.currentFile = this.currentFile.substring(this.repoPath.length() + 1);
            this.addEntry(this.currentChange, new ChangeFile(this.currentFile, this.fileRegexp.getParen(2)));
        }
    }

    private void processGetRevision(String line) {
        if (!this.revisionRegexp.match(line)) {
            return;
        }
        this.currentChange = new ChangeSet();
        this.currentRevision = this.revisionRegexp.getParen(1);
        this.currentChange.setAuthor(this.revisionRegexp.getParen(2));
        this.currentChange.setDate(this.revisionRegexp.getParen(3), this.userDatePattern);
        this.status = 2;
    }

    private void processGetComment(String line) {
        if (line.equals("")) {
            this.status = 4;
        } else {
            this.currentChange.setComment(this.currentChange.getComment() + line.substring(1) + "\n");
        }
    }

    private void processGetAffectedFiles(String line) {
        if (!line.equals("Affected files ...")) {
            return;
        }
        this.status = 5;
    }
}

