/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.starteam.command.remove;

import java.io.File;
import java.util.List;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.command.remove.AbstractRemoveCommand;
import org.apache.maven.scm.command.remove.RemoveScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.starteam.command.StarteamCommand;
import org.apache.maven.scm.provider.starteam.command.StarteamCommandLineUtils;
import org.apache.maven.scm.provider.starteam.command.checkin.StarteamCheckInConsumer;
import org.apache.maven.scm.provider.starteam.repository.StarteamScmProviderRepository;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;

public class StarteamRemoveCommand
extends AbstractRemoveCommand
implements StarteamCommand {
    protected ScmResult executeRemoveCommand(ScmProviderRepository repo, ScmFileSet fileSet, String message) throws ScmException {
        if (this.getLogger().isInfoEnabled()) {
            this.getLogger().info("Working directory: " + fileSet.getBasedir().getAbsolutePath());
        }
        StarteamScmProviderRepository repository = (StarteamScmProviderRepository)repo;
        StarteamCheckInConsumer consumer = new StarteamCheckInConsumer(this.getLogger(), fileSet.getBasedir());
        CommandLineUtils.StringStreamConsumer stderr = new CommandLineUtils.StringStreamConsumer();
        List<File> remvoveFiles = fileSet.getFileList();
        if (remvoveFiles.size() == 0) {
            Commandline cl = StarteamRemoveCommand.createCommandLine(repository, fileSet);
            int exitCode = StarteamCommandLineUtils.executeCommandline(cl, consumer, stderr, this.getLogger());
            if (exitCode != 0) {
                return new RemoveScmResult(cl.toString(), "The starteam command failed.", stderr.getOutput(), false);
            }
        } else {
            for (int i = 0; i < remvoveFiles.size(); ++i) {
                File fileToBeRemoved = remvoveFiles.get(i);
                ScmFileSet scmFileSet = new ScmFileSet(fileSet.getBasedir(), fileToBeRemoved);
                Commandline cl = StarteamRemoveCommand.createCommandLine(repository, scmFileSet);
                int exitCode = StarteamCommandLineUtils.executeCommandline(cl, consumer, stderr, this.getLogger());
                if (exitCode == 0) continue;
                return new RemoveScmResult(cl.toString(), "The starteam command failed.", stderr.getOutput(), false);
            }
        }
        return new RemoveScmResult(null, consumer.getCheckedInFiles());
    }

    public static Commandline createCommandLine(StarteamScmProviderRepository repo, ScmFileSet dirOrFile) {
        return StarteamCommandLineUtils.createStarteamCommandLine("remove", null, dirOrFile, repo);
    }
}

