/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.starteam.command.tag;

import java.io.File;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.ScmTagParameters;
import org.apache.maven.scm.command.tag.AbstractTagCommand;
import org.apache.maven.scm.command.tag.TagScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.starteam.command.StarteamCommand;
import org.apache.maven.scm.provider.starteam.command.StarteamCommandLineUtils;
import org.apache.maven.scm.provider.starteam.command.tag.StarteamTagConsumer;
import org.apache.maven.scm.provider.starteam.repository.StarteamScmProviderRepository;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;

public class StarteamTagCommand
extends AbstractTagCommand
implements StarteamCommand {
    protected ScmResult executeTagCommand(ScmProviderRepository repo, ScmFileSet fileSet, String tag2, String message) throws ScmException {
        return this.executeTagCommand(repo, fileSet, tag2, new ScmTagParameters(message));
    }

    protected ScmResult executeTagCommand(ScmProviderRepository repo, ScmFileSet fileSet, String tag2, ScmTagParameters scmTagParameters) throws ScmException {
        if (fileSet.getFileList().isEmpty()) {
            throw new ScmException("This provider doesn't support tagging subsets of a directory");
        }
        if (tag2 == null || tag2.trim().length() == 0) {
            throw new ScmException("tag must be specified");
        }
        if (this.getLogger().isInfoEnabled()) {
            this.getLogger().info("Working directory: " + fileSet.getBasedir().getAbsolutePath());
        }
        StarteamScmProviderRepository repository = (StarteamScmProviderRepository)repo;
        StarteamTagConsumer consumer = new StarteamTagConsumer(this.getLogger());
        CommandLineUtils.StringStreamConsumer stderr = new CommandLineUtils.StringStreamConsumer();
        Commandline cl = StarteamTagCommand.createCommandLine(repository, fileSet.getBasedir(), tag2);
        int exitCode = StarteamCommandLineUtils.executeCommandline(cl, consumer, stderr, this.getLogger());
        if (exitCode != 0) {
            return new TagScmResult(cl.toString(), "The starteam command failed.", stderr.getOutput(), false);
        }
        return new TagScmResult(cl.toString(), consumer.getTaggedFiles());
    }

    public static Commandline createCommandLine(StarteamScmProviderRepository repo, File workingDirectory, String tag2) throws ScmException {
        Commandline cl = StarteamCommandLineUtils.createStarteamBaseCommandLine("label", repo);
        cl.createArg().setValue("-p");
        cl.createArg().setValue(repo.getFullUrl());
        cl.createArg().setValue("-nl");
        cl.createArg().setValue(tag2);
        cl.createArg().setValue("-b");
        return cl;
    }
}

