/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediation.dependency.mgt;

import java.util.Dictionary;
import java.util.HashMap;
import java.util.Map;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.wso2.carbon.mediation.dependency.mgt.DependencyManagementServiceComponent;

public class CustomResolversListener
implements BundleListener {
    private DependencyManagementServiceComponent svcComponent;
    private BundleContext bndCtx;
    private boolean listenerRegistered;
    private Map<String, Bundle> resolverBundles = new HashMap<String, Bundle>();

    CustomResolversListener(DependencyManagementServiceComponent svcComponent, BundleContext bndCtx) {
        this.svcComponent = svcComponent;
        this.bndCtx = bndCtx;
    }

    boolean registerBundleListener() {
        if (this.resolverBundles.isEmpty()) {
            this.listenerRegistered = false;
        } else {
            this.bndCtx.addBundleListener((BundleListener)this);
            this.listenerRegistered = true;
        }
        return this.listenerRegistered;
    }

    void unregisterBundleListener() {
        if (this.listenerRegistered) {
            this.bndCtx.removeBundleListener((BundleListener)this);
        }
    }

    void addResolverBundle(String name, Bundle bundle) {
        this.resolverBundles.put(name, bundle);
    }

    synchronized void start() {
        for (String resolverName : this.resolverBundles.keySet()) {
            Bundle bundle = this.resolverBundles.get(resolverName);
            if (bundle.getState() == 32) continue;
            this.svcComponent.addPendingResolver(resolverName);
        }
    }

    public void bundleChanged(BundleEvent event) {
        if (event.getType() != 2) {
            return;
        }
        Dictionary headers = event.getBundle().getHeaders();
        String value = (String)headers.get("MediatorDependencyResolver");
        if (value != null) {
            this.svcComponent.removePendingResolver(value.trim());
        }
    }
}

