/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediation.dependency.mgt;

import java.util.HashMap;
import java.util.Map;
import org.apache.synapse.Mediator;
import org.apache.synapse.mediators.base.SequenceMediator;
import org.apache.synapse.mediators.bsf.ScriptMediator;
import org.apache.synapse.mediators.builtin.CalloutMediator;
import org.apache.synapse.mediators.builtin.SendMediator;
import org.apache.synapse.mediators.builtin.ValidateMediator;
import org.apache.synapse.mediators.eip.splitter.CloneMediator;
import org.apache.synapse.mediators.eip.splitter.IterateMediator;
import org.apache.synapse.mediators.spring.SpringMediator;
import org.apache.synapse.mediators.throttle.ThrottleMediator;
import org.apache.synapse.mediators.transform.XSLTMediator;
import org.apache.synapse.mediators.xquery.XQueryMediator;
import org.wso2.carbon.mediation.dependency.mgt.DependencyResolver;
import org.wso2.carbon.mediation.dependency.mgt.resolvers.CacheMediatorResolver;
import org.wso2.carbon.mediation.dependency.mgt.resolvers.CalloutMediatorResolver;
import org.wso2.carbon.mediation.dependency.mgt.resolvers.CloneMediatorResolver;
import org.wso2.carbon.mediation.dependency.mgt.resolvers.IterateMediatorResolver;
import org.wso2.carbon.mediation.dependency.mgt.resolvers.RouterMediatorResolver;
import org.wso2.carbon.mediation.dependency.mgt.resolvers.ScriptMediatorResolver;
import org.wso2.carbon.mediation.dependency.mgt.resolvers.SendMediatorResolver;
import org.wso2.carbon.mediation.dependency.mgt.resolvers.SequenceMediatorResolver;
import org.wso2.carbon.mediation.dependency.mgt.resolvers.SpringMediatorResolver;
import org.wso2.carbon.mediation.dependency.mgt.resolvers.ThrottleMediatorResolver;
import org.wso2.carbon.mediation.dependency.mgt.resolvers.ValidateMediatorResolver;
import org.wso2.carbon.mediation.dependency.mgt.resolvers.XQueryMediatorResolver;
import org.wso2.carbon.mediation.dependency.mgt.resolvers.XSLTMediatorResolver;
import org.wso2.carbon.mediator.cache.CacheMediator;
import org.wso2.carbon.mediators.router.impl.RouterMediator;

public class DependencyResolverFactory {
    private static final DependencyResolverFactory INSTANCE = new DependencyResolverFactory();
    private Map<String, DependencyResolver> resolversMap = new HashMap<String, DependencyResolver>();

    private DependencyResolverFactory() {
        this.resolversMap.put(CacheMediator.class.getName(), new CacheMediatorResolver());
        this.resolversMap.put(CalloutMediator.class.getName(), new CalloutMediatorResolver());
        this.resolversMap.put(CloneMediator.class.getName(), new CloneMediatorResolver());
        this.resolversMap.put(IterateMediator.class.getName(), new IterateMediatorResolver());
        this.resolversMap.put(RouterMediator.class.getName(), new RouterMediatorResolver());
        this.resolversMap.put(ScriptMediator.class.getName(), new ScriptMediatorResolver());
        this.resolversMap.put(SendMediator.class.getName(), new SendMediatorResolver());
        this.resolversMap.put(SequenceMediator.class.getName(), new SequenceMediatorResolver());
        this.resolversMap.put(SpringMediator.class.getName(), new SpringMediatorResolver());
        this.resolversMap.put(ThrottleMediator.class.getName(), new ThrottleMediatorResolver());
        this.resolversMap.put(ValidateMediator.class.getName(), new ValidateMediatorResolver());
        this.resolversMap.put(XQueryMediator.class.getName(), new XQueryMediatorResolver());
        this.resolversMap.put(XSLTMediator.class.getName(), new XSLTMediatorResolver());
    }

    public static DependencyResolverFactory getInstance() {
        return INSTANCE;
    }

    public void addResolver(String className, DependencyResolver resolver) {
        if (!this.resolversMap.containsKey(className)) {
            this.resolversMap.put(className, resolver);
        }
    }

    public DependencyResolver getResolver(Mediator m) {
        return this.resolversMap.get(m.getClass().getName());
    }
}

