/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediation.initializer;

import java.io.File;
import java.io.InputStream;
import java.util.Properties;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.Startup;
import org.apache.synapse.SynapseException;
import org.apache.synapse.config.Entry;
import org.apache.synapse.config.SynapseConfigUtils;
import org.apache.synapse.config.SynapseConfiguration;
import org.apache.synapse.config.xml.SynapseXMLConfigurationFactory;
import org.apache.synapse.config.xml.XMLConfigConstants;
import org.apache.synapse.config.xml.XMLConfigurationBuilder;
import org.apache.synapse.core.axis2.ProxyService;
import org.apache.synapse.endpoints.Endpoint;
import org.apache.synapse.eventing.SynapseEventSource;
import org.apache.synapse.mediators.base.SequenceMediator;
import org.apache.synapse.rest.API;
import org.wso2.carbon.mediation.initializer.persistence.registry.APIRegistryStore;
import org.wso2.carbon.mediation.initializer.persistence.registry.EndpointRegistryStore;
import org.wso2.carbon.mediation.initializer.persistence.registry.EventSourceRegistryStore;
import org.wso2.carbon.mediation.initializer.persistence.registry.ExecutorRegistryStore;
import org.wso2.carbon.mediation.initializer.persistence.registry.LocalEntryRegistryStore;
import org.wso2.carbon.mediation.initializer.persistence.registry.MessageProcessorRegistryStore;
import org.wso2.carbon.mediation.initializer.persistence.registry.MessageStoreRegistryStore;
import org.wso2.carbon.mediation.initializer.persistence.registry.ProxyServiceRegistryStore;
import org.wso2.carbon.mediation.initializer.persistence.registry.SequenceRegistryStore;
import org.wso2.carbon.mediation.initializer.persistence.registry.StartupRegistryStore;
import org.wso2.carbon.mediation.initializer.persistence.registry.SynapseRegistriesRegistryStore;
import org.wso2.carbon.registry.core.jdbc.utils.Transaction;
import org.wso2.carbon.registry.core.session.UserRegistry;

public class RegistryBasedSynapseConfigBuilder {
    Log log = LogFactory.getLog(RegistryBasedSynapseConfigBuilder.class);
    private UserRegistry registry;
    private static final QName FILE_NAME_ATTR = new QName("DEF_FILE_NAME");
    private String configName;
    private String synapseXMLLocation;
    private Properties properties;
    private boolean failSafeConfigurationLoading;

    public RegistryBasedSynapseConfigBuilder(UserRegistry registry, String configName, String synapseXMLLocation, Properties properties, boolean failSafeConfigurationLoading) {
        this.registry = registry;
        this.configName = configName;
        this.synapseXMLLocation = synapseXMLLocation;
        this.properties = properties;
        this.failSafeConfigurationLoading = failSafeConfigurationLoading;
    }

    public SynapseConfiguration getConfiguration() {
        SynapseConfiguration configuration = SynapseConfigUtils.newConfiguration();
        configuration.setDefaultQName(XMLConfigConstants.DEFINITIONS_ELT);
        boolean transactionStarted = Transaction.isStarted();
        try {
            if (!transactionStarted) {
                this.registry.beginTransaction();
            }
            this.buildSynapseRegistryFromRegistry(configuration, this.properties);
            this.buildLocalEntriesFromRegistry(configuration, this.properties);
            this.buildEndpointsFromRegistry(configuration, this.properties);
            this.buildSequencesFromRegistry(configuration, this.properties);
            this.buildProxyServicesFromRegistry(configuration, this.properties);
            this.buildTasksFromRegistry(configuration, this.properties);
            this.buildEvenSourcesFromRegistry(configuration, this.properties);
            this.buildExecutorsFromRegistry(configuration, this.properties);
            this.buildAPIsFromRegistry(configuration, this.properties);
            this.buildMessageStoresFromRegistry(configuration, this.properties);
            this.buildMessageProcessorsFromRegistry(configuration, this.properties);
            if (!transactionStarted) {
                this.registry.commitTransaction();
            }
        }
        catch (Exception e) {
            try {
                if (!transactionStarted) {
                    this.registry.rollbackTransaction();
                }
            }
            catch (Exception ex) {
                throw new SynapseException("Unable to rollback transaction", (Throwable)ex);
            }
            throw new SynapseException("Unable to perform registry operation", (Throwable)e);
        }
        if (configuration.getLocalRegistry().isEmpty() && configuration.getProxyServices().isEmpty() && configuration.getRegistry() != null) {
            OMNode remoteConfigNode = configuration.getRegistry().lookup("synapse.xml");
            try {
                configuration = XMLConfigurationBuilder.getConfiguration((InputStream)SynapseConfigUtils.getStreamSource((Object)remoteConfigNode).getInputStream(), (Properties)this.properties);
            }
            catch (XMLStreamException xse) {
                throw new SynapseException("Problem loading remote synapse.xml", (Throwable)xse);
            }
        }
        if (configuration.getMainSequence() == null) {
            SynapseConfigUtils.setDefaultMainSequence((SynapseConfiguration)configuration);
        }
        if (configuration.getFaultSequence() == null) {
            SynapseConfigUtils.setDefaultFaultSequence((SynapseConfiguration)configuration);
        }
        return configuration;
    }

    private void buildSynapseRegistryFromRegistry(SynapseConfiguration configuration, Properties properties) {
        SynapseRegistriesRegistryStore synapseRegistryStore = new SynapseRegistriesRegistryStore(this.registry, this.configName);
        OMElement registryElem = synapseRegistryStore.getElement();
        if (registryElem != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Building the synapse registry declaration from the carbon registry");
            }
            SynapseXMLConfigurationFactory.defineRegistry((SynapseConfiguration)configuration, (OMElement)registryElem, (Properties)properties);
        } else if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"No synapse registry is defined in the carbon registry");
        }
    }

    private void buildSequencesFromRegistry(SynapseConfiguration configuration, Properties properties) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Building the sequences from the carbon registry");
        }
        SequenceRegistryStore sequenceStore = new SequenceRegistryStore(this.registry, this.configName);
        for (OMElement sequenceElem : sequenceStore.getElements()) {
            try {
                SequenceMediator seq = (SequenceMediator)SynapseXMLConfigurationFactory.defineSequence((SynapseConfiguration)configuration, (OMElement)sequenceElem, (Properties)properties);
                String fileName = sequenceElem.getAttributeValue(FILE_NAME_ATTR);
                if (fileName == null) continue;
                seq.setFileName(fileName);
                fileName = this.synapseXMLLocation + File.separator + "sequences" + File.separator + fileName;
                configuration.getArtifactDeploymentStore().addArtifact(fileName, seq.getName());
            }
            catch (SynapseException e) {
                this.handleErrorGracefully("sequence", e);
            }
        }
    }

    private void buildEndpointsFromRegistry(SynapseConfiguration configuration, Properties properties) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Building the endpoints from the carbon registry");
        }
        EndpointRegistryStore endpointStore = new EndpointRegistryStore(this.registry, this.configName);
        for (OMElement endpointElem : endpointStore.getElements()) {
            try {
                Endpoint ep = SynapseXMLConfigurationFactory.defineEndpoint((SynapseConfiguration)configuration, (OMElement)endpointElem, (Properties)properties);
                String fileName = endpointElem.getAttributeValue(FILE_NAME_ATTR);
                if (fileName == null) continue;
                ep.setFileName(fileName);
                fileName = this.synapseXMLLocation + File.separator + "endpoints" + File.separator + fileName;
                configuration.getArtifactDeploymentStore().addArtifact(fileName, ep.getName());
            }
            catch (SynapseException e) {
                this.handleErrorGracefully("endpoint", e);
            }
        }
    }

    private void buildLocalEntriesFromRegistry(SynapseConfiguration configuration, Properties properties) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Building the local entries from the carbon registry");
        }
        LocalEntryRegistryStore localEntryStore = new LocalEntryRegistryStore(this.registry, this.configName);
        for (OMElement localEntryElem : localEntryStore.getElements()) {
            try {
                Entry e = SynapseXMLConfigurationFactory.defineEntry((SynapseConfiguration)configuration, (OMElement)localEntryElem, (Properties)properties);
                String fileName = localEntryElem.getAttributeValue(FILE_NAME_ATTR);
                if (fileName == null) continue;
                e.setFileName(fileName);
                fileName = this.synapseXMLLocation + File.separator + "local-entries" + File.separator + fileName;
                configuration.getArtifactDeploymentStore().addArtifact(fileName, e.getKey());
            }
            catch (SynapseException e) {
                this.handleErrorGracefully("local-entry", e);
            }
        }
    }

    private void buildProxyServicesFromRegistry(SynapseConfiguration configuration, Properties properties) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Building the proxy services from the carbon registry");
        }
        ProxyServiceRegistryStore proxyServiceStore = new ProxyServiceRegistryStore(this.registry, this.configName);
        for (OMElement proxyServiceElem : proxyServiceStore.getElements()) {
            try {
                ProxyService proxy = SynapseXMLConfigurationFactory.defineProxy((SynapseConfiguration)configuration, (OMElement)proxyServiceElem, (Properties)properties);
                String fileName = proxyServiceElem.getAttributeValue(FILE_NAME_ATTR);
                if (fileName == null) continue;
                proxy.setFileName(fileName);
                fileName = this.synapseXMLLocation + File.separator + "proxy-services" + File.separator + fileName;
                configuration.getArtifactDeploymentStore().addArtifact(fileName, proxy.getName());
            }
            catch (SynapseException e) {
                this.handleErrorGracefully("proxy", e);
            }
        }
    }

    private void buildTasksFromRegistry(SynapseConfiguration configuration, Properties properties) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Building the startup tasks from the carbon registry");
        }
        StartupRegistryStore startupStore = new StartupRegistryStore(this.registry, this.configName);
        for (OMElement startupElem : startupStore.getElements()) {
            try {
                Startup st = SynapseXMLConfigurationFactory.defineStartup((SynapseConfiguration)configuration, (OMElement)startupElem, (Properties)properties);
                String fileName = startupElem.getAttributeValue(FILE_NAME_ATTR);
                if (fileName == null) continue;
                st.setFileName(fileName);
                fileName = this.synapseXMLLocation + File.separator + "tasks" + File.separator + st.getFileName();
                configuration.getArtifactDeploymentStore().addArtifact(fileName, st.getName());
            }
            catch (SynapseException e) {
                this.handleErrorGracefully("task", e);
            }
        }
    }

    private void buildEvenSourcesFromRegistry(SynapseConfiguration configuration, Properties properties) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Building the event sources from the carbon registry");
        }
        EventSourceRegistryStore eventSourceStore = new EventSourceRegistryStore(this.registry, this.configName);
        for (OMElement eventSourceElem : eventSourceStore.getElements()) {
            try {
                SynapseEventSource ses = SynapseXMLConfigurationFactory.defineEventSource((SynapseConfiguration)configuration, (OMElement)eventSourceElem, (Properties)properties);
                String fileName = eventSourceElem.getAttributeValue(FILE_NAME_ATTR);
                if (fileName == null) continue;
                ses.setFileName(fileName);
                fileName = this.synapseXMLLocation + File.separator + "event-sources" + File.separator + ses.getFileName();
                configuration.getArtifactDeploymentStore().addArtifact(fileName, ses.getName());
            }
            catch (SynapseException e) {
                this.handleErrorGracefully("event source", e);
            }
        }
    }

    private void buildExecutorsFromRegistry(SynapseConfiguration configuration, Properties properties) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Building the executors from the carbon registry");
        }
        ExecutorRegistryStore executorRegistryStore = new ExecutorRegistryStore(this.registry, this.configName);
        for (OMElement executorElem : executorRegistryStore.getElements()) {
            try {
                SynapseXMLConfigurationFactory.defineExecutor((SynapseConfiguration)configuration, (OMElement)executorElem, (Properties)properties);
            }
            catch (SynapseException e) {
                this.handleErrorGracefully("executor", e);
            }
        }
    }

    private void buildAPIsFromRegistry(SynapseConfiguration configuration, Properties properties) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Building the APIs from the carbon registry");
        }
        APIRegistryStore apiStore = new APIRegistryStore(this.registry, this.configName);
        for (OMElement apiElem : apiStore.getElements()) {
            try {
                API api = SynapseXMLConfigurationFactory.defineAPI((SynapseConfiguration)configuration, (OMElement)apiElem);
                String fileName = apiElem.getAttributeValue(FILE_NAME_ATTR);
                if (fileName == null) continue;
                api.setFileName(fileName);
                fileName = this.synapseXMLLocation + File.separator + "api" + File.separator + fileName;
                configuration.getArtifactDeploymentStore().addArtifact(fileName, api.getName());
            }
            catch (SynapseException e) {
                this.handleErrorGracefully("API", e);
            }
        }
    }

    private void buildMessageStoresFromRegistry(SynapseConfiguration configuration, Properties properties) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Build the message stores from the carbon registry");
        }
        MessageStoreRegistryStore messageStoreRegistryStore = new MessageStoreRegistryStore(this.registry, this.configName);
        for (OMElement messageStoreElement : messageStoreRegistryStore.getElements()) {
            try {
                SynapseXMLConfigurationFactory.defineMessageStore((SynapseConfiguration)configuration, (OMElement)messageStoreElement, (Properties)properties);
            }
            catch (SynapseException e) {
                this.handleErrorGracefully("messagestore", e);
            }
        }
    }

    private void buildMessageProcessorsFromRegistry(SynapseConfiguration configuration, Properties properties) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Build the message processors from the carbon registry");
        }
        MessageProcessorRegistryStore messageProcessorRegistryStore = new MessageProcessorRegistryStore(this.registry, this.configName);
        for (OMElement messageProcessorElement : messageProcessorRegistryStore.getElements()) {
            try {
                SynapseXMLConfigurationFactory.defineMessageProcessor((SynapseConfiguration)configuration, (OMElement)messageProcessorElement, (Properties)properties);
            }
            catch (SynapseException e) {
                this.handleErrorGracefully("messageprocessor", e);
            }
        }
    }

    public void handleErrorGracefully(String component, SynapseException e) {
        if (!this.failSafeConfigurationLoading) {
            throw e;
        }
        this.log.warn((Object)("Error occurred while loading a " + component + " configuration from the registry."), (Throwable)e);
    }
}

