/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediation.initializer;

import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.config.SynapseConfigUtils;
import org.apache.synapse.config.SynapseConfiguration;
import org.apache.synapse.util.resolver.ResourceMap;
import org.apache.synapse.util.resolver.UserDefinedWSDLLocator;
import org.wso2.carbon.mediation.initializer.RegistryDependency;
import org.xml.sax.InputSource;

public class RegistryWSDLLocator
implements UserDefinedWSDLLocator {
    private InputSource baseInputSource;
    private String baseURI;
    private ResourceMap resourceMap;
    private String wsdlKey;
    private String latestImportURI;
    private SynapseConfiguration synCfg;
    private static final Log log = LogFactory.getLog(RegistryWSDLLocator.class);

    public void init(InputSource baseInputSource, String baseURI, ResourceMap resourceMap, SynapseConfiguration synCfg, String wsdlKey) {
        this.baseInputSource = baseInputSource;
        this.baseURI = baseURI;
        this.resourceMap = resourceMap;
        this.synCfg = synCfg;
        this.wsdlKey = wsdlKey;
    }

    public InputSource getImportInputSource(String parentLocation, String relativeLocation) {
        InputSource result = null;
        String key2 = null;
        if (this.resourceMap != null) {
            result = this.resourceMap.resolve(this.synCfg, relativeLocation);
        }
        if (this.wsdlKey != null && result == null) {
            RegistryDependency regWSDLDep;
            Map<String, String> dependencyMap;
            if (log.isDebugEnabled()) {
                log.info((Object)("Starting to resolve imported resources " + relativeLocation + " using the dependencies got from wsdlKey " + this.wsdlKey));
            }
            if ((dependencyMap = (regWSDLDep = new RegistryDependency(this.wsdlKey)).getDependencies()) != null) {
                Set<String> keys = dependencyMap.keySet();
                for (String key2 : keys) {
                    String constructedPath;
                    String value = dependencyMap.get(key2);
                    if (!value.endsWith(constructedPath = regWSDLDep.constructRegistryPathToRelativePath(relativeLocation))) continue;
                    if (this.resourceMap == null) {
                        this.resourceMap = new ResourceMap();
                    }
                    this.resourceMap.addResource(relativeLocation, value);
                    this.latestImportURI = relativeLocation;
                    break;
                }
                result = this.resourceMap.resolve(this.synCfg, relativeLocation);
            }
        } else if (result == null) {
            String location = SynapseConfigUtils.resolveRelativeURI((String)parentLocation, (String)relativeLocation);
            result = new InputSource(location);
            this.latestImportURI = location;
        } else {
            this.latestImportURI = relativeLocation;
        }
        return result;
    }

    public String getLatestImportURI() {
        return this.latestImportURI;
    }

    public InputSource getBaseInputSource() {
        return this.baseInputSource;
    }

    public String getBaseURI() {
        return this.baseURI;
    }

    public void close() {
    }
}

