/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediation.initializer.persistence.registry;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.axiom.om.OMElement;
import org.apache.synapse.config.xml.XMLConfigConstants;
import org.wso2.carbon.application.deployer.AppDeployerUtils;
import org.wso2.carbon.mediation.initializer.persistence.registry.AbstractRegistryStore;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.session.UserRegistry;

public class EventSourceRegistryStore
extends AbstractRegistryStore {
    public EventSourceRegistryStore(UserRegistry registry, String configName) {
        super(registry, configName);
        this.createCollection(this.getConfigurationPath());
    }

    @Override
    public Collection<OMElement> getElements() {
        ArrayList<OMElement> eventSourceElements = new ArrayList();
        try {
            eventSourceElements = this.getChildElementsInPath(this.getConfigurationPath());
        }
        catch (RegistryException e) {
            this.handleException("Couldn't get the list of event sources from the registry in path : " + this.getConfigurationPath(), (Exception)((Object)e));
        }
        return eventSourceElements;
    }

    @Override
    public OMElement getElement(String name) {
        return null;
    }

    @Override
    public void persistElement(String name, OMElement element, String fileName) {
        if (element.getLocalName().equals(XMLConfigConstants.EVENT_SOURCE_ELT.getLocalPart())) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Persisting event source : " + name + " to the registry"));
            }
            String eventSourcePath = this.getConfigurationPath() + "/" + name;
            AppDeployerUtils.attachArtifactToOwnerApp((String)fileName, (String)"synapse/event-source", (String)name, (int)this.registry.getTenantId());
            try {
                this.persistElement(element, eventSourcePath, fileName);
            }
            catch (RegistryException e) {
                this.handleException("Unable to persist the event source in the path : " + eventSourcePath, (Exception)((Object)e));
            }
        } else {
            this.handleException("The element provided to persist is not an event source");
        }
    }

    @Override
    public void deleteElement(String name) {
        String eventSourcePath = this.getConfigurationPath() + "/" + name;
        try {
            if (this.registry.resourceExists(eventSourcePath)) {
                this.registry.delete(eventSourcePath);
            }
        }
        catch (RegistryException e) {
            this.handleException("Error in deleting the event source at path : " + eventSourcePath, (Exception)((Object)e));
        }
    }

    @Override
    protected String getConfigurationPath() {
        return this.getConfigurationRoot() + "/" + "event-sources";
    }
}

