/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.user.api;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class RealmConfiguration {
    protected String userStoreClass = null;
    protected String authorizationManagerClass = null;
    protected String addAdmin = null;
    protected String adminRoleName = null;
    protected String adminUserName = null;
    protected String adminPassword = null;
    protected String everyOneRoleName = null;
    protected String realmClassName = null;
    protected String description = null;
    protected List<String> restrictedDomainsForSelfSignUp = new ArrayList<String>();
    protected List<String> reservedRoleNames = new ArrayList<String>();
    protected String isOverrideUsernameClaimFromInternalUsername = "false";
    protected Map<String, String> userStoreProperties = new HashMap<String, String>();
    protected Map<String, String> authzProperties = new HashMap<String, String>();
    protected Map<String, String> realmProperties = new HashMap<String, String>();
    protected int tenantId = -1234;
    protected Date persistedTimestamp;
    protected boolean passwordsExternallyManaged = false;
    protected boolean isPrimary = false;
    protected RealmConfiguration secondaryRealmConfig;
    protected Map<String, Map<String, String>> multipleCredentialProps = new HashMap<String, Map<String, String>>();

    public boolean isRestrictedDomainForSlefSignUp(String domain) {
        return this.restrictedDomainsForSelfSignUp.contains(domain.toUpperCase());
    }

    public boolean isReservedRoleName(String roleName) {
        return this.reservedRoleNames.contains(roleName.toUpperCase());
    }

    public void addRestrictedDomainForSelfSignUp(String domain) {
        if (domain != null) {
            this.restrictedDomainsForSelfSignUp.add(domain.toUpperCase());
        }
    }

    public void addReservedRoleName(String roleName) {
        if (roleName != null) {
            this.reservedRoleNames.add(roleName.toUpperCase());
        }
    }

    public boolean isPrimary() {
        return this.isPrimary;
    }

    public void setPrimary(boolean priamry) {
        this.isPrimary = priamry;
    }

    public boolean isPasswordsExternallyManaged() {
        return this.passwordsExternallyManaged;
    }

    public void setPasswordsExternallyManaged(boolean passwordsExternallyManaged) {
        this.passwordsExternallyManaged = passwordsExternallyManaged;
    }

    public RealmConfiguration cloneRealmConfigurationWithoutSecondary() throws Exception {
        return this.cloneRealmConfiguration(false);
    }

    public RealmConfiguration cloneRealmConfiguration() throws Exception {
        return this.cloneRealmConfiguration(true);
    }

    private RealmConfiguration cloneRealmConfiguration(boolean needSecondary) throws Exception {
        RealmConfiguration realmConfig = new RealmConfiguration();
        realmConfig.setRealmClassName(this.realmClassName);
        realmConfig.setUserStoreClass(this.userStoreClass);
        realmConfig.setAuthorizationManagerClass(this.authorizationManagerClass);
        realmConfig.setAddAdmin(this.addAdmin);
        realmConfig.setAdminRoleName(this.adminRoleName);
        realmConfig.setAdminUserName(this.adminUserName);
        realmConfig.setAdminPassword(this.adminPassword);
        realmConfig.setEveryOneRoleName(this.everyOneRoleName);
        realmConfig.setPrimary(this.isPrimary);
        if (needSecondary && this.secondaryRealmConfig != null) {
            realmConfig.setSecondaryRealmConfig(this.secondaryRealmConfig.cloneRealmConfiguration());
        }
        Iterator<String> domainNameItr = this.restrictedDomainsForSelfSignUp.iterator();
        while (domainNameItr.hasNext()) {
            realmConfig.addRestrictedDomainForSelfSignUp(domainNameItr.next());
        }
        Iterator<String> roleNameIts = this.reservedRoleNames.iterator();
        while (roleNameIts.hasNext()) {
            realmConfig.addReservedRoleName(roleNameIts.next());
        }
        HashMap<String, String> mapUserstore = new HashMap<String, String>();
        mapUserstore.putAll(this.userStoreProperties);
        realmConfig.setUserStoreProperties(mapUserstore);
        HashMap<String, String> mapAuthz = new HashMap<String, String>();
        mapAuthz.putAll(this.authzProperties);
        realmConfig.setAuthzProperties(mapAuthz);
        HashMap<String, String> mapRealm = new HashMap<String, String>();
        mapRealm.putAll(this.realmProperties);
        realmConfig.setRealmProperties(mapRealm);
        return realmConfig;
    }

    public RealmConfiguration getSecondaryRealmConfig() {
        return this.secondaryRealmConfig;
    }

    public void setSecondaryRealmConfig(RealmConfiguration secondaryRealm) {
        this.secondaryRealmConfig = secondaryRealm;
    }

    public String getAuthorizationPropertyValue(String propertyName) {
        return this.authzProperties.get(propertyName);
    }

    public String getRealmProperty(String propertyName) {
        return this.realmProperties.get(propertyName);
    }

    public String getUserStoreProperty(String propertyName) {
        return this.userStoreProperties.get(propertyName);
    }

    public String getAddAdmin() {
        return this.addAdmin;
    }

    public void setAddAdmin(String addAdmin) {
        this.addAdmin = addAdmin;
    }

    public String getAdminRoleName() {
        return this.adminRoleName;
    }

    public void setAdminRoleName(String adminRoleName) {
        this.adminRoleName = adminRoleName;
    }

    public String getAdminUserName() {
        return this.adminUserName;
    }

    public void setAdminUserName(String adminUserName) {
        this.adminUserName = adminUserName;
    }

    public String getAdminPassword() {
        return this.adminPassword;
    }

    public void setAdminPassword(String adminPassword) {
        this.adminPassword = adminPassword;
    }

    public String getEveryOneRoleName() {
        return this.everyOneRoleName;
    }

    public void setEveryOneRoleName(String everyOneRoleName) {
        this.everyOneRoleName = everyOneRoleName;
    }

    public String getAuthorizationManagerClass() {
        return this.authorizationManagerClass;
    }

    public void setAuthorizationManagerClass(String authorizationManagerClass) {
        this.authorizationManagerClass = authorizationManagerClass;
    }

    public String getAuthorizationManagerProperty(String key) {
        return this.authzProperties.get(key);
    }

    public String getUserStoreClass() {
        return this.userStoreClass;
    }

    public void setUserStoreClass(String userStoreClass) {
        this.userStoreClass = userStoreClass;
    }

    public Map<String, String> getUserStoreProperties() {
        return this.userStoreProperties;
    }

    public void setUserStoreProperties(Map<String, String> userStoreProperties) {
        this.userStoreProperties = userStoreProperties;
    }

    public Map<String, String> getAuthzProperties() {
        return this.authzProperties;
    }

    public void setAuthzProperties(Map<String, String> authzProperties) {
        this.authzProperties = authzProperties;
    }

    public Map<String, String> getRealmProperties() {
        return this.realmProperties;
    }

    public void setRealmProperties(Map<String, String> realmProperties) {
        this.realmProperties = realmProperties;
    }

    public int getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(int tenantId) {
        this.tenantId = tenantId;
    }

    public Date getPersistedTimestamp() {
        if (null != this.persistedTimestamp) {
            return (Date)this.persistedTimestamp.clone();
        }
        return null;
    }

    public void setPersistedTimestamp(Date persistedTimestamp) {
        this.persistedTimestamp = null != persistedTimestamp ? (Date)persistedTimestamp.clone() : null;
    }

    public String getRealmClassName() {
        if (this.realmClassName == null) {
            return "org.wso2.carbon.user.core.common.DefaultRealm";
        }
        return this.realmClassName;
    }

    public void setRealmClassName(String realmClassName) {
        this.realmClassName = realmClassName;
    }

    public void addMultipleCredentialProperties(String userStoreClass, Map<String, String> multipleCredentialsProperties) {
        this.multipleCredentialProps.put(userStoreClass, multipleCredentialsProperties);
    }

    public Map<String, Map<String, String>> getMultipleCredentialProps() {
        return this.multipleCredentialProps;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getIsOverrideUsernameClaimFromInternalUsername() {
        return this.isOverrideUsernameClaimFromInternalUsername;
    }

    public void setIsOverrideUsernameClaimFromInternalUsername(String isOverrideUsernameClaimFromInternalUsername) {
        this.isOverrideUsernameClaimFromInternalUsername = isOverrideUsernameClaimFromInternalUsername;
    }
}

