/*
 *  Copyright (c) 2005-2009, WSO2 Inc. (http://www.wso2.org) All Rights Reserved.
 *
 *  WSO2 Inc. licenses this file to you under the Apache License,
 *  Version 2.0 (the "License"); you may not use this file except
 *  in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License.
 *
 */
package org.wso2.carbon.utils.logging;

import org.apache.log4j.Category;
import org.apache.log4j.Priority;
import org.apache.log4j.spi.LoggingEvent;
/**
 * This class is used to store information regarding a LogEvent along with tenant information.
 *
 * @deprecated tenantId is appended using Log4J2 Converter
 */
public class TenantAwareLoggingEvent extends LoggingEvent {

    private String tenantId;
    private String serviceName;

    private static final long serialVersionUID = 1L;

    public TenantAwareLoggingEvent(String fqnOfCategoryClass, Category logger, long timeStamp,
                                   Priority level, Object message, Throwable throwable) {
        super(fqnOfCategoryClass, logger, timeStamp, level, message, throwable);

    }
    public String getTenantId() {
        return tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public String getServiceName() {
        return serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

}
