/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.indexing;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.registry.indexing.AsyncIndexer;
import org.wso2.carbon.registry.indexing.RegistryConfigLoader;
import org.wso2.carbon.registry.indexing.ResourceSubmitter;
import org.wso2.carbon.registry.indexing.Utils;
import org.wso2.carbon.registry.indexing.indexer.Indexer;

public class IndexingManager {
    private static final Log log = LogFactory.getLog(IndexingManager.class);
    private static volatile IndexingManager instance;
    private UserRegistry registry;
    private RegistryConfigLoader registryConfig;
    private AsyncIndexer indexer;
    private ScheduledExecutorService submittingExecutor;
    private ScheduledExecutorService indexingExecutor;
    private Map<Integer, Date> lastAccessTime = new ConcurrentHashMap<Integer, Date>();
    private volatile Pattern[] patterns = null;

    private IndexingManager() {
        try {
            this.registry = Utils.getRegistryService().getRegistry("wso2.system.user");
            this.registryConfig = RegistryConfigLoader.getInstance();
            this.indexer = new AsyncIndexer();
        }
        catch (RegistryException e) {
            log.error((Object)"Could not initialize registry for indexing", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IndexingManager getInstance() {
        if (instance != null) return instance;
        Class<IndexingManager> clazz = IndexingManager.class;
        synchronized (IndexingManager.class) {
            if (instance != null) return instance;
            instance = new IndexingManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public synchronized void startIndexing() {
        this.stopIndexing();
        if (this.registryConfig.IsStartIndexing()) {
            this.submittingExecutor = Executors.newSingleThreadScheduledExecutor();
            this.submittingExecutor.scheduleWithFixedDelay(new ResourceSubmitter(this), this.getStartingDelayInSecs(), this.getIndexingFreqInSecs(), TimeUnit.SECONDS);
            this.indexingExecutor = Executors.newSingleThreadScheduledExecutor();
            this.indexingExecutor.scheduleWithFixedDelay(this.indexer, this.getStartingDelayInSecs(), this.getIndexingFreqInSecs(), TimeUnit.SECONDS);
            this.readLastAccessTime();
        }
    }

    public synchronized void restartIndexing() {
        this.stopIndexing();
        try {
            this.registry.delete(this.getLastAccessTimeLocation());
        }
        catch (RegistryException e) {
            log.error((Object)"Could not delete last activity time to restart indexing", (Throwable)e);
        }
        this.startIndexing();
    }

    public synchronized void stopIndexing() {
        if (this.submittingExecutor != null) {
            this.submittingExecutor.shutdownNow();
            this.submittingExecutor = null;
        }
        if (this.indexingExecutor != null) {
            this.indexingExecutor.shutdownNow();
            this.indexingExecutor = null;
        }
        this.writeLastAccessTime();
    }

    public long getStartingDelayInSecs() {
        return this.registryConfig.getStartingDelayInSecs();
    }

    public boolean canIndex(String path) {
        if (this.patterns == null) {
            this.patterns = this.registryConfig.getExclusionPatterns();
        }
        for (Pattern pattern : this.patterns) {
            if (!pattern.matcher(path).matches()) continue;
            return false;
        }
        return true;
    }

    public long getIndexingFreqInSecs() {
        return this.registryConfig.getIndexingFreqInSecs();
    }

    public String getLastAccessTimeLocation() {
        return this.registryConfig.getLastAccessTimeLocation();
    }

    private AsyncIndexer getIndexer() {
        return this.indexer;
    }

    public long getBatchSize() {
        return this.registryConfig.getBatchSize();
    }

    public int getIndexerPoolSize() {
        return this.registryConfig.getIndexerPoolSize();
    }

    public boolean isCacheSkipped() {
        return this.registryConfig.isSkipIndexingCache();
    }

    public void deleteFromIndex(String oldPath, int tenantId) throws RegistryException {
        this.getIndexer().getClient().deleteFromIndex(oldPath, tenantId);
    }

    public void submitFileForIndexing(int tenantID, String tenantDomain, String path, String sourceURL) throws RegistryException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Submitting file " + path + " for Indexing"));
        }
        this.getIndexer().addFile(new AsyncIndexer.File2Index(path, tenantID, tenantDomain, sourceURL));
    }

    public Indexer getIndexerForMediaType(String mimeType) {
        if (mimeType != null) {
            for (Map.Entry<String, Indexer> entry : this.registryConfig.getIndexerMap().entrySet()) {
                if (!Pattern.matches(entry.getKey(), mimeType)) continue;
                return entry.getValue();
            }
        }
        return null;
    }

    public UserRegistry getRegistry(int tenantId) {
        if (tenantId == -1234) {
            return this.registry;
        }
        try {
            return Utils.getRegistryService().getRegistry("wso2.system.user", tenantId);
        }
        catch (RegistryException ignore) {
            return null;
        }
    }

    public Date getLastAccessTime(int tenantId) {
        return this.lastAccessTime.get(tenantId);
    }

    public void setLastAccessTime(int tenantId, Date lastAccessTime) {
        if (lastAccessTime != null) {
            this.lastAccessTime.put(tenantId, lastAccessTime);
        }
    }

    private void writeLastAccessTime() {
        try {
            if (this.lastAccessTime.size() > 0) {
                Resource resource = this.registry.newResource();
                for (Map.Entry<Integer, Date> e : this.lastAccessTime.entrySet()) {
                    resource.setProperty(String.valueOf(e.getKey()), String.valueOf(e.getValue().getTime()));
                }
                this.registry.put(this.getLastAccessTimeLocation(), resource);
            }
        }
        catch (RegistryException e) {
            log.error((Object)"Could not write last activity time when stopping indexing", (Throwable)e);
        }
    }

    private void readLastAccessTime() {
        try {
            Properties properties;
            String lastAccessTimeLocation = this.getLastAccessTimeLocation();
            if (this.registry.resourceExists(lastAccessTimeLocation) && (properties = this.registry.get(lastAccessTimeLocation).getProperties()) != null && properties.size() != 0) {
                for (Object key : properties.keySet()) {
                    this.lastAccessTime.put(Integer.parseInt((String)key), new Date(Long.parseLong((String)((List)properties.get(key)).get(0))));
                }
            }
        }
        catch (RegistryException e) {
            log.error((Object)"Could not read last activity time when starting indexing", (Throwable)e);
        }
    }
}

