/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.indexing;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.registry.core.LogEntry;
import org.wso2.carbon.registry.core.internal.RegistryCoreServiceComponent;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.registry.indexing.IndexingManager;
import org.wso2.carbon.registry.indexing.Utils;
import org.wso2.carbon.registry.indexing.internal.IndexingServiceComponent;
import org.wso2.carbon.registry.indexing.utils.IndexingUtils;
import org.wso2.carbon.user.api.Tenant;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.utils.WaitBeforeShutdownObserver;

public class ResourceSubmitter
implements Runnable {
    private static Log log = LogFactory.getLog(ResourceSubmitter.class);
    private IndexingManager indexingManager;
    private boolean taskComplete = false;
    private boolean isShutdown = false;

    protected ResourceSubmitter(IndexingManager indexingManager) {
        this.indexingManager = indexingManager;
        Utils.setWaitBeforeShutdownObserver(new WaitBeforeShutdownObserver(){

            public void startingShutdown() {
                ResourceSubmitter.this.isShutdown = true;
            }

            public boolean isTaskComplete() {
                return ResourceSubmitter.this.taskComplete;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            Tenant[] allTenants;
            PrivilegedCarbonContext.startTenantFlow();
            try {
                Date currentTime = this.indexingManager.getLastAccessTime(-1234);
                this.indexingManager.setLastAccessTime(-1234, this.submitResource(currentTime, -1234, "carbon.super"));
            }
            finally {
                PrivilegedCarbonContext.endTenantFlow();
            }
            for (Tenant tenant : allTenants = RegistryCoreServiceComponent.getRealmService().getTenantManager().getAllTenants()) {
                PrivilegedCarbonContext.startTenantFlow();
                try {
                    int tenantId = tenant.getId();
                    Date currentTime = this.indexingManager.getLastAccessTime(tenantId);
                    this.indexingManager.setLastAccessTime(tenantId, this.submitResource(currentTime, tenantId, tenant.getDomain()));
                }
                finally {
                    PrivilegedCarbonContext.endTenantFlow();
                }
            }
        }
        catch (UserStoreException userStoreException) {
            // empty catch block
        }
    }

    private Date submitResource(Date currentTime, int tenantId, String tenantDomain) {
        if (!IndexingServiceComponent.canIndexTenant(tenantId)) {
            return currentTime;
        }
        if (this.isShutdown || Thread.currentThread().isInterrupted()) {
            this.taskComplete = true;
            return currentTime;
        }
        PrivilegedCarbonContext carbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
        carbonContext.setTenantDomain(tenantDomain);
        carbonContext.setTenantId(tenantId);
        try {
            UserRegistry registry = this.indexingManager.getRegistry(tenantId);
            if (registry == null) {
                log.warn((Object)("Unable to submit resource for tenant " + tenantId + ". Unable to get registry instance"));
                return currentTime;
            }
            String lastAccessTimeLocation = this.indexingManager.getLastAccessTimeLocation();
            LogEntry[] entries = registry.getLogs(null, -1, null, this.indexingManager.getLastAccessTime(tenantId), new Date(), true);
            if (entries.length > 0) {
                Date temp = entries[0].getDate();
                if (currentTime == null || currentTime.before(temp)) {
                    currentTime = temp;
                }
                ArrayList<LogEntry> logEntryList = this.removeLogEntriesWithDuplicatePaths(entries);
                for (LogEntry logEntry : logEntryList) {
                    String path = logEntry.getResourcePath();
                    try {
                        if (path.equals(lastAccessTimeLocation)) continue;
                        if (logEntry.getAction() == 7) {
                            this.indexingManager.deleteFromIndex(logEntry.getResourcePath(), tenantId);
                            if (!log.isDebugEnabled()) continue;
                            log.debug((Object)("Resource Deleted: Resource at " + path + " will be deleted from Indexing Server"));
                            continue;
                        }
                        if (!IndexingUtils.isAuthorized(registry, path, "http://www.wso2.org/projects/registry/actions/get") || !registry.resourceExists(path)) continue;
                        if (logEntry.getAction() == 1) {
                            this.indexingManager.submitFileForIndexing(tenantId, tenantDomain, path, null);
                            if (!log.isDebugEnabled()) continue;
                            log.debug((Object)("Resource Updated: Resource at " + path + " has been submitted to the Indexing Server"));
                            continue;
                        }
                        if (logEntry.getAction() == 3) {
                            this.indexingManager.submitFileForIndexing(tenantId, tenantDomain, path, null);
                            if (!log.isDebugEnabled()) continue;
                            log.debug((Object)("Resource comment deleted: Resource at " + path + " has been submitted to the Indexing Server"));
                            continue;
                        }
                        if (logEntry.getAction() == 16) {
                            this.indexingManager.submitFileForIndexing(tenantId, tenantDomain, path, null);
                            if (!log.isDebugEnabled()) continue;
                            log.debug((Object)("Resource association removed: Resource at " + path + " has been submitted to the Indexing Server"));
                            continue;
                        }
                        if (logEntry.getAction() == 5) {
                            this.indexingManager.submitFileForIndexing(tenantId, tenantDomain, path, null);
                            if (!log.isDebugEnabled()) continue;
                            log.debug((Object)("Resource tag removed: Resource at " + path + " has been submitted to the Indexing Server"));
                            continue;
                        }
                        if (logEntry.getAction() == 0) {
                            this.indexingManager.submitFileForIndexing(tenantId, tenantDomain, path, null);
                            if (!log.isDebugEnabled()) continue;
                            log.debug((Object)("Resource Inserted: Resource at " + path + " has been submitted to the Indexing Server"));
                            continue;
                        }
                        if (logEntry.getAction() == 4) {
                            this.indexingManager.submitFileForIndexing(tenantId, tenantDomain, path, null);
                            if (!log.isDebugEnabled()) continue;
                            log.debug((Object)("Resource tag added: Resource at " + path + " has been submitted to the Indexing Server"));
                            continue;
                        }
                        if (logEntry.getAction() == 2) {
                            this.indexingManager.submitFileForIndexing(tenantId, tenantDomain, path, null);
                            if (!log.isDebugEnabled()) continue;
                            log.debug((Object)("Resource comment added: Resource at " + path + " has been submitted to the Indexing Server"));
                            continue;
                        }
                        if (logEntry.getAction() == 15) {
                            this.indexingManager.submitFileForIndexing(tenantId, tenantDomain, path, null);
                            if (!log.isDebugEnabled()) continue;
                            log.debug((Object)("Resource association added: Resource at " + path + " has been submitted to the Indexing Server"));
                            continue;
                        }
                        if (logEntry.getAction() == 10) {
                            this.indexingManager.submitFileForIndexing(tenantId, tenantDomain, path, null);
                            this.indexingManager.deleteFromIndex(logEntry.getActionData(), tenantId);
                            if (!log.isDebugEnabled()) continue;
                            log.debug((Object)("Resource Moved: Resource at " + path + " has been submitted to the Indexing Server"));
                            continue;
                        }
                        if (logEntry.getAction() == 11) {
                            path = logEntry.getActionData();
                            this.indexingManager.submitFileForIndexing(tenantId, tenantDomain, path, null);
                            if (!log.isDebugEnabled()) continue;
                            log.debug((Object)("Resource Copied : Resource at " + path + " has been submitted to the Indexing Server"));
                            continue;
                        }
                        if (logEntry.getAction() == 9) {
                            this.indexingManager.submitFileForIndexing(tenantId, tenantDomain, path, null);
                            if (!log.isDebugEnabled()) continue;
                            log.debug((Object)("Resource Renamed : Resource at " + path + " has been submitted to the Indexing Server"));
                            continue;
                        }
                        if (logEntry.getAction() != 8) continue;
                        this.indexingManager.submitFileForIndexing(tenantId, tenantDomain, path, null);
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)("Resource Res+tore : Resource at " + path + " has been submitted to the Indexing Server"));
                    }
                    catch (Exception e) {
                        log.warn((Object)("An error occurred while submitting the resource for indexing, path: " + path), (Throwable)e);
                    }
                }
            } else if (tenantId != -1234 && IndexingServiceComponent.isTenantIndexLoadedFromLogin(tenantId) != null && !IndexingServiceComponent.isTenantIndexLoadedFromLogin(tenantId).booleanValue()) {
                IndexingServiceComponent.unloadTenantIndex(tenantId);
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)("last successfully indexed activity time is : " + this.indexingManager.getLastAccessTime(tenantId).toString()));
            }
        }
        catch (Throwable e) {
            log.warn((Object)"An error occurred while submitting resources for indexing", e);
        }
        return currentTime;
    }

    private ArrayList<LogEntry> removeLogEntriesWithDuplicatePaths(LogEntry[] logEntries) {
        HashSet<String> set = new HashSet<String>();
        ArrayList<LogEntry> newList = new ArrayList<LogEntry>();
        for (int i = 0; i < logEntries.length; ++i) {
            if (set.contains(logEntries[i].getResourcePath()) || logEntries[i].getAction() != 7 && logEntries[i].getAction() != 1 && logEntries[i].getAction() != 3 && logEntries[i].getAction() != 5 && logEntries[i].getAction() != 0 && logEntries[i].getAction() != 4 && logEntries[i].getAction() != 2 && logEntries[i].getAction() != 15 && logEntries[i].getAction() != 10 && logEntries[i].getAction() != 11 && logEntries[i].getAction() != 9 && logEntries[i].getAction() != 8) continue;
            if (logEntries[i].getAction() != 11) {
                set.add(logEntries[i].getResourcePath());
            }
            newList.add(logEntries[i]);
        }
        return newList;
    }
}

