/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.indexing.filter;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.ResourcePath;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.jdbc.handlers.RequestContext;
import org.wso2.carbon.registry.core.jdbc.handlers.filters.Filter;
import org.wso2.carbon.registry.core.utils.RegistryUtils;
import org.wso2.carbon.registry.core.utils.VersionedPath;

public class MediaTypeFilter
extends Filter {
    private String mediaTypeRegEx;
    private Pattern pattern;
    private static String defaultRegex = "application.*";

    public String getMediaTypeRegEx() {
        return this.mediaTypeRegEx;
    }

    public void setMediaTypeRegEx(String mediaTypeRegEx) {
        this.mediaTypeRegEx = mediaTypeRegEx;
    }

    public MediaTypeFilter() {
        this(defaultRegex);
    }

    public MediaTypeFilter(String mediaTypeRegEx) {
        this.mediaTypeRegEx = mediaTypeRegEx;
        this.pattern = Pattern.compile(mediaTypeRegEx);
    }

    public int hashCode() {
        return this.getEqualsComparator().hashCode();
    }

    private String getEqualsComparator() {
        StringBuffer sb = new StringBuffer();
        sb.append(((Object)((Object)this)).getClass().getName());
        sb.append("|");
        sb.append(this.mediaTypeRegEx);
        sb.append("|");
        sb.append(this.invert);
        return sb.toString();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (other instanceof MediaTypeFilter) {
            MediaTypeFilter otherMediaTypeMatcher = (MediaTypeFilter)((Object)other);
            return this.getEqualsComparator().equals(otherMediaTypeMatcher.getEqualsComparator());
        }
        return false;
    }

    public boolean handleGet(RequestContext requestContext) throws RegistryException {
        String mType;
        VersionedPath versionedPath;
        String mediaType;
        ResourcePath resourcePath = requestContext.getResourcePath();
        if (resourcePath.parameterExists("new") && (mediaType = resourcePath.getParameterValue("mediaType")) != null) {
            Matcher matcher = this.pattern.matcher(mediaType);
            return matcher.matches();
        }
        Resource resource = requestContext.getResource();
        if (resource == null && (versionedPath = RegistryUtils.getVersionedPath((ResourcePath)requestContext.getResourcePath())).getVersion() == -1L) {
            resource = requestContext.getRepository().get(requestContext.getResourcePath().getPath());
            requestContext.setResource(resource);
        }
        if (resource != null && (mType = resource.getMediaType()) != null) {
            Matcher matcher = this.pattern.matcher(mType);
            return matcher.matches();
        }
        return false;
    }

    public boolean handlePut(RequestContext requestContext) throws RegistryException {
        Resource resource = requestContext.getResource();
        if (resource == null) {
            return false;
        }
        String mType = resource.getMediaType();
        if (mType != null) {
            Matcher matcher = this.pattern.matcher(mType);
            return matcher.matches();
        }
        return false;
    }

    public boolean handleImportResource(RequestContext requestContext) throws RegistryException {
        Resource resource = requestContext.getResource();
        if (resource == null) {
            return false;
        }
        String mType = resource.getMediaType();
        if (mType != null) {
            Matcher matcher = this.pattern.matcher(mType);
            return matcher.matches();
        }
        return false;
    }

    public boolean handleDelete(RequestContext requestContext) throws RegistryException {
        String mType;
        Resource resource = requestContext.getResource();
        if (resource == null) {
            resource = requestContext.getRepository().get(requestContext.getResourcePath().getPath());
            requestContext.setResource(resource);
        }
        if (resource != null && (mType = resource.getMediaType()) != null) {
            Matcher matcher = this.pattern.matcher(mType);
            return matcher.matches();
        }
        return false;
    }

    public boolean handlePutChild(RequestContext requestContext) throws RegistryException {
        String parentMediaType;
        Collection parentCollection = requestContext.getParentCollection();
        if (parentCollection == null) {
            Resource parentResource;
            VersionedPath versionedPath;
            String parentPath = requestContext.getParentPath();
            if (parentPath == null) {
                parentPath = RegistryUtils.getParentPath((String)requestContext.getResourcePath().getPath());
                requestContext.setParentPath(parentPath);
            }
            if ((versionedPath = RegistryUtils.getVersionedPath((ResourcePath)requestContext.getResourcePath())).getVersion() == -1L && (parentResource = requestContext.getRepository().get(parentPath)) != null) {
                if (parentResource instanceof Collection) {
                    parentCollection = (Collection)parentResource;
                    requestContext.setParentCollection(parentCollection);
                } else {
                    String msg = "There already exist non collection resource." + parentPath + "Child can only be added to collections";
                    throw new RegistryException(msg);
                }
            }
        }
        if (parentCollection != null && (parentMediaType = parentCollection.getMediaType()) != null) {
            Matcher matcher = this.pattern.matcher(parentMediaType);
            return matcher.matches();
        }
        return false;
    }

    public boolean handleImportChild(RequestContext requestContext) throws RegistryException {
        String parentMediaType;
        Collection parentCollection = requestContext.getParentCollection();
        if (parentCollection == null) {
            VersionedPath versionedPath;
            String parentPath = requestContext.getParentPath();
            if (parentPath == null) {
                parentPath = RegistryUtils.getParentPath((String)requestContext.getResourcePath().getPath());
                requestContext.setParentPath(parentPath);
            }
            if ((versionedPath = RegistryUtils.getVersionedPath((ResourcePath)requestContext.getResourcePath())).getVersion() == -1L) {
                parentCollection = (Collection)requestContext.getRepository().get(parentPath);
                requestContext.setParentCollection(parentCollection);
            }
        }
        if (parentCollection != null && (parentMediaType = parentCollection.getMediaType()) != null) {
            Matcher matcher = this.pattern.matcher(parentMediaType);
            return matcher.matches();
        }
        return false;
    }
}

