/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.indexing.indexer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.core.Association;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.Comment;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.Tag;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.registry.core.utils.RegistryUtils;
import org.wso2.carbon.registry.indexing.AsyncIndexer;
import org.wso2.carbon.registry.indexing.IndexingManager;
import org.wso2.carbon.registry.indexing.indexer.Indexer;
import org.wso2.carbon.registry.indexing.indexer.IndexerException;
import org.wso2.carbon.registry.indexing.solr.IndexDocument;
import org.wso2.carbon.registry.indexing.solr.SolrClient;
import org.wso2.carbon.registry.indexing.utils.IndexingUtils;
import org.wso2.carbon.user.core.UserRealm;
import org.wso2.carbon.user.core.UserStoreException;

public class IndexDocumentCreator {
    private final AsyncIndexer.File2Index file2Index;
    private Indexer indexer;
    private boolean isMediaTypeSet = false;
    private String resourcePath = null;
    private UserRegistry registry;
    private Resource resource = null;
    private static final Log log = LogFactory.getLog(IndexDocumentCreator.class);
    private static final String FIELD_ALLOWED_ROLES = "allowedRoles";
    private Map<String, List<String>> attributes = new HashMap<String, List<String>>();

    public IndexDocumentCreator(AsyncIndexer.File2Index file2Index, Resource resource) {
        this.file2Index = file2Index;
        this.resource = resource;
        this.registry = IndexingManager.getInstance().getRegistry(file2Index.tenantId);
        this.resourcePath = file2Index.path;
    }

    public void createIndexDocument() throws RegistryException, IndexerException {
        IndexDocument indexDocument;
        this.file2Index.lcName = this.resource.getProperty("registry.LC.name");
        this.file2Index.lcState = this.file2Index.lcName != null ? this.resource.getProperty("registry.lifecycle." + this.file2Index.lcName + ".state") : null;
        this.file2Index.mediaType = this.resource.getMediaType();
        if (!(this.resource instanceof Collection) && IndexingManager.getInstance().getIndexerForMediaType(this.file2Index.mediaType) != null) {
            this.file2Index.data = IndexingUtils.getByteContent(this.resource, this.file2Index.sourceURL);
        }
        if ((indexDocument = this.getIndexDocument()).getFields() != null) {
            this.attributes = indexDocument.getFields();
        }
        this.addResourceName();
        this.addAuthor();
        this.addLastUpdateUser();
        this.addCreatedDate();
        this.addLastUpdatedDate();
        this.addMediaType();
        if (!(this.resource instanceof Collection)) {
            this.addComments();
            this.addTags();
            this.addAssociations();
        }
        this.addPropertyData();
        this.addAllowedRoles();
        indexDocument.setFields(this.attributes);
        indexDocument.setTenantId(this.file2Index.tenantId);
        SolrClient.getInstance().addDocument(indexDocument);
    }

    private void addPropertyData() {
        Properties properties = this.resource.getProperties();
        Set<Object> keySet = properties.keySet();
        ArrayList<String> propertyList = new ArrayList<String>();
        if (keySet.size() > 0) {
            Object[] propertyKeys;
            for (Object key : propertyKeys = keySet.toArray()) {
                String propertyKey = key.toString();
                List values = (List)properties.get(key);
                String propertyValue = "";
                if (values != null) {
                    for (Object value : values) {
                        propertyValue = propertyValue + value + ",";
                    }
                } else {
                    propertyValue = ",";
                }
                propertyList.add(propertyKey + "," + propertyValue);
            }
        }
        if (propertyList.size() > 0) {
            this.attributes.put("propertyValues", propertyList);
        }
    }

    private void addAssociations() throws RegistryException {
        Association[] associations;
        try {
            associations = this.registry.getAllAssociations(this.resourcePath);
        }
        catch (RegistryException e) {
            String message = "Error at IndexDocumentCreator when getting Registry Associations.";
            log.error((Object)message, (Throwable)e);
            throw new RegistryException(message, (Throwable)e);
        }
        ArrayList<String> associationTypeList = new ArrayList<String>();
        ArrayList<String> associationDestinationList = new ArrayList<String>();
        if (associations != null && associations.length > 0) {
            for (Association association : associations) {
                associationTypeList.add(association.getAssociationType());
                associationDestinationList.add(association.getDestinationPath());
            }
            if (associationTypeList.size() > 0) {
                this.attributes.put("associationType", associationTypeList);
            }
            if (associationDestinationList.size() > 0) {
                this.attributes.put("associationDest", associationDestinationList);
            }
        }
    }

    private void addTags() throws RegistryException {
        Tag[] tags = this.registry.getTags(this.resourcePath);
        ArrayList<String> tagList = new ArrayList<String>();
        ArrayList<String> taxonomyList = new ArrayList<String>();
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                if (tag.getTagName().contains("/")) {
                    taxonomyList.add(tag.getTagName().toLowerCase());
                    continue;
                }
                tagList.add(tag.getTagName());
            }
            if (tagList.size() > 0) {
                this.attributes.put("tags", tagList);
            }
            if (taxonomyList.size() > 0) {
                this.attributes.put("taxonomy", taxonomyList);
            }
        }
    }

    private void addComments() throws RegistryException {
        Comment[] comments;
        try {
            comments = this.registry.getComments(this.resourcePath);
        }
        catch (RegistryException e) {
            String message = "Error at IndexDocumentCreator when getting Registry Comment.";
            log.error((Object)message, (Throwable)e);
            throw new RegistryException(message, (Throwable)e);
        }
        ArrayList<String> commentList = new ArrayList<String>();
        if (comments != null && comments.length > 0) {
            for (Comment comment : comments) {
                commentList.add(comment.getText());
            }
            if (commentList.size() > 0) {
                this.attributes.put("commentWords", commentList);
            }
        }
    }

    private void addMediaType() {
        for (Map.Entry<String, List<String>> mediaTypeList : this.attributes.entrySet()) {
            if (!mediaTypeList.getKey().equals("mediaType")) continue;
            this.isMediaTypeSet = true;
            break;
        }
        if (!this.isMediaTypeSet) {
            this.attributes.put("mediaType", Arrays.asList(this.file2Index.mediaType));
        }
    }

    private void addLastUpdatedDate() {
        Date updatedDate = this.resource.getLastModified();
        if (updatedDate != null) {
            this.attributes.put("lastUpdatedDate", Arrays.asList(updatedDate.toString()));
        }
    }

    private void addCreatedDate() {
        Date createdDate = this.resource.getCreatedTime();
        if (createdDate != null) {
            this.attributes.put("createdDate", Arrays.asList(createdDate.toString()));
        }
    }

    private void addLastUpdateUser() {
        String lastUpdatedBy = this.resource.getLastUpdaterUserName();
        if (lastUpdatedBy != null && !StringUtils.isEmpty((String)lastUpdatedBy)) {
            this.attributes.put("updater", Arrays.asList(lastUpdatedBy));
        }
    }

    private void addAuthor() {
        String createdBy = this.resource.getAuthorUserName();
        if (createdBy != null && !StringUtils.isEmpty((String)createdBy)) {
            this.attributes.put("author", Arrays.asList(createdBy));
        }
    }

    private void addResourceName() {
        String resourceName = RegistryUtils.getResourceName((String)this.resourcePath);
        if (StringUtils.isNotEmpty((String)resourceName)) {
            this.attributes.put("resourceName", Arrays.asList(resourceName));
        }
    }

    private IndexDocument getIndexDocument() throws RegistryException {
        IndexDocument indexDocument;
        if (this.file2Index.mediaType != null) {
            this.indexer = IndexingManager.getInstance().getIndexerForMediaType(this.file2Index.mediaType);
        }
        if (this.indexer != null) {
            try {
                indexDocument = this.indexer.getIndexedDocument(this.file2Index);
            }
            catch (RegistryException e) {
                String message = "Error at IndexDocumentCreator when getting IndexDocument for mediaType.";
                log.error((Object)message, (Throwable)e);
                throw new RegistryException(message, (Throwable)e);
            }
        } else {
            indexDocument = new IndexDocument();
        }
        indexDocument.setPath(this.file2Index.path);
        return indexDocument;
    }

    private void addAllowedRoles() throws RegistryException {
        try {
            UserRealm userRealm = this.registry.getUserRealm();
            Object[] allowedRoles = userRealm.getAuthorizationManager().getAllowedRolesForResource(this.resourcePath, "http://www.wso2.org/projects/registry/actions/get");
            if (log.isDebugEnabled()) {
                log.debug((Object)("Allowed Roles for the resource: " + this.resourcePath + " : " + Arrays.toString(allowedRoles)));
            }
            ArrayList<String> allowedRolesLowerCase = new ArrayList<String>();
            for (Object role : allowedRoles) {
                if (role == null) continue;
                allowedRolesLowerCase.add(((String)role).toLowerCase());
            }
            this.attributes.put(FIELD_ALLOWED_ROLES, allowedRolesLowerCase);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Indexed allowed roles for the resource: " + this.resourcePath + " : " + allowedRolesLowerCase));
            }
        }
        catch (UserStoreException e) {
            throw new RegistryException("Unable to retrieve allowed roles for resource", (Throwable)e);
        }
    }
}

