/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.indexing.indexer;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.solr.common.SolrException;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.utils.RegistryUtils;
import org.wso2.carbon.registry.indexing.AsyncIndexer;
import org.wso2.carbon.registry.indexing.indexer.Indexer;
import org.wso2.carbon.registry.indexing.solr.IndexDocument;

public class JSONIndexer
implements Indexer {
    public static final Log log = LogFactory.getLog(JSONIndexer.class);

    @Override
    public IndexDocument getIndexedDocument(AsyncIndexer.File2Index fileData) throws SolrException, RegistryException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Registry JSON Indexer is running");
        }
        return this.getPreProcessedDocument(fileData);
    }

    private IndexDocument getPreProcessedDocument(AsyncIndexer.File2Index fileData) throws RegistryException {
        String jsonAsString = RegistryUtils.decodeBytes((byte[])fileData.data);
        IndexDocument indexDocument = new IndexDocument(fileData.path, jsonAsString, null);
        HashMap<String, List<String>> attributes = new HashMap<String, List<String>>();
        if (fileData.mediaType != null) {
            attributes.put("mediaType", Arrays.asList(fileData.mediaType.toLowerCase()));
        }
        if (fileData.lcState != null) {
            attributes.put("lcState", Arrays.asList(fileData.lcState.toLowerCase()));
        }
        if (fileData.lcName != null) {
            attributes.put("lcName", Arrays.asList(fileData.lcName.toLowerCase()));
        }
        if (fileData.path != null) {
            attributes.put("overview_name", Arrays.asList(RegistryUtils.getResourceName((String)fileData.path).toLowerCase()));
        }
        indexDocument.setFields(attributes);
        return indexDocument;
    }
}

