/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.indexing.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.axis2.AxisFault;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.solr.client.solrj.response.FacetField;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.SolrException;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.registry.admin.api.indexing.IContentBasedSearchService;
import org.wso2.carbon.registry.common.ResourceData;
import org.wso2.carbon.registry.common.TermData;
import org.wso2.carbon.registry.common.services.RegistryAbstractAdmin;
import org.wso2.carbon.registry.common.utils.CommonUtil;
import org.wso2.carbon.registry.common.utils.UserUtil;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.pagination.PaginationContext;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.registry.indexing.IndexingManager;
import org.wso2.carbon.registry.indexing.indexer.IndexerException;
import org.wso2.carbon.registry.indexing.service.SearchResultsBean;
import org.wso2.carbon.registry.indexing.solr.SolrClient;
import org.wso2.carbon.user.core.UserRealm;
import org.wso2.carbon.user.core.UserStoreException;

public class ContentBasedSearchService
extends RegistryAbstractAdmin
implements IContentBasedSearchService {
    private static final Log log = LogFactory.getLog(ContentBasedSearchService.class);

    public SearchResultsBean getContentSearchResults(String searchQuery) throws AxisFault {
        try {
            UserRegistry registry = (UserRegistry)this.getRootRegistry();
            return this.searchContent(searchQuery, registry);
        }
        catch (Exception e) {
            log.error((Object)("Error " + e.getMessage() + "at the content search back end component."), (Throwable)e);
            return new SearchResultsBean();
        }
    }

    public SearchResultsBean getAttributeSearchResults(String[][] attributes) throws AxisFault {
        try {
            HashMap<String, String> map = new HashMap<String, String>(attributes.length);
            UserRegistry registry = (UserRegistry)this.getRootRegistry();
            for (String[] mapping : attributes) {
                map.put(mapping[0], mapping[1]);
            }
            return this.searchByAttribute(map, registry);
        }
        catch (Exception e) {
            log.error((Object)"Error occurred while getting the attribute search result.", (Throwable)e);
            return new SearchResultsBean();
        }
    }

    public SearchResultsBean getTermSearchResults(String[][] attributes) throws AxisFault {
        try {
            HashMap<String, String> map = new HashMap<String, String>(attributes.length);
            UserRegistry registry = (UserRegistry)this.getRootRegistry();
            for (String[] mapping : attributes) {
                map.put(mapping[0], mapping[1]);
            }
            return this.searchTerms(map, registry);
        }
        catch (RegistryException | IndexerException e) {
            log.error((Object)"Error occurred while getting the term search result.", e);
            return new SearchResultsBean();
        }
    }

    @Deprecated
    private String[] sortByDateIfRequired(String[] authorizedPaths, final UserRegistry registry, PaginationContext paginationContext) throws RegistryException {
        if (paginationContext.getSortBy().equalsIgnoreCase("meta_created_date")) {
            if (paginationContext.getSortOrder().equalsIgnoreCase("ASC")) {
                Arrays.sort(authorizedPaths, new Comparator<String>(){

                    @Override
                    public int compare(String path1, String path2) {
                        try {
                            return registry.getMetaData(path1).getCreatedTime().compareTo(registry.getMetaData(path2).getCreatedTime());
                        }
                        catch (RegistryException ex) {
                            return 0;
                        }
                    }
                });
            } else if (paginationContext.getSortOrder().equalsIgnoreCase("DES")) {
                Arrays.sort(authorizedPaths, new Comparator<String>(){

                    @Override
                    public int compare(String path1, String path2) {
                        try {
                            return registry.getMetaData(path2).getCreatedTime().compareTo(registry.getMetaData(path1).getCreatedTime());
                        }
                        catch (RegistryException ex) {
                            return 0;
                        }
                    }
                });
            }
        } else if (paginationContext.getSortBy().equalsIgnoreCase("meta_last_updated_date")) {
            if (paginationContext.getSortOrder().equalsIgnoreCase("ASC")) {
                Arrays.sort(authorizedPaths, new Comparator<String>(){

                    @Override
                    public int compare(String path1, String path2) {
                        try {
                            return registry.getMetaData(path1).getLastModified().compareTo(registry.getMetaData(path2).getLastModified());
                        }
                        catch (RegistryException ex) {
                            return 0;
                        }
                    }
                });
            } else if (paginationContext.getSortOrder().equalsIgnoreCase("DES")) {
                Arrays.sort(authorizedPaths, new Comparator<String>(){

                    @Override
                    public int compare(String path1, String path2) {
                        try {
                            return registry.getMetaData(path2).getLastModified().compareTo(registry.getMetaData(path1).getLastModified());
                        }
                        catch (RegistryException ex) {
                            return 0;
                        }
                    }
                });
            }
        }
        return authorizedPaths;
    }

    private SearchResultsBean searchContentInternal(String searchQuery, Map<String, String> attributes, UserRegistry registry) throws IndexerException, RegistryException {
        SearchResultsBean resultsBean = new SearchResultsBean();
        SolrClient client = SolrClient.getInstance();
        String advanceSearchAttribute = attributes.get("AdvanceSearch");
        if (advanceSearchAttribute != null && advanceSearchAttribute.equals("true")) {
            attributes.remove("AdvanceSearch");
        }
        SolrDocumentList results = new SolrDocumentList();
        try {
            results = attributes.size() > 0 ? client.query(registry.getTenantId(), attributes) : client.query(searchQuery, registry.getTenantId());
        }
        catch (SolrException e) {
            log.error((Object)"Invalid Search Query, query contains invalid characters", (Throwable)e);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("result received " + results));
        }
        ArrayList<ResourceData> filteredResults = new ArrayList<ResourceData>();
        for (SolrDocument solrDocument : results) {
            String path = this.getPathFromId((String)solrDocument.getFirstValue("id"));
            if (!this.isAuthorized(registry, path, "http://www.wso2.org/projects/registry/actions/get") || !registry.resourceExists(path)) continue;
            filteredResults.add(this.loadResourceByPath(registry, path));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("filtered results " + filteredResults + " for user " + registry.getUserName()));
        }
        resultsBean.setResourceDataList(filteredResults.toArray(new ResourceData[filteredResults.size()]));
        return resultsBean;
    }

    public SearchResultsBean searchContent(String searchQuery, UserRegistry registry) throws IndexerException, RegistryException {
        return this.searchContentInternal(searchQuery, Collections.emptyMap(), registry);
    }

    public SearchResultsBean searchByAttribute(Map<String, String> attributes, UserRegistry registry) throws IndexerException, RegistryException {
        return this.searchContentInternal(null, attributes, registry);
    }

    public void restartIndexing() throws RegistryException {
        IndexingManager manager = IndexingManager.getInstance();
        manager.restartIndexing();
    }

    private String getPathFromId(String id) {
        return id.substring(0, id.lastIndexOf("tenantId"));
    }

    private boolean isAuthorized(UserRegistry registry, String resourcePath, String action) throws RegistryException {
        UserRealm userRealm = registry.getUserRealm();
        String userName = ContentBasedSearchService.getLoggedInUserName();
        try {
            if (!userRealm.getAuthorizationManager().isUserAuthorized(userName, resourcePath, action)) {
                return false;
            }
        }
        catch (UserStoreException e) {
            throw new RegistryException("Error at Authorizing " + resourcePath + " with user " + userName + ":" + e.getMessage(), (Throwable)e);
        }
        return true;
    }

    private ResourceData loadResourceByPath(UserRegistry registry, String path) throws RegistryException {
        Resource child;
        ResourceData resourceData = new ResourceData();
        resourceData.setResourcePath(path);
        if (path != null) {
            if ("/".equals(path)) {
                resourceData.setName("root");
            } else {
                String[] parts = path.split("/");
                resourceData.setName(parts[parts.length - 1]);
            }
        }
        try {
            child = registry.get(path);
        }
        catch (RegistryException e) {
            log.debug((Object)("Failed to load resource from path which is returned from Solr search" + e.getMessage()));
            return null;
        }
        resourceData.setResourceType(child instanceof Collection ? "collection" : "resource");
        resourceData.setAuthorUserName(child.getAuthorUserName());
        resourceData.setDescription(child.getDescription());
        resourceData.setAverageRating(registry.getAverageRating(child.getPath()));
        Calendar createdDateTime = Calendar.getInstance();
        createdDateTime.setTime(child.getCreatedTime());
        resourceData.setCreatedOn(createdDateTime);
        CommonUtil.populateAverageStars((ResourceData)resourceData);
        String user = child.getProperty("registry.user");
        if (registry.getUserName().equals(user)) {
            resourceData.setPutAllowed(true);
            resourceData.setDeleteAllowed(true);
            resourceData.setGetAllowed(true);
        } else {
            resourceData.setPutAllowed(UserUtil.isPutAllowed((String)registry.getUserName(), (String)path, (UserRegistry)registry));
            resourceData.setDeleteAllowed(UserUtil.isDeleteAllowed((String)registry.getUserName(), (String)path, (UserRegistry)registry));
            resourceData.setGetAllowed(UserUtil.isGetAllowed((String)registry.getUserName(), (String)path, (UserRegistry)registry));
        }
        child.discard();
        return resourceData;
    }

    public static String getLoggedInUserName() {
        return PrivilegedCarbonContext.getThreadLocalCarbonContext().getUsername();
    }

    public SearchResultsBean searchTerms(Map<String, String> attributes, UserRegistry registry) throws IndexerException, RegistryException {
        return this.searchTermsInternal(null, null, attributes, registry);
    }

    public SearchResultsBean searchTermsByQuery(String searchQuery, String facetField, UserRegistry registry) throws IndexerException, RegistryException {
        return this.searchTermsInternal(searchQuery, facetField, Collections.emptyMap(), registry);
    }

    private SearchResultsBean searchTermsInternal(String searchQuery, String facetField, Map<String, String> attributes, UserRegistry registry) throws IndexerException, RegistryException {
        List<FacetField.Count> results;
        SearchResultsBean resultsBean = new SearchResultsBean();
        SolrClient client = SolrClient.getInstance();
        attributes.remove("authenticate.required");
        List<FacetField.Count> list = results = searchQuery == null ? client.facetQuery(registry.getTenantId(), attributes) : client.facetQuery(searchQuery, facetField, registry.getTenantId());
        if (log.isDebugEnabled()) {
            log.debug((Object)("result for the term search: " + results));
        }
        ArrayList<TermData> termDataList = new ArrayList<TermData>();
        for (FacetField.Count count : results) {
            termDataList.add(new TermData(count.getName(), count.getCount()));
        }
        resultsBean.setTermDataList(termDataList.toArray(new TermData[termDataList.size()]));
        return resultsBean;
    }
}

