/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.indexing.utils;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.registry.core.utils.RegistryUtils;
import org.wso2.carbon.user.core.UserRealm;
import org.wso2.carbon.user.core.UserStoreException;

public class IndexingUtils {
    public static boolean isAuthorized(UserRegistry registry, String resourcePath, String action) throws RegistryException {
        UserRealm userRealm = registry.getUserRealm();
        String userName = registry.getUserName();
        try {
            if (!userRealm.getAuthorizationManager().isUserAuthorized(userName, resourcePath, action)) {
                return false;
            }
        }
        catch (UserStoreException e) {
            throw new RegistryException("Error at Authorizing " + resourcePath + " with user " + userName + ":" + e.getMessage(), (Throwable)e);
        }
        return true;
    }

    public static byte[] readBytesFromInputSteam(InputStream in) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        int read = in.read(buf);
        while (read != -1) {
            out.write(buf, 0, read);
            read = in.read(buf);
        }
        return out.toByteArray();
    }

    public static byte[] getByteContent(Resource resource, String sourceURL) throws RegistryException {
        try {
            InputStream is = null;
            if (sourceURL != null) {
                is = new URL(sourceURL).openStream();
            } else {
                Object content = resource.getContent();
                if (null == content) {
                    return new byte[0];
                }
                is = resource.getContentStream();
                if (is == null) {
                    if (content instanceof byte[]) {
                        return (byte[])content;
                    }
                    if (content instanceof String) {
                        return RegistryUtils.encodeString((String)((String)content));
                    }
                    throw new RegistryException("Unknown type found as content " + content);
                }
            }
            return IndexingUtils.readBytesFromInputSteam(is);
        }
        catch (IOException e) {
            throw new RegistryException("Error at indexing", (Throwable)e);
        }
    }

    public static String getLoggedInUserName() {
        return PrivilegedCarbonContext.getThreadLocalCarbonContext().getUsername();
    }
}

