/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.indexing.utils;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xerces.util.SecurityManager;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.registry.core.utils.MediaTypesUtils;
import org.wso2.carbon.registry.core.utils.RegistryUtils;
import org.wso2.carbon.registry.indexing.bean.RxtUnboundedEntryBean;
import org.wso2.carbon.registry.indexing.service.RxtUnboundedFieldManagerService;
import org.xml.sax.SAXException;

public class RxtUnboundedDataLoadUtils {
    private static final Log log = LogFactory.getLog(RxtUnboundedDataLoadUtils.class);

    public static Map<String, List<String>> getRxtData(UserRegistry userRegistry) throws RegistryException {
        String[] paths = RxtUnboundedDataLoadUtils.getRxtPathLists((Registry)userRegistry);
        ConcurrentHashMap<String, List<String>> RxtDetails = new ConcurrentHashMap<String, List<String>>();
        for (String path : paths) {
            String rxtContent = RegistryUtils.decodeBytes((byte[])((byte[])userRegistry.get(path).getContent()));
            RxtUnboundedEntryBean rxtUnboundedEntryBean = RxtUnboundedDataLoadUtils.getRxtUnboundedEntries(rxtContent);
            String mediaType = rxtUnboundedEntryBean.getMediaType();
            List<String> unboundedFields = rxtUnboundedEntryBean.getFields();
            if (mediaType == null || unboundedFields.size() <= 0) continue;
            RxtDetails.put(rxtUnboundedEntryBean.getMediaType(), rxtUnboundedEntryBean.getFields());
        }
        return RxtDetails;
    }

    private static String[] getRxtPathLists(Registry registry) throws RegistryException {
        try {
            String[] paths = MediaTypesUtils.getResultPaths((Registry)registry, (String)"application/vnd.wso2.registry-ext-type+xml");
            if (paths == null) {
                paths = new String[]{};
            }
            return paths;
        }
        catch (RegistryException e) {
            throw new RegistryException("Error occurred while getting all rxt list", (Throwable)e);
        }
    }

    public static RxtUnboundedEntryBean getRxtUnboundedEntries(String rxtContent) throws RegistryException {
        RxtUnboundedEntryBean rxtUnboundedEntryBean = new RxtUnboundedEntryBean();
        ArrayList<String> fields = new ArrayList<String>();
        DocumentBuilderFactory factory = RxtUnboundedDataLoadUtils.getSecuredDocumentBuilder();
        try (ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(rxtContent.getBytes());){
            DocumentBuilder builder = factory.newDocumentBuilder();
            if (builder != null) {
                Document doc = builder.parse(byteArrayInputStream);
                XPathFactory xPathfactory = XPathFactory.newInstance();
                XPath xpath = xPathfactory.newXPath();
                XPathExpression expToGetMediaType = xpath.compile("/artifactType");
                Node rxtRootNode = (Node)expToGetMediaType.evaluate(doc, XPathConstants.NODE);
                String mediaType = rxtRootNode.getAttributes().getNamedItem("type").getTextContent();
                rxtUnboundedEntryBean.setMediaType(mediaType);
                if (StringUtils.isNotEmpty((String)mediaType)) {
                    XPathExpression expr1 = xpath.compile("/artifactType/content/table[@maxoccurs=\"unbounded\"]");
                    NodeList n1 = (NodeList)expr1.evaluate(doc, XPathConstants.NODESET);
                    XPathExpression expr2 = xpath.compile("/artifactType/content/table/field[@maxoccurs=\"unbounded\"]");
                    NodeList n2 = (NodeList)expr2.evaluate(doc, XPathConstants.NODESET);
                    if (n1.getLength() != 0 || n2.getLength() != 0) {
                        String tableName;
                        for (int i = 0; i < n1.getLength(); ++i) {
                            Node n = n1.item(i);
                            tableName = n.getAttributes().getNamedItem("name").getTextContent();
                            String expr2Text = "/artifactType/content/table[@maxoccurs=\"unbounded\"][@name=\"" + tableName + "\"]/field/name";
                            XPathExpression expr3 = xpath.compile(expr2Text);
                            NodeList n3 = (NodeList)expr3.evaluate(doc, XPathConstants.NODESET);
                            if (n3.getLength() <= 0) continue;
                            for (int j = 0; j < n3.getLength(); ++j) {
                                Node node = n3.item(j);
                                fields.add(RxtUnboundedDataLoadUtils.toCamelCase(tableName) + "_" + node.getTextContent());
                            }
                        }
                        for (int k = 0; k < n2.getLength(); ++k) {
                            Node node = n2.item(k);
                            tableName = node.getParentNode().getAttributes().getNamedItem("name").getTextContent();
                            if (tableName == null) continue;
                            fields.add(RxtUnboundedDataLoadUtils.toCamelCase(tableName) + "_entry");
                        }
                    }
                }
            }
            rxtUnboundedEntryBean.setFields(fields);
        }
        catch (IOException | ParserConfigurationException | XPathExpressionException | SAXException e) {
            throw new RegistryException("Failed to read rxt configuration and filter the unbounded fields", (Throwable)e);
        }
        return rxtUnboundedEntryBean;
    }

    private static String toCamelCase(String key) {
        if (StringUtils.isEmpty((String)key)) {
            return key;
        }
        String[] parts = key.split(" ");
        String camelCaseString = parts[0].toLowerCase();
        if (parts.length > 1) {
            for (int i = 1; i < parts.length; ++i) {
                camelCaseString = camelCaseString + RxtUnboundedDataLoadUtils.toProperCase(parts[i]);
            }
        }
        return camelCaseString;
    }

    private static String toProperCase(String s) {
        return s.substring(0, 1).toUpperCase() + s.substring(1).toLowerCase();
    }

    private static DocumentBuilderFactory getSecuredDocumentBuilder() {
        boolean ENTITY_EXPANSION_LIMIT = false;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        dbf.setXIncludeAware(false);
        dbf.setExpandEntityReferences(false);
        try {
            dbf.setFeature("http://xml.org/sax/features/external-general-entities", false);
            dbf.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            dbf.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            dbf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        }
        catch (ParserConfigurationException e) {
            log.error((Object)"Failed to load XML Processor Feature external-general-entities or external-parameter-entities or nonvalidating/load-external-dtd", (Throwable)e);
        }
        SecurityManager securityManager = new SecurityManager();
        securityManager.setEntityExpansionLimit(0);
        dbf.setAttribute("http://apache.org/xml/properties/security-manager", securityManager);
        return dbf;
    }

    public static boolean isMultiValueField(String mediaType, String fieldKey) {
        List<String> fields;
        Map<String, List<String>> rxtDetails;
        boolean result = false;
        Map<Integer, Map<String, List<String>>> allTenantsUnboundedFields = RxtUnboundedFieldManagerService.getInstance().getTenantsUnboundedFields();
        if (allTenantsUnboundedFields.size() > 0 && (rxtDetails = allTenantsUnboundedFields.get(PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId())) != null && (fields = rxtDetails.get(mediaType)) != null && fields.contains(fieldKey)) {
            result = true;
        }
        return result;
    }
}

