/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.uddi.internal;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.wso2.carbon.utils.CarbonUtils;
import org.wso2.carbon.utils.ConfigurationContextService;
import org.wso2.carbon.utils.FileManipulator;

@Component(name="registry.uddi.component", immediate=true)
public class JUDDIServiceComponent {
    private static final Log log = LogFactory.getLog(JUDDIServiceComponent.class);
    private static final String ENABLE = "enable";
    private static final String UDDI_SYSTEM_PROPERTY = "uddi";
    private static final String TEMP_WEBAPP_DIR = "webapps";

    @Activate
    protected void activate(ComponentContext ctxt) {
        if (ENABLE.equalsIgnoreCase(System.getProperty(UDDI_SYSTEM_PROPERTY))) {
            try {
                this.copyWebAppIfNotExist();
            }
            catch (IOException ignore) {
                log.error((Object)("Error occurred while copying inbuilt webapps to web app dir" + ignore.getMessage()));
            }
        }
    }

    private void copyWebAppIfNotExist() throws IOException {
        String[] children;
        String tempWebAppDir = CarbonUtils.getCarbonHome() + File.separator + "repository" + File.separator + "resources" + File.separator + TEMP_WEBAPP_DIR;
        String webAppDir = CarbonUtils.getCarbonHome() + File.separator + "repository" + File.separator + "deployment" + File.separator + "server" + File.separator + TEMP_WEBAPP_DIR;
        File pluginsDir = new File(tempWebAppDir);
        for (String childName : children = pluginsDir.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith("juddi") && name.toLowerCase().endsWith(".war");
            }
        })) {
            String source = tempWebAppDir + File.separator + childName;
            File sourceFile = new File(source);
            File dstFile = new File(webAppDir + File.separator + childName);
            log.info((Object)("Copying webapp " + sourceFile.getAbsolutePath() + " to " + dstFile.getAbsolutePath()));
            if (dstFile.exists()) continue;
            FileManipulator.copyFile((File)sourceFile, (File)dstFile);
        }
    }

    @Deactivate
    protected void deactivate(ComponentContext ctxt) {
    }

    @Reference(name="config.context.service", service=ConfigurationContextService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetConfigurationContextService")
    protected void setConfigurationContextService(ConfigurationContextService contextService) {
    }

    protected void unsetConfigurationContextService(ConfigurationContextService contextService) {
    }
}

