/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.uddi.utils;

import java.rmi.RemoteException;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.api.impl.JUDDIApiImpl;
import org.apache.juddi.api.impl.UDDIInquiryImpl;
import org.apache.juddi.api.impl.UDDIPublicationImpl;
import org.apache.juddi.api.impl.UDDISecurityImpl;
import org.apache.juddi.api_v3.Publisher;
import org.apache.juddi.api_v3.SavePublisher;
import org.uddi.api_v3.AuthToken;
import org.uddi.api_v3.BusinessDetail;
import org.uddi.api_v3.BusinessEntity;
import org.uddi.api_v3.BusinessList;
import org.uddi.api_v3.BusinessService;
import org.uddi.api_v3.FindBusiness;
import org.uddi.api_v3.GetAuthToken;
import org.uddi.api_v3.SaveBusiness;
import org.uddi.api_v3.SaveService;
import org.uddi.api_v3.SaveTModel;
import org.uddi.api_v3.ServiceDetail;
import org.uddi.api_v3.TModel;
import org.uddi.api_v3.TModelDetail;
import org.uddi.v3_service.DispositionReportFaultMessage;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.session.CurrentSession;

public class UDDIUtil {
    private static final Log log = LogFactory.getLog(UDDIUtil.class);
    private static final String PUBLISHER_USER_ID = "wso2";
    private static final String PUBLISHER_PASSWORD = "wso2carbon";
    private static final String PUBLISHER_NAME = "wso2";
    private static final String ROOT_USER_ID = "root";
    private static final String ROOT_PASSWORD = "root";
    public static Map<String, String> businessKeyMap;
    private static UDDISecurityImpl security;
    private static UDDIPublicationImpl publish;
    private static UDDIInquiryImpl inquiry;

    public static BusinessDetail publishBusiness(BusinessEntity businessEntity, AuthToken authToken) throws RegistryException {
        BusinessDetail businessDetail;
        try {
            SaveBusiness saveBusiness = new SaveBusiness();
            saveBusiness.getBusinessEntity().add(businessEntity);
            saveBusiness.setAuthInfo(authToken.getAuthInfo());
            businessDetail = UDDIUtil.getUDDIPublishService().saveBusiness(saveBusiness);
        }
        catch (Exception e) {
            String msg = "Unable to publish the business entity";
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, (Throwable)e);
        }
        return businessDetail;
    }

    public static ServiceDetail publishBusinessService(BusinessService businessService, AuthToken authToken) throws RegistryException {
        ServiceDetail serviceDetail;
        SaveService saveService = new SaveService();
        saveService.getBusinessService().add(businessService);
        try {
            saveService.setAuthInfo(authToken.getAuthInfo());
            serviceDetail = UDDIUtil.getUDDIPublishService().saveService(saveService);
        }
        catch (Exception e) {
            String msg = "Unable to publish the business service";
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, (Throwable)e);
        }
        return serviceDetail;
    }

    public static TModelDetail saveTModel(TModel tModel) throws RegistryException {
        TModelDetail tModelDetail;
        SaveTModel saveTModel = new SaveTModel();
        saveTModel.getTModel().add(tModel);
        try {
            AuthToken authToken = UDDIUtil.getPublisherAuthToken();
            saveTModel.setAuthInfo(authToken.getAuthInfo());
            tModelDetail = UDDIUtil.getUDDIPublishService().saveTModel(saveTModel);
        }
        catch (Exception e) {
            String msg = "Unable to save TModel in UDDI";
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, (Throwable)e);
        }
        return tModelDetail;
    }

    public static BusinessList findBusiness(FindBusiness business) throws RegistryException {
        BusinessList businessList;
        try {
            businessList = UDDIUtil.getUDDIInquiryService().findBusiness(business);
        }
        catch (RemoteException e) {
            String msg = "Error occurred while finding a business";
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, (Throwable)e);
        }
        return businessList;
    }

    private static UDDISecurityImpl getUDDISecurityService() throws Exception {
        if (security == null) {
            security = new UDDISecurityImpl();
        }
        return security;
    }

    private static UDDIPublicationImpl getUDDIPublishService() throws RegistryException {
        if (publish == null) {
            publish = new UDDIPublicationImpl();
        }
        return publish;
    }

    private static UDDIInquiryImpl getUDDIInquiryService() throws RegistryException {
        if (inquiry == null) {
            inquiry = new UDDIInquiryImpl();
        }
        return inquiry;
    }

    private static boolean savePublisher() throws RegistryException {
        try {
            PrivilegedCarbonContext.startTenantFlow();
            PrivilegedCarbonContext.getThreadLocalCarbonContext().setUsername(CurrentSession.getUser());
            PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(CurrentSession.getTenantId(), true);
            GetAuthToken authTokenRoot = new GetAuthToken();
            authTokenRoot.setUserID("root");
            authTokenRoot.setCred("root");
            AuthToken rootAuthToken = null;
            try {
                rootAuthToken = UDDIUtil.getUDDISecurityService().getAuthToken(authTokenRoot);
            }
            catch (Exception e) {
                log.error((Object)"Failed to get token", (Throwable)e);
                throw new Exception(e);
            }
            if (rootAuthToken == null) {
                boolean e = false;
                return e;
            }
            Publisher publisher = new Publisher();
            publisher.setAuthorizedName("wso2");
            publisher.setPublisherName("wso2");
            SavePublisher savePublisher = new SavePublisher();
            savePublisher.getPublisher().add(publisher);
            savePublisher.setAuthInfo(rootAuthToken.getAuthInfo());
            JUDDIApiImpl juddiApi = new JUDDIApiImpl();
            juddiApi.savePublisher(savePublisher);
        }
        catch (Exception e) {
            String msg = "Unable to save the publisher";
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, (Throwable)e);
        }
        finally {
            PrivilegedCarbonContext.endTenantFlow();
        }
        return true;
    }

    public static AuthToken getPublisherAuthToken() throws RegistryException {
        AuthToken publisherAuthToken = null;
        if (UDDIUtil.savePublisher()) {
            GetAuthToken publisherGetAuthToken = new GetAuthToken();
            publisherGetAuthToken.setUserID("wso2");
            publisherGetAuthToken.setCred(PUBLISHER_PASSWORD);
            UDDISecurityImpl security = new UDDISecurityImpl();
            try {
                publisherAuthToken = security.getAuthToken(publisherGetAuthToken);
            }
            catch (DispositionReportFaultMessage e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Failed to get token", (Throwable)e);
                }
            }
        } else {
            return null;
        }
        return publisherAuthToken;
    }

    static {
        security = null;
        publish = null;
        inquiry = null;
    }
}

