/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.database.utils.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.wso2.carbon.database.utils.jdbc.JdbcUtils;

public class NamedPreparedStatement
implements PreparedStatement {
    private PreparedStatement preparedStatement;
    private List<String> fields = new ArrayList<String>();

    public NamedPreparedStatement(Connection connection, String sqlQuery, Map<String, Integer> repetition) throws SQLException {
        int pos;
        while ((pos = sqlQuery.indexOf(":")) != -1) {
            int end = sqlQuery.substring(pos).indexOf(";");
            if (end == -1) {
                throw new SQLException("Cannot find the end of the placeholder.");
            }
            this.fields.add(sqlQuery.substring(pos + 1, end += pos));
            StringBuilder builder = new StringBuilder("?");
            if (repetition.get(sqlQuery.substring(pos + 1, end)) != null) {
                for (int i = 0; i < repetition.get(sqlQuery.substring(pos + 1, end)) - 1; ++i) {
                    builder.append(", ?");
                }
            }
            sqlQuery = String.format("%s %s %s", sqlQuery.substring(0, pos), builder.toString(), sqlQuery.substring(end + 1));
        }
        this.preparedStatement = connection.prepareStatement(sqlQuery, new String[]{JdbcUtils.getConvertedAutoGeneratedColumnName(connection.getMetaData().getDatabaseProductName(), "ID")});
    }

    public NamedPreparedStatement(Connection connection, String sqlQuery) throws SQLException {
        this(connection, sqlQuery, new HashMap<String, Integer>());
    }

    public void setLong(String name, long value) throws SQLException {
        if (this.getIndex(name) > 0) {
            this.preparedStatement.setLong(this.getIndex(name), value);
        }
    }

    public void setInt(String name, int value) throws SQLException {
        if (this.getIndex(name) > 0) {
            this.preparedStatement.setInt(this.getIndex(name), value);
        }
    }

    public void setString(String name, String value) throws SQLException {
        if (this.getIndex(name) > 0) {
            this.preparedStatement.setString(this.getIndex(name), value);
        }
    }

    public void setString(String name, List<String> values) throws SQLException {
        int indexInc = 0;
        for (String value : values) {
            this.preparedStatement.setString(this.getIndex(name) + indexInc, value);
            ++indexInc;
        }
    }

    public void setObject(String name, Object value) throws SQLException {
        if (this.getIndex(name) > 0) {
            this.preparedStatement.setObject(this.getIndex(name), value);
        }
    }

    public void setTimeStamp(String name, Timestamp timestamp, Calendar calendar) throws SQLException {
        if (this.getIndex(name) > 0) {
            this.preparedStatement.setTimestamp(this.getIndex(name), timestamp, calendar);
        }
    }

    private int getIndex(String name) {
        return this.fields.indexOf(name) + 1;
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        return this.preparedStatement.executeQuery();
    }

    @Override
    public int executeUpdate() throws SQLException {
        return this.preparedStatement.executeUpdate();
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.preparedStatement.setNull(parameterIndex, sqlType);
    }

    @Override
    public void setBoolean(int parameterIndex, boolean value) throws SQLException {
        this.preparedStatement.setBoolean(parameterIndex, value);
    }

    @Override
    public void setByte(int parameterIndex, byte value) throws SQLException {
        this.preparedStatement.setByte(parameterIndex, value);
    }

    @Override
    public void setShort(int parameterIndex, short value) throws SQLException {
        this.preparedStatement.setShort(parameterIndex, value);
    }

    @Override
    public void setInt(int parameterIndex, int value) throws SQLException {
        this.preparedStatement.setInt(parameterIndex, value);
    }

    @Override
    public void setLong(int parameterIndex, long value) throws SQLException {
        this.preparedStatement.setLong(parameterIndex, value);
    }

    @Override
    public void setFloat(int parameterIndex, float value) throws SQLException {
        this.preparedStatement.setFloat(parameterIndex, value);
    }

    @Override
    public void setDouble(int parameterIndex, double value) throws SQLException {
        this.preparedStatement.setDouble(parameterIndex, value);
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal bigDecimal) throws SQLException {
        this.preparedStatement.setBigDecimal(parameterIndex, bigDecimal);
    }

    @Override
    public void setString(int parameterIndex, String string) throws SQLException {
        this.preparedStatement.setString(parameterIndex, string);
    }

    @Override
    public void setBytes(int parameterIndex, byte[] bytes) throws SQLException {
        this.preparedStatement.setBytes(parameterIndex, bytes);
    }

    @Override
    public void setDate(int parameterIndex, Date date) throws SQLException {
        this.preparedStatement.setDate(parameterIndex, date);
    }

    @Override
    public void setTime(int parameterIndex, Time time) throws SQLException {
        this.preparedStatement.setTime(parameterIndex, time);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp timestamp) throws SQLException {
        this.preparedStatement.setTimestamp(parameterIndex, timestamp);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream inputStream, int length) throws SQLException {
        this.preparedStatement.setAsciiStream(parameterIndex, inputStream, length);
    }

    @Override
    public void setUnicodeStream(int parameterIndex, InputStream inputStream, int length) throws SQLException {
        this.preparedStatement.setUnicodeStream(parameterIndex, inputStream, length);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream inputStream, int length) throws SQLException {
        this.preparedStatement.setBinaryStream(parameterIndex, inputStream, length);
    }

    @Override
    public void clearParameters() throws SQLException {
        this.preparedStatement.clearParameters();
    }

    @Override
    public void setObject(int parameterIndex, Object object, int targetSqlType) throws SQLException {
        this.preparedStatement.setObject(parameterIndex, object, targetSqlType);
    }

    @Override
    public void setObject(int parameterIndex, Object object) throws SQLException {
        this.preparedStatement.setObject(parameterIndex, object);
    }

    @Override
    public boolean execute() throws SQLException {
        return this.preparedStatement.execute();
    }

    @Override
    public void addBatch() throws SQLException {
        this.preparedStatement.addBatch();
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        this.preparedStatement.setCharacterStream(parameterIndex, reader, length);
    }

    @Override
    public void setRef(int parameterIndex, Ref ref) throws SQLException {
        this.preparedStatement.setRef(parameterIndex, ref);
    }

    @Override
    public void setBlob(int parameterIndex, Blob blob) throws SQLException {
        this.preparedStatement.setBlob(parameterIndex, blob);
    }

    @Override
    public void setClob(int parameterIndex, Clob clob) throws SQLException {
        this.preparedStatement.setClob(parameterIndex, clob);
    }

    @Override
    public void setArray(int parameterIndex, Array array) throws SQLException {
        this.preparedStatement.setArray(parameterIndex, array);
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return this.preparedStatement.getMetaData();
    }

    @Override
    public void setDate(int parameterIndex, Date date, Calendar cal) throws SQLException {
        this.preparedStatement.setDate(parameterIndex, date, cal);
    }

    @Override
    public void setTime(int parameterIndex, Time time, Calendar cal) throws SQLException {
        this.preparedStatement.setTime(parameterIndex, time, cal);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp timestamp, Calendar cal) throws SQLException {
        this.preparedStatement.setTimestamp(parameterIndex, timestamp, cal);
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.preparedStatement.setNull(parameterIndex, sqlType, typeName);
    }

    @Override
    public void setURL(int parameterIndex, URL url) throws SQLException {
        this.preparedStatement.setURL(parameterIndex, url);
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        return this.preparedStatement.getParameterMetaData();
    }

    @Override
    public void setRowId(int parameterIndex, RowId rowId) throws SQLException {
        this.preparedStatement.setRowId(parameterIndex, rowId);
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        this.preparedStatement.setNString(parameterIndex, value);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        this.preparedStatement.setNCharacterStream(parameterIndex, value, length);
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        this.preparedStatement.setNClob(parameterIndex, value);
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.preparedStatement.setClob(parameterIndex, reader, length);
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        this.preparedStatement.setBlob(parameterIndex, inputStream, length);
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.preparedStatement.setNClob(parameterIndex, reader, length);
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        this.preparedStatement.setSQLXML(parameterIndex, xmlObject);
    }

    @Override
    public void setObject(int parameterIndex, Object object, int targetSqlType, int scaleOrLength) throws SQLException {
        this.preparedStatement.setObject(parameterIndex, object, targetSqlType, scaleOrLength);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        this.preparedStatement.setAsciiStream(parameterIndex, inputStream, length);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        this.preparedStatement.setBinaryStream(parameterIndex, inputStream, length);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        this.preparedStatement.setCharacterStream(parameterIndex, reader, length);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream inputStream) throws SQLException {
        this.preparedStatement.setAsciiStream(parameterIndex, inputStream);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream inputStream) throws SQLException {
        this.preparedStatement.setBinaryStream(parameterIndex, inputStream);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        this.preparedStatement.setCharacterStream(parameterIndex, reader);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        this.preparedStatement.setNCharacterStream(parameterIndex, value);
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        this.preparedStatement.setClob(parameterIndex, reader);
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        this.preparedStatement.setBlob(parameterIndex, inputStream);
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        this.preparedStatement.setNClob(parameterIndex, reader);
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        return this.preparedStatement.executeQuery(sql);
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        return this.preparedStatement.executeUpdate(sql);
    }

    @Override
    public void close() throws SQLException {
        this.preparedStatement.close();
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return this.preparedStatement.getMaxFieldSize();
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        this.preparedStatement.setMaxFieldSize(max);
    }

    @Override
    public int getMaxRows() throws SQLException {
        return this.preparedStatement.getMaxRows();
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        this.preparedStatement.setMaxFieldSize(max);
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.preparedStatement.setEscapeProcessing(enable);
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return this.preparedStatement.getQueryTimeout();
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        this.preparedStatement.setQueryTimeout(seconds);
    }

    @Override
    public void cancel() throws SQLException {
        this.preparedStatement.cancel();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.preparedStatement.getWarnings();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.preparedStatement.clearWarnings();
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        this.preparedStatement.setCursorName(name);
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        return this.preparedStatement.execute(sql);
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        return this.preparedStatement.getResultSet();
    }

    @Override
    public int getUpdateCount() throws SQLException {
        return this.preparedStatement.getUpdateCount();
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return this.preparedStatement.getMoreResults();
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.preparedStatement.setFetchDirection(direction);
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return this.preparedStatement.getFetchDirection();
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.preparedStatement.setFetchSize(rows);
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.preparedStatement.getFetchSize();
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        return this.preparedStatement.getResultSetConcurrency();
    }

    @Override
    public int getResultSetType() throws SQLException {
        return this.preparedStatement.getResultSetType();
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        this.preparedStatement.addBatch(sql);
    }

    @Override
    public void clearBatch() throws SQLException {
        this.preparedStatement.clearBatch();
    }

    @Override
    public int[] executeBatch() throws SQLException {
        return this.preparedStatement.executeBatch();
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.preparedStatement.getConnection();
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        return this.preparedStatement.getMoreResults();
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        return this.preparedStatement.getGeneratedKeys();
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        return this.preparedStatement.executeUpdate(sql, autoGeneratedKeys);
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        return this.preparedStatement.executeUpdate(sql, columnIndexes);
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        return this.preparedStatement.executeUpdate(sql, columnNames);
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        return this.preparedStatement.execute(sql, autoGeneratedKeys);
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        return this.preparedStatement.execute(sql, columnIndexes);
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        return this.preparedStatement.execute(sql, columnNames);
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return this.preparedStatement.getResultSetHoldability();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.preparedStatement.isClosed();
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        this.preparedStatement.setPoolable(poolable);
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return this.preparedStatement.isPoolable();
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        this.preparedStatement.closeOnCompletion();
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return this.preparedStatement.isCloseOnCompletion();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this.preparedStatement.unwrap(iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.preparedStatement.isWrapperFor(iface);
    }
}

