/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.auth0.client;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.wso2.auth0.client.Auth0OAuthClient;
import org.wso2.carbon.apimgt.api.model.ConfigurationDto;
import org.wso2.carbon.apimgt.api.model.KeyManagerConnectorConfiguration;

@Component(name="auth0.configuration.component", immediate=true, service={KeyManagerConnectorConfiguration.class})
public class Auth0ConnectorConfiguration
implements KeyManagerConnectorConfiguration {
    public String getImplementation() {
        return Auth0OAuthClient.class.getName();
    }

    public String getJWTValidator() {
        return null;
    }

    public List<ConfigurationDto> getConnectionConfigurations() {
        ArrayList<ConfigurationDto> configurationDtoList = new ArrayList<ConfigurationDto>();
        configurationDtoList.add(new ConfigurationDto("client_id", "Client ID", "input", "Client ID of Service Application", "", true, false, Collections.emptyList(), false));
        configurationDtoList.add(new ConfigurationDto("client_secret", "Client Secret", "input", "Client Secret of Service Application", "", true, true, Collections.emptyList(), false));
        configurationDtoList.add(new ConfigurationDto("audience", "Audience", "input", "Audience of the Admin API", "https://[tenant].[region].auth0.com/api/v2/", true, false, Collections.emptyList(), false));
        return configurationDtoList;
    }

    public List<ConfigurationDto> getApplicationConfigurations() {
        ArrayList<ConfigurationDto> configurationDtoList = new ArrayList<ConfigurationDto>();
        configurationDtoList.add(new ConfigurationDto("app_type", "Application Type", "select", "Type of the application to create", "regular_web", false, false, Arrays.asList("regular_web", "native", "spa", "non_interactive"), false));
        configurationDtoList.add(new ConfigurationDto("token_endpoint_auth_method", "Token Endpoint Authentication Method", "select", "How to Authenticate Token Endpoint", "client_secret_basic", true, true, Arrays.asList("client_secret_basic", "client_secret_post"), false));
        configurationDtoList.add(new ConfigurationDto("audience_of_api", "Audience of the API", "text", "The audience of the API which intended to use this application", "", true, false, Collections.emptyList(), false));
        return configurationDtoList;
    }

    public String getType() {
        return "Auth0";
    }

    public String getDisplayName() {
        return "Auth0";
    }

    public String getDefaultScopesClaim() {
        return "scope";
    }

    public String getDefaultConsumerKeyClaim() {
        return "azp";
    }
}

