/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.auth0.client.model;

import feign.RequestInterceptor;
import feign.RequestTemplate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.auth0.client.Auth0OAuthClient;
import org.wso2.auth0.client.model.Auth0AccessTokenResponse;
import org.wso2.auth0.client.model.Auth0TokenClient;
import org.wso2.carbon.apimgt.api.APIManagementException;

public class Auth0APIKeyInterceptor
implements RequestInterceptor {
    private static final Log log = LogFactory.getLog(Auth0APIKeyInterceptor.class);
    private Auth0AccessTokenResponse accessTokenInfo;
    private Auth0TokenClient auth0TokenClient;
    private String consumerKey;
    private String consumerSecret;
    private String audience;

    public Auth0APIKeyInterceptor(Auth0TokenClient auth0TokenClient, String consumerKey, String consumerSecret, String audience) {
        this.auth0TokenClient = auth0TokenClient;
        this.consumerKey = consumerKey;
        this.consumerSecret = consumerSecret;
        this.audience = audience;
        this.getAccessToken();
    }

    public void apply(RequestTemplate requestTemplate) {
        if (this.accessTokenInfo == null || System.currentTimeMillis() > this.accessTokenInfo.getCreatedAt() + this.accessTokenInfo.getExpiry() * 1000L) {
            this.getAccessToken();
        }
        requestTemplate.header("Authorization", new String[]{"Bearer ".concat(this.accessTokenInfo.getAccessToken())});
    }

    private void getAccessToken() {
        try {
            String basicCredentials = Auth0OAuthClient.getEncodedCredentials(this.consumerKey, this.consumerSecret);
            Auth0AccessTokenResponse accessTokenResponse = this.auth0TokenClient.getAccessToken("client_credentials", this.audience, "", basicCredentials);
            if (accessTokenResponse != null) {
                this.accessTokenInfo = accessTokenResponse;
                this.accessTokenInfo.setCreatedAt(System.currentTimeMillis());
            }
        }
        catch (APIManagementException e) {
            log.error((Object)("Error while encoding credentials for client ID : " + this.consumerKey), (Throwable)e);
        }
    }
}

