/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.pdf;

import com.google.errorprone.annotations.CheckReturnValue;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.image.PNGTranscoder;
import org.openpdf.text.Image;
import org.xhtmlrenderer.extend.Size;
import org.xhtmlrenderer.pdf.ITextFSImage;
import org.xhtmlrenderer.util.XRRuntimeException;

public class SvgImage
extends ITextFSImage {
    protected final byte[] image;
    protected final Size size;
    protected final String uri;

    public SvgImage(byte[] image, Size size, String uri) {
        super(null);
        this.image = image;
        this.size = size;
        this.uri = uri;
    }

    @Override
    public int getWidth() {
        return this.size.width();
    }

    @Override
    public int getHeight() {
        return this.size.height();
    }

    @Override
    @CheckReturnValue
    public SvgImage scale(int width, int height) {
        return new SvgImage(this.image, this.size.scale(width, height), this.uri);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public Image getImage() {
        PNGTranscoder transcoder = new PNGTranscoder();
        transcoder.addTranscodingHint(PNGTranscoder.KEY_WIDTH, (Object)Float.valueOf(1.0f * (float)this.getWidth()));
        transcoder.addTranscodingHint(PNGTranscoder.KEY_HEIGHT, (Object)Float.valueOf(1.0f * (float)this.getHeight()));
        try (ByteArrayInputStream in = new ByteArrayInputStream(this.image);){
            Image image;
            try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
                transcoder.transcode(new TranscoderInput((InputStream)in), new TranscoderOutput((OutputStream)out));
                out.flush();
                image = SvgImage.createItextImage(out.toByteArray());
            }
            return image;
        }
        catch (IOException | TranscoderException e) {
            throw new RuntimeException("Failed to convert SVG to PNG (%s)".formatted(this.uri), e);
        }
    }

    private static Image createItextImage(byte[] imageBytes) {
        try {
            return Image.getInstance((byte[])imageBytes);
        }
        catch (IOException e) {
            throw new XRRuntimeException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public Object clone() {
        return this;
    }
}

