/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ocsp.server.impl;

import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import java.io.EOFException;
import javax.net.ssl.SSLSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.common.HealthCheckResult;
import org.xipki.common.util.LogUtil;
import org.xipki.http.servlet.AbstractHttpServlet;
import org.xipki.http.servlet.ServletURI;
import org.xipki.http.servlet.SslReverseProxyMode;
import org.xipki.ocsp.server.impl.OcspServer;
import org.xipki.ocsp.server.impl.Responder;

public class HealthCheckServlet
extends AbstractHttpServlet {
    private static final Logger LOG = LoggerFactory.getLogger(HealthCheckServlet.class);
    private static final String CT_RESPONSE = "application/json";
    private OcspServer server;

    public void setServer(OcspServer server) {
        this.server = server;
    }

    public FullHttpResponse service(FullHttpRequest request, ServletURI servletUri, SSLSession sslSession, SslReverseProxyMode sslReverseProxyMode) throws Exception {
        FullHttpResponse resp = this.service0(request, servletUri, sslSession);
        resp.headers().add("Access-Control-Allow-Origin", (Object)"*");
        return resp;
    }

    private FullHttpResponse service0(FullHttpRequest request, ServletURI servletUri, SSLSession sslSession) {
        HttpVersion version = request.protocolVersion();
        HttpMethod method = request.method();
        if (method != HttpMethod.GET) {
            return HealthCheckServlet.createErrorResponse((HttpVersion)version, (HttpResponseStatus)HttpResponseStatus.METHOD_NOT_ALLOWED);
        }
        try {
            if (this.server == null) {
                LOG.error("server in servlet not configured");
                return HealthCheckServlet.createErrorResponse((HttpVersion)version, (HttpResponseStatus)HttpResponseStatus.INTERNAL_SERVER_ERROR);
            }
            Responder responder = this.server.getResponder(servletUri);
            if (responder == null) {
                return HealthCheckServlet.createErrorResponse((HttpVersion)version, (HttpResponseStatus)HttpResponseStatus.NOT_FOUND);
            }
            HealthCheckResult healthResult = this.server.healthCheck(responder);
            HttpResponseStatus status = healthResult.isHealthy() ? HttpResponseStatus.OK : HttpResponseStatus.INTERNAL_SERVER_ERROR;
            byte[] respBytes = healthResult.toJsonMessage(true).getBytes();
            return HealthCheckServlet.createResponse((HttpVersion)version, (HttpResponseStatus)status, (String)CT_RESPONSE, (byte[])respBytes);
        }
        catch (Throwable th) {
            if (th instanceof EOFException) {
                LogUtil.warn((Logger)LOG, (Throwable)th, (String)"connection reset by peer");
            } else {
                LOG.error("Throwable thrown, this should not happen", th);
            }
            return HealthCheckServlet.createErrorResponse((HttpVersion)version, (HttpResponseStatus)HttpResponseStatus.INTERNAL_SERVER_ERROR);
        }
    }
}

