/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ocsp.server.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.xipki.common.InvalidConfException;
import org.xipki.common.util.ParamUtil;
import org.xipki.ocsp.api.OcspMode;
import org.xipki.ocsp.server.impl.jaxb.ResponderType;

class ResponderOption {
    private final OcspMode mode;
    private final boolean inheritCaRevocation;
    private final String requestOptionName;
    private final String responseOptionName;
    private final String signerName;
    private final List<String> storeNames;
    private final List<String> servletPaths;

    ResponderOption(ResponderType conf) throws InvalidConfException {
        ParamUtil.requireNonNull((String)"conf", (Object)conf);
        String str = conf.getMode();
        if (str == null || "RFC6960".equalsIgnoreCase(str) || "RFC 6960".equalsIgnoreCase(str)) {
            this.mode = OcspMode.RFC6960;
        } else if ("RFC2560".equalsIgnoreCase(str) || "RFC 2560".equals(str)) {
            this.mode = OcspMode.RFC2560;
        } else {
            throw new InvalidConfException("invalid OCSP mode '" + str + "'");
        }
        this.signerName = conf.getSigner();
        this.requestOptionName = conf.getRequest();
        this.responseOptionName = conf.getResponse();
        this.inheritCaRevocation = conf.isInheritCaRevocation();
        ArrayList<String> list = new ArrayList<String>(conf.getStores().getStore());
        this.storeNames = Collections.unmodifiableList(list);
        List<String> paths = conf.getServletPaths().getServletPath();
        for (String path : paths) {
            if (path.isEmpty() || path.charAt(0) == '/') continue;
            throw new InvalidConfException("servlet path '" + path + "' must start with '/'");
        }
        list = new ArrayList<String>(paths);
        this.servletPaths = Collections.unmodifiableList(list);
    }

    public OcspMode mode() {
        return this.mode;
    }

    public boolean inheritCaRevocation() {
        return this.inheritCaRevocation;
    }

    public String signerName() {
        return this.signerName;
    }

    public String requestOptionName() {
        return this.requestOptionName;
    }

    public String responseOptionName() {
        return this.responseOptionName;
    }

    public List<String> storeNames() {
        return this.storeNames;
    }

    public List<String> servletPaths() {
        return this.servletPaths;
    }
}

