/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ocsp.server.impl;

import org.xipki.common.InvalidConfException;
import org.xipki.common.util.ParamUtil;
import org.xipki.common.util.StringUtil;
import org.xipki.ocsp.server.impl.RequestOption;
import org.xipki.ocsp.server.impl.jaxb.CacheType;
import org.xipki.ocsp.server.impl.jaxb.EmbedCertsMode;
import org.xipki.ocsp.server.impl.jaxb.ResponseOptionType;
import org.xipki.security.HashAlgoType;

class ResponseOption {
    private final boolean responderIdByName;
    private final boolean includeInvalidityDate;
    private final boolean includeRevReason;
    private final EmbedCertsMode embedCertsMode;
    private final boolean includeCerthash;
    private final HashAlgoType certHashAlgo;
    private final Long cacheMaxAge;

    ResponseOption(ResponseOptionType conf) throws InvalidConfException {
        String token;
        ParamUtil.requireNonNull((String)"conf", (Object)conf);
        this.responderIdByName = ResponseOption.getBoolean(conf.isResponderIdByName(), true);
        this.includeInvalidityDate = ResponseOption.getBoolean(conf.isIncludeInvalidityDate(), true);
        this.includeRevReason = ResponseOption.getBoolean(conf.isIncludeRevReason(), true);
        this.embedCertsMode = conf.getEmbedCertsMode() == null ? EmbedCertsMode.SIGNER : conf.getEmbedCertsMode();
        this.includeCerthash = ResponseOption.getBoolean(conf.isIncludeCertHash(), false);
        CacheType cacheConf = conf.getCache();
        this.cacheMaxAge = cacheConf != null && cacheConf.getCacheMaxAge() != null ? Long.valueOf(cacheConf.getCacheMaxAge().longValue()) : null;
        HashAlgoType tmpCertHashAlgo = null;
        String str = conf.getCerthashAlgorithm();
        if (str != null && StringUtil.isNotBlank((String)(token = str.trim()))) {
            HashAlgoType algo = HashAlgoType.getHashAlgoType((String)token);
            if (algo != null && RequestOption.SUPPORTED_HASH_ALGORITHMS.contains(algo)) {
                tmpCertHashAlgo = algo;
            } else {
                throw new InvalidConfException("hash algorithm " + token + " is unsupported");
            }
        }
        this.certHashAlgo = tmpCertHashAlgo;
    }

    public boolean isResponderIdByName() {
        return this.responderIdByName;
    }

    public boolean isIncludeInvalidityDate() {
        return this.includeInvalidityDate;
    }

    public boolean isIncludeRevReason() {
        return this.includeRevReason;
    }

    public boolean isIncludeCerthash() {
        return this.includeCerthash;
    }

    public Long cacheMaxAge() {
        return this.cacheMaxAge;
    }

    public EmbedCertsMode embedCertsMode() {
        return this.embedCertsMode;
    }

    public HashAlgoType certHashAlgo() {
        return this.certHashAlgo;
    }

    private static boolean getBoolean(Boolean bo, boolean dflt) {
        return bo == null ? dflt : bo;
    }
}

