/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ocsp.server.impl.type;

import java.util.Date;
import java.util.List;
import org.xipki.common.ASN1Type;
import org.xipki.ocsp.server.impl.type.Extensions;
import org.xipki.ocsp.server.impl.type.ResponderID;
import org.xipki.ocsp.server.impl.type.SingleResponse;

public class ResponseData
extends ASN1Type {
    private final int version;
    private final ResponderID responderId;
    private final Date producedAt;
    private final List<SingleResponse> responses;
    private final Extensions extensions;
    private final int bodyLength;
    private final int encodedLength;

    public ResponseData(int version, ResponderID responderId, Date producedAt, List<SingleResponse> responses, Extensions extensions) {
        if (version < 0 || version > 127) {
            throw new IllegalArgumentException("invalid version: " + version);
        }
        this.version = version;
        this.responderId = responderId;
        this.producedAt = producedAt;
        this.responses = responses;
        this.extensions = extensions;
        int len = 0;
        if (version != 0) {
            len += 5;
        }
        len += responderId.encodedLength();
        len += 17;
        int responsesBodyLen = 0;
        for (SingleResponse sr : responses) {
            responsesBodyLen += sr.encodedLength();
        }
        len += ResponseData.getLen((int)responsesBodyLen);
        if (extensions != null) {
            len += ResponseData.getLen((int)extensions.encodedLength());
        }
        this.bodyLength = len;
        this.encodedLength = ResponseData.getLen((int)this.bodyLength);
    }

    public int encodedLength() {
        return this.encodedLength;
    }

    public int write(byte[] out, int offset) {
        int idx = offset;
        idx += ResponseData.writeHeader((byte)48, (int)this.bodyLength, (byte[])out, (int)idx);
        if (this.version != 0) {
            idx += ResponseData.writeHeader((byte)-96, (int)3, (byte[])out, (int)idx);
            idx += ResponseData.writeHeader((byte)2, (int)1, (byte[])out, (int)idx);
            out[idx++] = (byte)this.version;
        }
        idx += this.responderId.write(out, idx);
        idx += ResponseData.writeGeneralizedTime((Date)this.producedAt, (byte[])out, (int)idx);
        int responsesBodyLen = 0;
        for (SingleResponse sr : this.responses) {
            responsesBodyLen += sr.encodedLength();
        }
        idx += ResponseData.writeHeader((byte)48, (int)responsesBodyLen, (byte[])out, (int)idx);
        for (SingleResponse sr : this.responses) {
            idx += sr.write(out, idx);
        }
        if (this.extensions != null) {
            idx += ResponseData.writeHeader((byte)-95, (int)this.extensions.encodedLength(), (byte[])out, (int)idx);
            idx += this.extensions.write(out, idx);
        }
        return idx - offset;
    }
}

