/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security;

import java.io.IOException;
import java.math.BigInteger;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DSA;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.Signer;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.DSAPrivateKeyParameters;
import org.bouncycastle.crypto.params.DSAPublicKeyParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.xipki.security.exception.XiSecurityException;
import org.xipki.security.util.SignerUtil;
import org.xipki.util.ParamUtil;

public class DSAPlainDigestSigner
implements Signer {
    private final Digest digest;
    private final DSA dsaSigner;
    private boolean forSigning;
    private int keyBitLen;

    public DSAPlainDigestSigner(DSA signer, Digest digest) {
        this.digest = digest;
        this.dsaSigner = signer;
    }

    public void init(boolean forSigning, CipherParameters parameters) {
        this.forSigning = forSigning;
        AsymmetricKeyParameter param = parameters instanceof ParametersWithRandom ? (AsymmetricKeyParameter)((ParametersWithRandom)parameters).getParameters() : (AsymmetricKeyParameter)parameters;
        ParamUtil.requireNonNull((String)"param", (Object)param);
        if (param instanceof ECPublicKeyParameters) {
            this.keyBitLen = ((ECPublicKeyParameters)param).getParameters().getCurve().getFieldSize();
        } else if (param instanceof ECPrivateKeyParameters) {
            this.keyBitLen = ((ECPrivateKeyParameters)param).getParameters().getCurve().getFieldSize();
        } else if (param instanceof DSAPublicKeyParameters) {
            this.keyBitLen = ((DSAPublicKeyParameters)param).getParameters().getQ().bitLength();
        } else if (param instanceof DSAPrivateKeyParameters) {
            this.keyBitLen = ((DSAPrivateKeyParameters)param).getParameters().getQ().bitLength();
        } else {
            throw new IllegalArgumentException("unknown parameters: " + param.getClass().getName());
        }
        if (forSigning && !param.isPrivate()) {
            throw new IllegalArgumentException("Signing Requires Private Key.");
        }
        if (!forSigning && param.isPrivate()) {
            throw new IllegalArgumentException("Verification Requires Public Key.");
        }
        this.reset();
        this.dsaSigner.init(forSigning, parameters);
    }

    public void update(byte input) {
        this.digest.update(input);
    }

    public void update(byte[] input, int inOff, int length) {
        this.digest.update(input, inOff, length);
    }

    public byte[] generateSignature() {
        if (!this.forSigning) {
            throw new IllegalStateException("DSADigestSigner not initialized for signature generation.");
        }
        byte[] hash = new byte[this.digest.getDigestSize()];
        this.digest.doFinal(hash, 0);
        BigInteger[] sig = this.dsaSigner.generateSignature(hash);
        try {
            return SignerUtil.dsaSigToPlain(sig[0], sig[1], this.keyBitLen);
        }
        catch (XiSecurityException ex) {
            throw new IllegalStateException("unable to encode signature");
        }
    }

    public boolean verifySignature(byte[] signature) {
        if (this.forSigning) {
            throw new IllegalStateException("DSADigestSigner not initialised for verification");
        }
        byte[] hash = new byte[this.digest.getDigestSize()];
        this.digest.doFinal(hash, 0);
        try {
            BigInteger[] sig = this.decode(signature);
            return this.dsaSigner.verifySignature(hash, sig[0], sig[1]);
        }
        catch (IOException ex) {
            return false;
        }
    }

    public void reset() {
        this.digest.reset();
    }

    private BigInteger[] decode(byte[] encoding) throws IOException {
        int blockSize = (this.keyBitLen + 7) / 8;
        if (encoding.length != 2 * blockSize) {
            throw new IOException("invalid length of signature");
        }
        BigInteger[] ret = new BigInteger[2];
        byte[] buffer = new byte[blockSize + 1];
        System.arraycopy(encoding, 0, buffer, 1, blockSize);
        ret[0] = new BigInteger(buffer);
        buffer = new byte[blockSize + 1];
        System.arraycopy(encoding, blockSize, buffer, 1, blockSize);
        ret[1] = new BigInteger(buffer);
        return ret;
    }
}

