/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security;

import java.io.IOException;
import java.util.Arrays;
import org.bouncycastle.asn1.x509.Certificate;
import org.xipki.security.HashAlgo;
import org.xipki.security.HashCalculator;
import org.xipki.util.ParamUtil;

public class IssuerHash {
    private final HashAlgo hashAlgo;
    private final byte[] issuerNameHash;
    private final byte[] issuerKeyHash;

    public IssuerHash(HashAlgo hashAlgo, byte[] issuerNameHash, byte[] issuerKeyHash) {
        this.hashAlgo = (HashAlgo)((Object)ParamUtil.requireNonNull((String)"hashAlgo", (Object)((Object)hashAlgo)));
        this.issuerNameHash = (byte[])ParamUtil.requireNonNull((String)"issuerNameHash", (Object)issuerNameHash);
        this.issuerKeyHash = (byte[])ParamUtil.requireNonNull((String)"issuerKeyHash", (Object)issuerKeyHash);
        int len = hashAlgo.getLength();
        ParamUtil.requireRange((String)"issuerNameHash.length", (int)issuerNameHash.length, (int)len, (int)len);
        ParamUtil.requireRange((String)"issuerKeyHash.length", (int)issuerKeyHash.length, (int)len, (int)len);
    }

    public IssuerHash(HashAlgo hashAlgo, Certificate issuerCert) throws IOException {
        this.hashAlgo = (HashAlgo)((Object)ParamUtil.requireNonNull((String)"hashAlgo", (Object)((Object)hashAlgo)));
        ParamUtil.requireNonNull((String)"issuerCert", (Object)issuerCert);
        byte[] encodedName = issuerCert.getSubject().getEncoded();
        byte[] encodedKey = issuerCert.getSubjectPublicKeyInfo().getPublicKeyData().getBytes();
        this.issuerNameHash = HashCalculator.hash(hashAlgo, encodedName);
        this.issuerKeyHash = HashCalculator.hash(hashAlgo, encodedKey);
    }

    public HashAlgo getHashAlgo() {
        return this.hashAlgo;
    }

    public byte[] getIssuerNameHash() {
        return Arrays.copyOf(this.issuerNameHash, this.issuerNameHash.length);
    }

    public byte[] getIssuerKeyHash() {
        return Arrays.copyOf(this.issuerKeyHash, this.issuerKeyHash.length);
    }

    public boolean match(HashAlgo hashAlgo, byte[] issuerNameHash, byte[] issuerKeyHash) {
        ParamUtil.requireNonNull((String)"hashAlgo", (Object)((Object)hashAlgo));
        ParamUtil.requireNonNull((String)"issuerNameHash", (Object)issuerNameHash);
        ParamUtil.requireNonNull((String)"issuerKeyHash", (Object)issuerKeyHash);
        return this.hashAlgo == hashAlgo && Arrays.equals(this.issuerNameHash, issuerNameHash) && Arrays.equals(this.issuerKeyHash, issuerKeyHash);
    }
}

