/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security;

import java.io.IOException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.cert.X509CertificateHolder;
import org.xipki.security.util.X509Util;
import org.xipki.util.ParamUtil;

public class X509Cert {
    private final X509Certificate cert;
    private final String subject;
    private final byte[] encodedCert;
    private final byte[] subjectKeyIdentifer;
    private final X500Name subjectAsX500Name;
    private X509CertificateHolder certHolder;

    public X509Cert(X509Certificate cert) {
        this(cert, null);
    }

    public X509Cert(X509Certificate cert, byte[] encodedCert) {
        this.cert = (X509Certificate)ParamUtil.requireNonNull((String)"cert", (Object)cert);
        X500Principal x500Subject = cert.getSubjectX500Principal();
        this.subject = X509Util.getRfc4519Name(x500Subject);
        this.subjectAsX500Name = X500Name.getInstance((Object)x500Subject.getEncoded());
        try {
            this.subjectKeyIdentifer = X509Util.extractSki(cert);
        }
        catch (CertificateEncodingException ex) {
            throw new RuntimeException(String.format("CertificateEncodingException: %s", ex.getMessage()));
        }
        if (encodedCert != null) {
            this.encodedCert = encodedCert;
        } else {
            try {
                this.encodedCert = cert.getEncoded();
            }
            catch (CertificateEncodingException ex) {
                throw new RuntimeException(String.format("CertificateEncodingException: %s", ex.getMessage()));
            }
        }
    }

    public X509Certificate getCert() {
        return this.cert;
    }

    public byte[] getEncodedCert() {
        return this.encodedCert;
    }

    public String getSubject() {
        return this.subject;
    }

    public X500Name getSubjectAsX500Name() {
        return this.subjectAsX500Name;
    }

    public byte[] getSubjectKeyIdentifier() {
        return Arrays.copyOf(this.subjectKeyIdentifer, this.subjectKeyIdentifer.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public X509CertificateHolder getCertHolder() {
        if (this.certHolder != null) {
            return this.certHolder;
        }
        X509Certificate x509Certificate = this.cert;
        synchronized (x509Certificate) {
            try {
                this.certHolder = new X509CertificateHolder(this.encodedCert);
            }
            catch (IOException ex) {
                throw new RuntimeException("should not happen, could not decode certificate: " + ex.getMessage());
            }
            return this.certHolder;
        }
    }

    public String toString() {
        return this.cert.toString();
    }

    public int hashCode() {
        return this.cert.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof X509Cert)) {
            return false;
        }
        return Arrays.equals(this.encodedCert, ((X509Cert)obj).encodedCert);
    }
}

