/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security;

import java.io.IOException;
import java.io.OutputStream;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.operator.ContentSigner;
import org.xipki.security.XiContentSigner;
import org.xipki.security.exception.XiSecurityException;
import org.xipki.util.ParamUtil;

public class XiWrappedContentSigner
implements XiContentSigner {
    private byte[] encodedAlgorithmIdentifier;
    private ContentSigner signer;

    public XiWrappedContentSigner(ContentSigner signer, boolean fixedAlgorithmIdentifier) throws XiSecurityException {
        this.signer = (ContentSigner)ParamUtil.requireNonNull((String)"signer", (Object)signer);
        if (fixedAlgorithmIdentifier) {
            try {
                this.encodedAlgorithmIdentifier = signer.getAlgorithmIdentifier().getEncoded();
            }
            catch (IOException ex) {
                throw new XiSecurityException("could not encode AlgorithmIdentifier", ex);
            }
        }
    }

    public AlgorithmIdentifier getAlgorithmIdentifier() {
        return this.signer.getAlgorithmIdentifier();
    }

    @Override
    public byte[] getEncodedAlgorithmIdentifier() {
        if (this.encodedAlgorithmIdentifier != null) {
            return this.encodedAlgorithmIdentifier;
        }
        try {
            return this.signer.getAlgorithmIdentifier().getEncoded();
        }
        catch (IOException ex) {
            throw new RuntimeException("error encoding AlgorithmIdentifier", ex);
        }
    }

    public OutputStream getOutputStream() {
        return this.signer.getOutputStream();
    }

    public byte[] getSignature() {
        return this.signer.getSignature();
    }
}

