/*
 * Decompiled with CFR 0.152.
 */
package org.xmlbeam;

import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.Date;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Document;
import org.xmlbeam.DefaultFileList;
import org.xmlbeam.DefaultFileMap;
import org.xmlbeam.DefaultFileValue;
import org.xmlbeam.XBProjector;
import org.xmlbeam.evaluation.DocumentResolver;
import org.xmlbeam.evaluation.InvocationContext;
import org.xmlbeam.evaluation.XPathBinder;
import org.xmlbeam.exceptions.XBException;
import org.xmlbeam.types.CloseableList;
import org.xmlbeam.types.CloseableMap;
import org.xmlbeam.types.CloseableValue;
import org.xmlbeam.util.intern.ReflectionHelper;
import org.xmlbeam.util.intern.duplex.DuplexExpression;
import org.xmlbeam.util.intern.duplex.DuplexXPathParser;

public final class DefaultXPathBinder
implements XPathBinder {
    private final DocumentResolver documentProvider;
    private final DuplexExpression duplexExpression;
    private final XBProjector projector;
    private final Closeable documentWriter;

    public DefaultXPathBinder(XBProjector projector, DocumentResolver documentProvider, String xpath, Closeable documentWriter) {
        this.projector = projector;
        this.documentProvider = documentProvider;
        this.duplexExpression = new DuplexXPathParser(projector.config().getUserDefinedNamespaceMapping()).compile(xpath);
        this.documentWriter = documentWriter;
    }

    @Override
    public CloseableValue<Boolean> asBoolean() {
        Class<?> callerClass = ReflectionHelper.getDirectCallerClass();
        return this.bindSingeValue(Boolean.TYPE, callerClass);
    }

    @Override
    public CloseableValue<Integer> asInt() {
        Class<?> callerClass = ReflectionHelper.getDirectCallerClass();
        return this.bindSingeValue(Integer.TYPE, callerClass);
    }

    @Override
    public CloseableValue<String> asString() {
        Class<?> callerClass = ReflectionHelper.getDirectCallerClass();
        return this.bindSingeValue(String.class, callerClass);
    }

    @Override
    public CloseableValue<Date> asDate() {
        Class<?> callerClass = ReflectionHelper.getDirectCallerClass();
        return this.bindSingeValue(Date.class, callerClass);
    }

    @Override
    public <T> CloseableValue<T> as(Class<T> returnType) {
        DefaultXPathBinder.validateEvaluationType(returnType);
        Class<?> callerClass = ReflectionHelper.getDirectCallerClass();
        return this.bindSingeValue(returnType, callerClass);
    }

    private <T> CloseableValue<T> bindSingeValue(Class<T> returnType, Class<?> callerClass) {
        DefaultXPathBinder.validateEvaluationType(returnType);
        try {
            Document document = this.documentProvider.resolve(returnType, callerClass);
            XPathExpression expression = this.projector.config().createXPath(document).compile(this.duplexExpression.getExpressionAsStringWithoutFormatPatterns());
            InvocationContext invocationContext = new InvocationContext(this.duplexExpression.getExpressionAsStringWithoutFormatPatterns(), null, expression, this.duplexExpression, null, returnType, this.projector);
            return new DefaultFileValue(document, invocationContext, this.documentWriter);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (XPathExpressionException e) {
            throw new XBException("Error during binding", e);
        }
    }

    public static <T> void validateEvaluationType(Class<T> returnType) {
        if (ReflectionHelper.isOptional(returnType)) {
            throw new IllegalArgumentException("Type Optional is only allowed as a method return type.");
        }
        if (Collection.class.isAssignableFrom(returnType)) {
            throw new IllegalArgumentException("A collection type can not be component type.");
        }
    }

    @Override
    public <T> CloseableList<T> asListOf(Class<T> componentType) {
        Class<?> callerClass = ReflectionHelper.getDirectCallerClass();
        return (CloseableList)this.bindMultiValues(componentType, callerClass, CollectionType.LIST);
    }

    private <T> Closeable bindMultiValues(Class<T> componentType, Class<?> callerClass, CollectionType collectionType) {
        DefaultXPathBinder.validateEvaluationType(componentType);
        try {
            Document document = this.documentProvider.resolve(componentType, callerClass);
            XPathExpression expression = this.projector.config().createXPath(document).compile(this.duplexExpression.getExpressionAsStringWithoutFormatPatterns());
            InvocationContext invocationContext = new InvocationContext(this.duplexExpression.getExpressionAsStringWithoutFormatPatterns(), null, expression, this.duplexExpression, null, componentType, this.projector);
            return collectionType == CollectionType.LIST ? new DefaultFileList(document, invocationContext, this.documentWriter) : new DefaultFileMap(document, invocationContext, this.documentWriter, componentType);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (XPathExpressionException e) {
            throw new XBException("Error during evaluation", e);
        }
    }

    @Override
    public <T> CloseableMap<T> asMapOf(Class<T> valueType) {
        Class<?> callerClass = ReflectionHelper.getDirectCallerClass();
        return (CloseableMap)this.bindMultiValues(valueType, callerClass, CollectionType.MAP);
    }

    private static enum CollectionType {
        LIST,
        MAP;

    }
}

