/*
 * Decompiled with CFR 0.152.
 */
package org.xmlbeam.util.intern.duplex;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPathVariableResolver;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xmlbeam.util.intern.DOMHelper;
import org.xmlbeam.util.intern.duplex.INodeEvaluationVisitor;
import org.xmlbeam.util.intern.duplex.SimpleNode;
import org.xmlbeam.util.intern.duplex.XBPathParsingException;
import org.xmlbeam.util.intern.duplex.XBXPathExprNotAllowedForWriting;
import org.xmlbeam.util.intern.duplex.XParserVisitor;

class BuildDocumentVisitor
implements XParserVisitor {
    private final MODE mode;
    private final Map<String, String> namespaceMapping;
    private final SimpleNode.StepListFilter stepListFilter;
    private final XPathVariableResolver variableResolver;

    public BuildDocumentVisitor(XPathVariableResolver variableResolver, Map<String, String> namespaceMapping) {
        assert (namespaceMapping == null || !namespaceMapping.isEmpty());
        this.mode = MODE.CREATE_IF_NOT_EXISTS;
        this.namespaceMapping = namespaceMapping == null ? Collections.emptyMap() : Collections.unmodifiableMap(namespaceMapping);
        this.stepListFilter = null;
        this.variableResolver = variableResolver;
    }

    public BuildDocumentVisitor(XPathVariableResolver variableResolver, Map<String, String> namespaceMapping, SimpleNode.StepListFilter stepListFilter, MODE mode) {
        assert (stepListFilter != null);
        assert (namespaceMapping == null || !namespaceMapping.isEmpty());
        assert (mode != null);
        this.mode = mode;
        this.stepListFilter = stepListFilter;
        this.namespaceMapping = namespaceMapping == null ? Collections.emptyMap() : Collections.unmodifiableMap(namespaceMapping);
        this.variableResolver = variableResolver;
    }

    @Override
    public Object visit(SimpleNode node, Node data) {
        switch (node.getID()) {
            case 0: {
                return node.childrenAccept(this, data);
            }
            case 1: {
                return node.childrenAccept(this, data);
            }
            case 8: {
                return node.childrenAccept(this, data);
            }
            case 32: {
                return node.childrenAcceptWithFilter(this, data, this.stepListFilter);
            }
            case 34: {
                throw new XBXPathExprNotAllowedForWriting(node, "Ambiguous locator");
            }
            case 33: {
                return DOMHelper.getOwnerDocumentFor(data);
            }
            case 35: {
                List<Element> existingNodes;
                FindNameTestVisitor nameTest = new FindNameTestVisitor();
                Object result = node.firstChildAccept(nameTest, data);
                if (nameTest.isAlreadyResolved()) {
                    return result;
                }
                String childName = nameTest.name;
                if (nameTest.isAttribute) {
                    Attr attributeNode;
                    if (data.getNodeType() == 9) {
                        throw new XBXPathExprNotAllowedForWriting(node, "You can not set or get attributes on the document. You need a root element.");
                    }
                    assert (data.getNodeType() == 1);
                    Attr attr = attributeNode = this.mode.shouldResolve() ? ((Element)data).getAttributeNodeNS(this.namespaceURI(childName), childName) : null;
                    if (attributeNode != null) {
                        if (this.mode.shouldDelete()) {
                            DOMHelper.removeAttribute(attributeNode);
                        }
                        return attributeNode;
                    }
                    if (this.mode.shouldCreate()) {
                        Attr newAttribute = this.createAttribute((Element)data, childName);
                        return newAttribute;
                    }
                    return null;
                }
                Node nextNode = null;
                if (this.mode.shouldResolve() && !(existingNodes = this.findAlltMatchingChildElements(data, childName, node.getFirstChildWithId(45), node)).isEmpty()) {
                    if (this.mode.shouldDelete()) {
                        DOMHelper.trim(existingNodes.get(0).getParentNode());
                        DOMHelper.removeNodes(existingNodes);
                        return existingNodes;
                    }
                    nextNode = existingNodes.get(0);
                }
                if (nextNode == null) {
                    return this.mode.shouldCreate() ? this.createChildElement(data, childName, node.getFirstChildWithId(45)) : null;
                }
                return nextNode;
            }
            case 52: {
                return this.resolveVariable(node, data);
            }
        }
        throw new XBXPathExprNotAllowedForWriting(node, "Not implemented");
    }

    private Attr createAttribute(Element data, String name) {
        Document doc = data.getOwnerDocument();
        if (this.needNS(name)) {
            Attr attr = doc.createAttributeNS(this.namespaceURI(name), name);
            data.setAttributeNodeNS(attr);
            return attr;
        }
        Attr attr = doc.createAttribute(name);
        data.setAttributeNode(attr);
        return attr;
    }

    private static Element asElement(Object data) {
        assert (data instanceof Element);
        return (Element)data;
    }

    private Element createChildElement(Node data, String childName, SimpleNode predicateList) {
        Element newElement;
        assert (childName != null);
        assert (data != null);
        Document document = DOMHelper.getOwnerDocumentFor(data);
        Element element = newElement = childName.contains(":") ? document.createElementNS(this.namespaceURI(childName), childName.replaceAll("xbdefaultns:", "")) : document.createElement(childName);
        if (data instanceof Document && null != ((Document)data).getDocumentElement()) {
            ((Document)data).removeChild(((Document)data).getDocumentElement());
        }
        data.appendChild(newElement);
        if (predicateList != null) {
            ApplyPredicatesVisitor applyPredicatesVisitor = new ApplyPredicatesVisitor();
            predicateList.jjtAccept(applyPredicatesVisitor, newElement);
        }
        return newElement;
    }

    private String namespaceURI(String childName) {
        if ("xmlns".equals(childName)) {
            return this.namespaceMapping.get(childName);
        }
        int i = childName.indexOf(":");
        if (i < 0) {
            return null;
        }
        String prefix = childName.substring(0, i);
        return this.namespaceMapping.get(prefix);
    }

    private List<Element> findAlltMatchingChildElements(Node data, String childName, SimpleNode predicateList, SimpleNode stepNode) {
        if (data instanceof Document) {
            Element root = ((Document)data).getDocumentElement();
            if (root == null) {
                return Collections.emptyList();
            }
            if (!root.getNodeName().equals(childName.replaceAll("xbdefaultns:", ""))) {
                return Collections.emptyList();
            }
            if (predicateList == null) {
                return DOMHelper.asList(root);
            }
            Object accept = predicateList.childrenAccept(new EvaluatePredicateListVisitor(), root);
            if (Boolean.TRUE.equals(accept)) {
                return DOMHelper.asList(root);
            }
            if (accept instanceof Integer) {
                throw new XBXPathExprNotAllowedForWriting(predicateList, "No position predicate on document element allowed");
            }
            return Collections.emptyList();
        }
        LinkedList<Element> childElements = new LinkedList<Element>();
        this.findChildElementsByName((Element)data, childName, childElements);
        if (childElements.isEmpty()) {
            return Collections.emptyList();
        }
        if (predicateList == null) {
            return childElements;
        }
        LinkedList<Element> allMatchingElements = new LinkedList<Element>();
        int i = 0;
        for (Element e : childElements) {
            ++i;
            Object accept = predicateList.childrenAccept(new EvaluatePredicateListVisitor(), e);
            if (Boolean.TRUE.equals(accept)) {
                allMatchingElements.add(e);
                continue;
            }
            if (!Integer.valueOf(i).equals(accept)) continue;
            allMatchingElements.add(e);
        }
        if (allMatchingElements.isEmpty()) {
            return Collections.emptyList();
        }
        if (allMatchingElements.size() > 1) {
            throw new XBXPathExprNotAllowedForWriting(stepNode, "Ambigous step expression. I can not decide which path to follow. Please add more predicates.");
        }
        return allMatchingElements;
    }

    private boolean elementNameMatches(Element e, String childName) {
        if (childName == null || childName.isEmpty()) {
            throw new IllegalArgumentException("You tried to find an elment without a name. How did you get this through the parser?");
        }
        if (!this.needNS(childName)) {
            return childName.replaceAll("xbdefaultns:", "").equals(e.getNodeName());
        }
        String url = this.namespaceURI(childName);
        if (url != null && !url.equals(e.getNamespaceURI())) {
            return false;
        }
        return childName.equals(e.getTagName());
    }

    private Attr getAttributeNodeByName(Element element, String name) {
        return this.needNS(name) ? element.getAttributeNodeNS(this.namespaceURI(name), name) : element.getAttributeNode(name);
    }

    private boolean needNS(String name) {
        return name.contains(":") || "xmlns".equals(name);
    }

    private void findChildElementsByName(Element element, String childName, List<? super Element> result) {
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element e;
            Node n = nodeList.item(i);
            if (1 != n.getNodeType() || !this.elementNameMatches(e = (Element)n, childName)) continue;
            result.add(e);
        }
    }

    private Object resolveVariable(SimpleNode node, Node data) {
        QName name = (QName)node.firstChildAccept(new EvaluatePredicateListVisitor(), data);
        if (this.variableResolver == null) {
            throw new XBPathParsingException("Variable '" + name + "' used, but no resolver defined.", 1, node.getStartColumn(), node.getEndColumn(), 1);
        }
        Object value = this.variableResolver.resolveVariable(name);
        if (value != null) {
            return value;
        }
        throw new XBPathParsingException("Variable '" + name + "' has no value.", 1, node.getStartColumn(), node.getEndColumn(), 1);
    }

    private class EvaluatePredicateListVisitor
    implements XParserVisitor {
        @Override
        public Object visit(SimpleNode node, Node data) {
            switch (node.getID()) {
                case 45: {
                    return node.childrenAccept(this, data);
                }
                case 46: {
                    return node.childrenAccept(this, data);
                }
                case 8: {
                    return node.childrenAccept(this, data);
                }
                case 19: {
                    Object first = node.firstChildAccept(this, data);
                    Object second = node.secondChildAccept(this, data);
                    return this.compare(node, this.unList(first), this.unList(second));
                }
                case 35: {
                    return node.jjtAccept(new EvaluateStepExprVisitor(false), data);
                }
                case 47: 
                case 48: 
                case 49: 
                case 50: {
                    return node.jjtAccept(new LiteralVisitor(), data);
                }
                case 52: {
                    return BuildDocumentVisitor.this.resolveVariable(node, data);
                }
                case 88: {
                    return QName.valueOf(node.getValue());
                }
                case 32: {
                    return node.childrenAcceptWithFilter(this, data, BuildDocumentVisitor.this.stepListFilter);
                }
            }
            throw new XBXPathExprNotAllowedForWriting(node, "Not expeced here.");
        }

        private Object unList(Object o) {
            if (!(o instanceof List)) {
                return o;
            }
            List list = (List)o;
            if (list.isEmpty()) {
                return null;
            }
            return list.get(0);
        }

        private boolean compare(SimpleNode value, Object first, Object second) {
            switch (value.getValue().charAt(0)) {
                case '=': {
                    return this.toString(first).equals(this.toString(second));
                }
            }
            throw new XBXPathExprNotAllowedForWriting(value, "Operator " + value.getValue() + " not implemented");
        }

        private String toString(Object o) {
            if (o instanceof Node) {
                return ((Node)o).getTextContent();
            }
            return o == null ? "<null>" : o.toString();
        }
    }

    private class ApplyPredicatesVisitor
    implements XParserVisitor {
        ApplyPredicatesVisitor() {
        }

        @Override
        public Object visit(SimpleNode node, Node data) {
            switch (node.getID()) {
                case 45: {
                    return node.childrenAccept(this, data);
                }
                case 46: {
                    return node.childrenAccept(this, data);
                }
                case 8: {
                    return node.childrenAccept(this, data);
                }
                case 19: {
                    if (!"=".equals(node.getValue())) {
                        throw new XBXPathExprNotAllowedForWriting(node, "Operator " + node.getValue() + " leads to non writable predicates.");
                    }
                    Object first = node.firstChildAccept(this, data);
                    if (first instanceof List) {
                        first = ((List)first).get(0);
                    }
                    if (!(first instanceof Node)) {
                        throw new XBXPathExprNotAllowedForWriting(node, "A non writable predicate");
                    }
                    Object second = node.secondChildAccept(this, data);
                    DOMHelper.setDirectTextContent((Node)first, second.toString());
                    return data;
                }
                case 35: {
                    return node.jjtAccept(BuildDocumentVisitor.this, data);
                }
                case 47: 
                case 48: 
                case 49: 
                case 50: {
                    return node.jjtAccept(new LiteralVisitor(), data);
                }
                case 88: {
                    return QName.valueOf(node.getValue());
                }
                case 52: {
                    return BuildDocumentVisitor.this.resolveVariable(node, data);
                }
                case 32: {
                    return node.childrenAcceptWithFilter(this, data, BuildDocumentVisitor.this.stepListFilter);
                }
            }
            throw new XBXPathExprNotAllowedForWriting(node, "Not expetced here.");
        }
    }

    private static class FindNameTestVisitor
    implements XParserVisitor {
        String name;
        boolean isAttribute;
        boolean resolved = false;

        private FindNameTestVisitor() {
        }

        @Override
        public Object visit(SimpleNode node, Node data) {
            switch (node.getID()) {
                case 37: {
                    this.isAttribute = "@".equals(node.getValue());
                    return node.childrenAccept(this, data);
                }
                case 39: {
                    this.resolved = true;
                    return data.getParentNode();
                }
                case 40: {
                    return node.childrenAccept(this, data);
                }
                case 41: {
                    return node.childrenAccept(this, data);
                }
                case 88: {
                    this.name = node.getValue();
                    return data;
                }
                case 54: {
                    if (!".".equals(node.getValue())) break;
                    this.resolved = true;
                    if (data.getNodeType() == 9) {
                        if (((Document)data).getDocumentElement() == null) {
                            throw new XBXPathExprNotAllowedForWriting(node, "There is no root element yet and I can not create one without being given a name");
                        }
                        return ((Document)data).getDocumentElement();
                    }
                    return data;
                }
            }
            throw new XBXPathExprNotAllowedForWriting(node, "Not expeced here.");
        }

        public boolean isAlreadyResolved() {
            return this.resolved;
        }
    }

    private class EvaluateStepExprVisitor
    implements INodeEvaluationVisitor<List<Node>> {
        private final boolean onAttribute;

        EvaluateStepExprVisitor(boolean onAttribute) {
            this.onAttribute = onAttribute;
        }

        @Override
        public List<Node> visit(SimpleNode node, Node data) {
            switch (node.getID()) {
                case 35: {
                    Object result = node.childrenAccept(this, data);
                    return (List)result;
                }
                case 37: {
                    return (List)node.childrenAccept(new EvaluateStepExprVisitor("@".equals(node.getValue())), data);
                }
                case 40: {
                    return (List)node.childrenAccept(this, data);
                }
                case 41: {
                    return (List)node.childrenAccept(this, data);
                }
                case 88: {
                    String name = node.getValue();
                    if (this.onAttribute) {
                        assert (data instanceof Element);
                        return DOMHelper.asList(BuildDocumentVisitor.this.getAttributeNodeByName(BuildDocumentVisitor.asElement(data), name));
                    }
                    LinkedList<Node> list = new LinkedList<Node>();
                    BuildDocumentVisitor.this.findChildElementsByName(BuildDocumentVisitor.asElement(data), name, list);
                    return list;
                }
            }
            throw new XBXPathExprNotAllowedForWriting(node, "Not expeced here.");
        }
    }

    private static class LiteralVisitor
    implements XParserVisitor {
        private LiteralVisitor() {
        }

        @Override
        public Object visit(SimpleNode node, Node data) {
            switch (node.getID()) {
                case 47: {
                    return node.getValue().replaceAll("'(.*)'", "$1").replaceAll("\"(.*)\"", "$1");
                }
                case 48: {
                    return Integer.valueOf(node.getValue());
                }
                case 49: {
                    return Float.valueOf(node.getValue());
                }
                case 50: {
                    return Double.valueOf(node.getValue());
                }
            }
            throw new XBXPathExprNotAllowedForWriting(node, "Not expetced here.");
        }
    }

    static enum MODE {
        CREATE_IF_NOT_EXISTS(true, false, true),
        JUST_CREATE(false, false, true),
        DELETE(true, true, false);

        private final boolean resolveExisting;
        private final boolean deleteExisting;
        private final boolean createNew;

        private MODE(boolean resolveExisting, boolean deleteExisting, boolean createNew) {
            this.resolveExisting = resolveExisting;
            this.deleteExisting = deleteExisting;
            this.createNew = createNew;
        }

        public boolean shouldResolve() {
            return this.resolveExisting;
        }

        public boolean shouldDelete() {
            return this.deleteExisting;
        }

        public boolean shouldCreate() {
            return this.createNew;
        }
    }
}

