/*
 * Decompiled with CFR 0.152.
 */
package org.xmlunit.builder;

import java.io.File;
import java.util.ArrayList;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;
import org.xmlunit.builder.DiffBuilder;
import org.xmlunit.builder.Input;
import org.xmlunit.diff.Comparison;
import org.xmlunit.diff.ComparisonControllers;
import org.xmlunit.diff.ComparisonFormatter;
import org.xmlunit.diff.ComparisonListener;
import org.xmlunit.diff.ComparisonResult;
import org.xmlunit.diff.ComparisonType;
import org.xmlunit.diff.Diff;
import org.xmlunit.diff.Difference;
import org.xmlunit.diff.DifferenceEvaluator;
import org.xmlunit.diff.DifferenceEvaluators;
import org.xmlunit.util.Linqy;
import org.xmlunit.util.Predicate;

public class DiffBuilderTest {
    @Test
    public void testDiff_withoutIgnoreWhitespaces_shouldFail() {
        String controlXml = "<a><b>Test Value</b></a>";
        String testXml = "<a>\n <b>\n  Test Value\n </b>\n</a>";
        Diff myDiff = DiffBuilder.compare((Object)Input.fromString((String)controlXml).build()).withTest((Object)Input.fromString((String)testXml).build()).build();
        Assert.assertTrue((String)myDiff.toString(), (boolean)myDiff.hasDifferences());
    }

    @Test
    public void testDiff_withIgnoreWhitespaces_shouldSucceed() {
        String controlXml = "<a><b>Test Value</b></a>";
        String testXml = "<a>\n <b>\n  Test Value\n </b>\n</a>";
        Diff myDiff = DiffBuilder.compare((Object)Input.fromString((String)controlXml).build()).withTest((Object)Input.fromString((String)testXml).build()).ignoreWhitespace().build();
        Assert.assertFalse((String)("XML similar " + myDiff.toString()), (boolean)myDiff.hasDifferences());
    }

    @Test
    public void testDiff_withoutNormalizeWhitespaces_shouldFail() {
        String controlXml = "<a><b>Test Value</b></a>";
        String testXml = "<a>\n <b>\n  Test Value\n </b>\n</a>";
        Diff myDiff = DiffBuilder.compare((Object)Input.fromString((String)controlXml).build()).withTest((Object)Input.fromString((String)testXml).build()).build();
        Assert.assertTrue((String)myDiff.toString(), (boolean)myDiff.hasDifferences());
    }

    @Test
    public void testDiff_withNormalizeWhitespaces_shouldSucceed() {
        String controlXml = "<a><b>Test Value</b></a>";
        String testXml = "<a>\n <b>\n  Test\n        Value\n </b>\n</a>";
        Diff myDiff = DiffBuilder.compare((Object)Input.fromString((String)controlXml).build()).withTest((Object)Input.fromString((String)testXml).build()).normalizeWhitespace().build();
        Assert.assertFalse((String)("XML similar " + myDiff.toString()), (boolean)myDiff.hasDifferences());
    }

    @Test
    public void testDiff_withNormalizeAndIgnoreWhitespaces_shouldSucceed() {
        String controlXml = "<a><b>Test Value</b></a>";
        String testXml = "<a>\n <b>\n  Test\n        Value\n </b>\n</a>";
        Diff myDiff = DiffBuilder.compare((Object)Input.fromString((String)controlXml).build()).withTest((Object)Input.fromString((String)testXml).build()).normalizeWhitespace().ignoreWhitespace().build();
        Assert.assertFalse((String)("XML similar " + myDiff.toString()), (boolean)myDiff.hasDifferences());
    }

    @Test
    public void testDiff_withCheckForIdentical_shouldFail() {
        String controlXml = "<a>Test Value</a>";
        String testXml = "<a><![CDATA[Test Value]]></a>";
        Diff myDiff = DiffBuilder.compare((Object)Input.fromString((String)controlXml).build()).withTest((Object)Input.fromString((String)testXml).build()).checkForIdentical().build();
        Assert.assertTrue((String)myDiff.toString(), (boolean)myDiff.hasDifferences());
    }

    @Test
    public void testDiff_withCheckForSimilar_shouldSucceed() {
        String controlXml = "<a>Test Value</a>";
        String testXml = "<a><![CDATA[Test Value]]></a>";
        Diff myDiff = DiffBuilder.compare((Object)Input.fromString((String)controlXml).build()).withTest((Object)Input.fromString((String)testXml).build()).checkForSimilar().build();
        Assert.assertFalse((String)("XML similar " + myDiff.toString()), (boolean)myDiff.hasDifferences());
    }

    @Test
    public void testDiff_withoutIgnoreComments_shouldFail() {
        String controlXml = "<a><b><!-- A comment -->Test Value</b></a>";
        String testXml = "<a><b><!-- An other comment -->Test Value</b></a>";
        Diff myDiff = DiffBuilder.compare((Object)Input.fromString((String)controlXml).build()).withTest((Object)Input.fromString((String)testXml).build()).build();
        Assert.assertTrue((String)myDiff.toString(), (boolean)myDiff.hasDifferences());
    }

    @Test
    public void testDiff_withIgnoreComments_shouldSucceed() {
        String controlXml = "<a><b><!-- A comment -->Test Value</b></a>";
        String testXml = "<a><b><!-- An other comment -->Test Value</b></a>";
        Diff myDiff = DiffBuilder.compare((Object)Input.fromString((String)controlXml).build()).withTest((Object)Input.fromString((String)testXml).build()).ignoreComments().build();
        Assert.assertFalse((String)("XML similar " + myDiff.toString()), (boolean)myDiff.hasDifferences());
    }

    @Test
    public void testDiff_fromCombinedSourceAndString_shouldSucceed() {
        String controlXml = "<a><b>Test Value</b></a>";
        Diff myDiff = DiffBuilder.compare((Object)Input.fromString((String)controlXml).build()).withTest((Object)controlXml).build();
        Assert.assertFalse((String)("XML similar " + myDiff.toString()), (boolean)myDiff.hasDifferences());
    }

    @Test
    public void testDiff_fromBuilder_shouldSucceed() {
        String controlXml = "<a><b>Test Value</b></a>";
        Diff myDiff = DiffBuilder.compare((Object)Input.fromString((String)controlXml)).withTest((Object)Input.fromString((String)controlXml)).build();
        Assert.assertFalse((String)("XML similar " + myDiff.toString()), (boolean)myDiff.hasDifferences());
    }

    @Test
    public void testDiff_fromByteArray_shouldSucceed() {
        byte[] controlXml = "<a><b>Test Value</b></a>".getBytes();
        Diff myDiff = DiffBuilder.compare((Object)controlXml).withTest((Object)controlXml).build();
        Assert.assertFalse((String)("XML similar " + myDiff.toString()), (boolean)myDiff.hasDifferences());
    }

    @Test
    public void testDiff_fromFile_shouldSucceed() {
        File controlXml = new File("../test-resources/test1.xml");
        Diff myDiff = DiffBuilder.compare((Object)controlXml).withTest((Object)controlXml).build();
        Assert.assertFalse((String)("XML similar " + myDiff.toString()), (boolean)myDiff.hasDifferences());
    }

    @Test
    public void testDiff_withComparisonListener_shouldCallListener() {
        String control = "<a><b attr=\"abc\"></b></a>";
        String test = "<a><b attr=\"xyz\"></b></a>";
        final ArrayList diffs = new ArrayList();
        ComparisonListener comparisonListener = new ComparisonListener(){

            public void comparisonPerformed(Comparison comparison, ComparisonResult outcome) {
                diffs.add(new Difference(comparison, outcome));
            }
        };
        Diff myDiff = DiffBuilder.compare((Object)"<a><b attr=\"abc\"></b></a>").withTest((Object)"<a><b attr=\"xyz\"></b></a>").withComparisonListeners(new ComparisonListener[]{comparisonListener}).build();
        Assert.assertTrue((String)myDiff.toString(), (boolean)myDiff.hasDifferences());
        MatcherAssert.assertThat((Object)diffs.size(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(1)));
    }

    @Test
    public void testDiff_withDifferenceListener_shouldCallListener() {
        String control = "<a><b attr=\"abc\"></b></a>";
        String test = "<a><b attr=\"xyz\"></b></a>";
        final ArrayList diffs = new ArrayList();
        ComparisonListener comparisonListener = new ComparisonListener(){

            public void comparisonPerformed(Comparison comparison, ComparisonResult outcome) {
                diffs.add(new Difference(comparison, outcome));
            }
        };
        Diff myDiff = DiffBuilder.compare((Object)"<a><b attr=\"abc\"></b></a>").withTest((Object)"<a><b attr=\"xyz\"></b></a>").withDifferenceListeners(new ComparisonListener[]{comparisonListener}).build();
        Assert.assertTrue((String)myDiff.toString(), (boolean)myDiff.hasDifferences());
        MatcherAssert.assertThat((Object)diffs.size(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)((Difference)diffs.get(0)).getResult(), (Matcher)CoreMatchers.is((Object)ComparisonResult.DIFFERENT));
        MatcherAssert.assertThat((Object)((Difference)diffs.get(0)).getComparison().getType(), (Matcher)CoreMatchers.is((Object)ComparisonType.ATTR_VALUE));
    }

    @Test
    public void testDiff_withDifferenceEvaluator_shouldSucceed() {
        String control = "<a><b attr=\"abc\"></b></a>";
        String test = "<a><b attr=\"xyz\"></b></a>";
        Diff myDiff = DiffBuilder.compare((Object)"<a><b attr=\"abc\"></b></a>").withTest((Object)"<a><b attr=\"xyz\"></b></a>").withDifferenceEvaluator((DifferenceEvaluator)new IgnoreAttributeDifferenceEvaluator("attr")).build();
        Assert.assertFalse((String)myDiff.toString(), (boolean)myDiff.hasDifferences());
    }

    @Test
    public void testDiff_withDifferenceEvaluator_shouldNotInterfereWithSimilar() {
        String control = "<a><b><![CDATA[abc]]></b></a>";
        String test = "<a><b>abc</b></a>";
        Diff myDiff = DiffBuilder.compare((Object)"<a><b><![CDATA[abc]]></b></a>").withTest((Object)"<a><b>abc</b></a>").withDifferenceEvaluator(DifferenceEvaluators.chain((DifferenceEvaluator[])new DifferenceEvaluator[]{DifferenceEvaluators.Default, new IgnoreAttributeDifferenceEvaluator("attr")})).checkForSimilar().build();
        Assert.assertFalse((String)myDiff.toString(), (boolean)myDiff.hasDifferences());
    }

    @Test
    public void testDiff_withCustomDifferenceEvaluator_shouldNotEvaluateSimilar() {
        String control = "<a><b><![CDATA[abc]]></b></a>";
        String test = "<a><b>abc</b></a>";
        Diff myDiff = DiffBuilder.compare((Object)"<a><b><![CDATA[abc]]></b></a>").withTest((Object)"<a><b>abc</b></a>").withDifferenceEvaluator((DifferenceEvaluator)new IgnoreAttributeDifferenceEvaluator("attr")).checkForSimilar().build();
        Assert.assertTrue((String)myDiff.toString(), (boolean)myDiff.hasDifferences());
        Assert.assertThat((Object)ComparisonResult.DIFFERENT, (Matcher)CoreMatchers.is((Object)((Difference)myDiff.getDifferences().iterator().next()).getResult()));
    }

    @Test
    public void testDiff_withDefaultComparisonController_shouldReturnAllDifferences() {
        String control = "<a><b attr1=\"abc\" attr2=\"def\"></b></a>";
        String test = "<a><b attr1=\"uvw\" attr2=\"xyz\"></b></a>";
        Diff myDiff = DiffBuilder.compare((Object)"<a><b attr1=\"abc\" attr2=\"def\"></b></a>").withTest((Object)"<a><b attr1=\"uvw\" attr2=\"xyz\"></b></a>").build();
        Assert.assertTrue((boolean)myDiff.hasDifferences());
        MatcherAssert.assertThat((Object)Linqy.count((Iterable)myDiff.getDifferences()), (Matcher)CoreMatchers.is((Object)2));
    }

    @Test
    public void testDiff_withStopWhenDifferentComparisonController_shouldReturnOnlyFirstDifference() {
        String control = "<a><b attr1=\"abc\" attr2=\"def\"></b></a>";
        String test = "<a><b attr1=\"uvw\" attr2=\"xyz\"></b></a>";
        Diff myDiff = DiffBuilder.compare((Object)"<a><b attr1=\"abc\" attr2=\"def\"></b></a>").withTest((Object)"<a><b attr1=\"uvw\" attr2=\"xyz\"></b></a>").withComparisonController(ComparisonControllers.StopWhenDifferent).build();
        Assert.assertTrue((boolean)myDiff.hasDifferences());
        MatcherAssert.assertThat((Object)Linqy.count((Iterable)myDiff.getDifferences()), (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void testDiff_withAttributeDifferences() {
        String control = "<a><b attr1=\"abc\" attr2=\"def\"></b></a>";
        String test = "<a><b attr1=\"uvw\" attr2=\"def\"></b></a>";
        Diff myDiff = DiffBuilder.compare((Object)"<a><b attr1=\"abc\" attr2=\"def\"></b></a>").withTest((Object)"<a><b attr1=\"uvw\" attr2=\"def\"></b></a>").withComparisonController(ComparisonControllers.StopWhenDifferent).build();
        Assert.assertTrue((boolean)myDiff.hasDifferences());
        MatcherAssert.assertThat((Object)Linqy.count((Iterable)myDiff.getDifferences()), (Matcher)CoreMatchers.is((Object)1));
        Diff myDiffWithFilter = DiffBuilder.compare((Object)"<a><b attr1=\"abc\" attr2=\"def\"></b></a>").withTest((Object)"<a><b attr1=\"uvw\" attr2=\"def\"></b></a>").withAttributeFilter((Predicate)new Predicate<Attr>(){

            public boolean test(Attr a) {
                return !"attr1".equals(a.getName());
            }
        }).withComparisonController(ComparisonControllers.StopWhenDifferent).build();
        Assert.assertFalse((boolean)myDiffWithFilter.hasDifferences());
    }

    @Test
    public void testDiff_withExtraNodes() {
        String control = "<a><b></b><c/></a>";
        String test = "<a><b></b><c/><d/></a>";
        Diff myDiff = DiffBuilder.compare((Object)control).withTest((Object)test).withComparisonController(ComparisonControllers.StopWhenDifferent).build();
        Assert.assertTrue((boolean)myDiff.hasDifferences());
        MatcherAssert.assertThat((Object)Linqy.count((Iterable)myDiff.getDifferences()), (Matcher)CoreMatchers.is((Object)1));
        Diff myDiffWithFilter = DiffBuilder.compare((Object)control).withTest((Object)test).withNodeFilter((Predicate)new Predicate<Node>(){

            public boolean test(Node n) {
                return !"d".equals(n.getNodeName());
            }
        }).withComparisonController(ComparisonControllers.StopWhenDifferent).build();
        Assert.assertFalse((boolean)myDiffWithFilter.hasDifferences());
    }

    @Test
    public void usesCustomComparisonFormatter() {
        String control = "<a><b></b><c/></a>";
        String test = "<a><b></b><c/><d/></a>";
        Diff myDiff = DiffBuilder.compare((Object)control).withTest((Object)test).withComparisonController(ComparisonControllers.StopWhenDifferent).withComparisonFormatter((ComparisonFormatter)new DummyFormatter()).build();
        Assert.assertEquals((Object)"foo", (Object)myDiff.toString());
    }

    @Test
    public void usesCustomComparisonFormatterForDifferences() {
        String control = "<a><b></b><c/></a>";
        String test = "<a><b></b><c/><d/></a>";
        Diff myDiff = DiffBuilder.compare((Object)control).withTest((Object)test).withComparisonController(ComparisonControllers.StopWhenDifferent).withComparisonFormatter((ComparisonFormatter)new DummyFormatter()).build();
        Assert.assertEquals((Object)"foo (DIFFERENT)", (Object)((Difference)myDiff.getDifferences().iterator().next()).toString());
    }

    private static final class DummyFormatter
    implements ComparisonFormatter {
        private DummyFormatter() {
        }

        public String getDescription(Comparison difference) {
            return "foo";
        }

        public String getDetails(Comparison.Detail details, ComparisonType type, boolean formatXml) {
            return "bar";
        }
    }

    private final class IgnoreAttributeDifferenceEvaluator
    implements DifferenceEvaluator {
        private String attributeName;

        public IgnoreAttributeDifferenceEvaluator(String attributeName) {
            this.attributeName = attributeName;
        }

        public ComparisonResult evaluate(Comparison comparison, ComparisonResult outcome) {
            Attr attr;
            Node controlNode = comparison.getControlDetails().getTarget();
            if (controlNode instanceof Attr && (attr = (Attr)controlNode).getName().equals(this.attributeName)) {
                return ComparisonResult.EQUAL;
            }
            return outcome;
        }
    }
}

