/*
 * Decompiled with CFR 0.152.
 */
package org.xmlunit.builder;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.io.Reader;
import java.net.URI;
import java.net.URL;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerFactory;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xmlunit.NullNode;
import org.xmlunit.XMLUnitException;
import org.xmlunit.builder.Input;
import org.xmlunit.builder.jaxb.ComplexNode;
import org.xmlunit.util.Convert;

public class InputTest {
    private static Document parse(Source s) throws Exception {
        DocumentBuilder b = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        return b.parse(Convert.toInputSource((Source)s));
    }

    @Test
    public void shouldParseADocument() throws Exception {
        Document d = InputTest.parse(Input.fromFile((String)"../test-resources/test1.xml").build());
        Source s = Input.fromDocument((Document)d).build();
        InputTest.allIsWellFor(s);
    }

    @Test
    public void shouldParseAnExistingFileByName() throws Exception {
        Source s = Input.fromFile((String)"../test-resources/test1.xml").build();
        InputTest.allIsWellFor(s);
        Assert.assertEquals((Object)InputTest.toFileUri("../test-resources/test1.xml"), (Object)s.getSystemId());
    }

    @Test
    public void shouldParseAnExistingFileByFile() throws Exception {
        Source s = Input.fromFile((File)new File("../test-resources/test1.xml")).build();
        InputTest.allIsWellFor(s);
        Assert.assertEquals((Object)InputTest.toFileUri("../test-resources/test1.xml"), (Object)s.getSystemId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldParseAnExistingFileFromStream() throws Exception {
        FileInputStream is = null;
        try {
            is = new FileInputStream("../test-resources/test1.xml");
            InputTest.allIsWellFor(Input.fromStream((InputStream)is).build());
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldParseAnExistingFileFromReader() throws Exception {
        FileReader r = null;
        try {
            r = new FileReader("../test-resources/test1.xml");
            InputTest.allIsWellFor(Input.fromReader((Reader)r).build());
        }
        finally {
            if (r != null) {
                r.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldParseAnExistingFileFromChannel() throws Exception {
        AbstractInterruptibleChannel fc = null;
        FileInputStream is = null;
        try {
            is = new FileInputStream("../test-resources/test1.xml");
            fc = is.getChannel();
            InputTest.allIsWellFor(Input.fromChannel((ReadableByteChannel)((Object)fc)).build());
        }
        finally {
            if (fc != null) {
                fc.close();
            }
            if (is != null) {
                is.close();
            }
        }
    }

    @Test
    public void shouldParseString() throws Exception {
        InputTest.allIsWellFor(Input.fromString((String)new String(InputTest.readTestFile(), "UTF-8")).build());
    }

    @Test
    public void shouldParseBytes() throws Exception {
        InputTest.allIsWellFor(Input.fromByteArray((byte[])InputTest.readTestFile()).build());
    }

    @Test
    public void shouldParseFileFromURIString() throws Exception {
        InputTest.allIsWellFor(Input.fromURI((String)"file:../test-resources/test1.xml").build());
    }

    @Test
    public void shouldParseFileFromURI() throws Exception {
        InputTest.allIsWellFor(Input.fromURI((URI)new URI("file:../test-resources/test1.xml")).build());
    }

    @Test
    public void shouldParseFileFromURL() throws Exception {
        InputTest.allIsWellFor(Input.fromURL((URL)new URL("file:../test-resources/test1.xml")).build());
    }

    @Test
    public void shouldParseATransformationFromSource() throws Exception {
        Source input = Input.fromString((String)"<animal>furry</animal>").build();
        Source s = ((Input.TransformationBuilder)Input.byTransforming((Source)input).withStylesheet(Input.fromFile((String)"../test-resources/animal.xsl").build())).build();
        InputTest.allIsWellFor(s, "furry");
    }

    @Test
    public void shouldParseATransformationFromBuilder() throws Exception {
        Input.Builder input = Input.fromString((String)"<animal>furry</animal>");
        Source s = Input.byTransforming((Input.Builder)input).withStylesheet(Input.fromFile((String)"../test-resources/animal.xsl")).build();
        InputTest.allIsWellFor(s, "furry");
    }

    @Test
    public void shouldParseJaxbObject() throws Exception {
        InputTest.allIsWellFor(Input.fromJaxb((Object)new ComplexNode()).build(), "complexNode");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldParseUnknownToSource() throws Exception {
        InputTest.allIsWellFor(Input.from((Object)Input.fromByteArray((byte[])InputTest.readTestFile()).build()).build());
        InputTest.allIsWellFor(Input.from((Object)Input.fromByteArray((byte[])InputTest.readTestFile())).build());
        InputTest.allIsWellFor(Input.from((Object)InputTest.parse(Input.fromFile((String)"../test-resources/test1.xml").build())).build());
        InputTest.allIsWellFor(Input.from((Object)new File("../test-resources/test1.xml")).build());
        InputTest.allIsWellFor(Input.from((Object)new String(InputTest.readTestFile(), "UTF-8")).build());
        InputTest.allIsWellFor(Input.from((Object)InputTest.readTestFile()).build());
        InputTest.allIsWellFor(Input.from((Object)new URI("file:../test-resources/test1.xml")).build());
        InputTest.allIsWellFor(Input.from((Object)new URL("file:../test-resources/test1.xml")).build());
        InputTest.allIsWellFor(Input.from((Object)new ComplexNode()).build(), "complexNode");
        FileInputStream is = null;
        try {
            is = new FileInputStream("../test-resources/test1.xml");
            InputTest.allIsWellFor(Input.from((Object)is).build());
        }
        finally {
            if (is != null) {
                is.close();
                is = null;
            }
        }
        Assert.assertNotNull((Object)Input.from((Object)new NullNode()).build());
        AbstractInterruptibleChannel fc = null;
        try {
            is = new FileInputStream("../test-resources/test1.xml");
            fc = is.getChannel();
            InputTest.allIsWellFor(Input.from((Object)fc).build());
        }
        finally {
            if (fc != null) {
                fc.close();
            }
            if (is != null) {
                is.close();
            }
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldRejectNonURLsStringVersion() {
        Input.fromURI((String)"foo bar");
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldRejectNonURLsURIVersion() throws Exception {
        Input.fromURI((URI)new URI("urn:xmlunit:foo"));
    }

    @Test(expected=XMLUnitException.class)
    public void shouldTranslateIOException() throws Exception {
        Input.fromURL((URL)new URL("mailto:info@example.org"));
    }

    @Test
    public void canCreateInputFromNode() {
        Assert.assertNotNull((Object)Input.fromNode((Node)new NullNode()).build());
    }

    private static void allIsWellFor(Source s) throws Exception {
        InputTest.allIsWellFor(s, "animal");
    }

    private static void allIsWellFor(Source s, String rootElementName) throws Exception {
        Assert.assertThat((Object)s, (Matcher)IsNull.notNullValue());
        Document d = InputTest.parse(s);
        Assert.assertThat((Object)d, (Matcher)IsNull.notNullValue());
        Assert.assertThat((Object)d.getDocumentElement().getTagName(), (Matcher)Is.is((Object)rootElementName));
    }

    private static byte[] readTestFile() throws Exception {
        FileInputStream is = new FileInputStream("../test-resources/test1.xml");
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        int read = -1;
        while ((read = is.read(buffer)) >= 0) {
            if (read <= 0) continue;
            bos.write(buffer, 0, read);
        }
        is.close();
        return bos.toByteArray();
    }

    private static String toFileUri(String fileName) {
        String url = new File(fileName).toURI().toString();
        if (url.startsWith("file:/") && !url.startsWith("file:///") && ("1.5".equals(System.getProperty("java.specification.version")) || InputTest.transformerIsApacheXalan())) {
            url = "file:///" + url.substring(6);
        }
        return url;
    }

    private static boolean transformerIsApacheXalan() {
        try {
            TransformerFactory fac = TransformerFactory.newInstance();
            return fac.getClass().getName().equals("org.apache.xalan.processor.TransformerFactoryImpl");
        }
        catch (Exception ex) {
            return false;
        }
    }
}

