/*
 * Decompiled with CFR 0.152.
 */
package org.xmlunit.builder;

import java.io.StringWriter;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Marshaller;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.w3c.dom.Document;
import org.xmlunit.builder.JaxbBuilder;
import org.xmlunit.builder.jaxb.ComplexNode;
import org.xmlunit.builder.jaxb.RootNode;
import org.xmlunit.util.Convert;

public class JaxbBuilderTest {
    @Test
    public void testMarchal_withJaxbRootObject_shouldReturnSource() throws Exception {
        RootNode testObject = this.createRootNode("123");
        Source saxSource = new JaxbBuilder((Object)testObject).build();
        String xmlString = this.toString(saxSource);
        if (this.isJdk6()) {
            MatcherAssert.assertThat((Object)xmlString, (Matcher)CoreMatchers.containsString((String)":RootNode"));
        } else {
            MatcherAssert.assertThat((Object)xmlString, (Matcher)CoreMatchers.startsWith((String)"<test:RootNode"));
        }
        MatcherAssert.assertThat((Object)xmlString, (Matcher)CoreMatchers.containsString((String)"<Id>123</Id>"));
    }

    @Test
    public void testMarchal_withCustomMarshaller_shouldReturnSource() throws Exception {
        RootNode testObject = this.createRootNode("123");
        Marshaller marshaller = JAXBContext.newInstance((Class[])new Class[]{testObject.getClass()}).createMarshaller();
        Source saxSource = new JaxbBuilder((Object)testObject).withMarshaller(marshaller).build();
        String xmlString = this.toString(saxSource);
        if (this.isJdk6()) {
            MatcherAssert.assertThat((Object)xmlString, (Matcher)CoreMatchers.containsString((String)":RootNode"));
        } else {
            MatcherAssert.assertThat((Object)xmlString, (Matcher)CoreMatchers.startsWith((String)"<test:RootNode"));
        }
        MatcherAssert.assertThat((Object)xmlString, (Matcher)CoreMatchers.containsString((String)"<Id>123</Id>"));
    }

    @Test
    public void testMarchal_withJaxbObject_shouldReturnSourceInferNameWithoutNamespacePrefix() throws Exception {
        ComplexNode testObject = this.createComplexNode("123");
        Source saxSource = new JaxbBuilder((Object)testObject).build();
        String xmlString = this.toString(saxSource);
        MatcherAssert.assertThat((Object)xmlString, (Matcher)CoreMatchers.startsWith((String)"<complexNode"));
        MatcherAssert.assertThat((Object)xmlString, (Matcher)CoreMatchers.containsString((String)"<Id>123</Id>"));
    }

    @Test
    public void testMarchal_withJaxbObjectUseObjectFactory_shouldReturnSourceWithNamespacePrefix() throws Exception {
        ComplexNode testObject = this.createComplexNode("123");
        Source saxSource = new JaxbBuilder((Object)testObject).useObjectFactory().build();
        String xmlString = this.toString(saxSource);
        if (this.isJdk6()) {
            MatcherAssert.assertThat((Object)xmlString, (Matcher)CoreMatchers.containsString((String)":ComplexNode"));
        } else {
            MatcherAssert.assertThat((Object)xmlString, (Matcher)CoreMatchers.startsWith((String)"<test:ComplexNode"));
        }
        MatcherAssert.assertThat((Object)xmlString, (Matcher)CoreMatchers.containsString((String)"<Id>123</Id>"));
    }

    @Test
    public void testMarchal_withJaxbElement_shouldReturnSource() throws Exception {
        QName name = new QName("http://www.xmlunit.org/test/complexXml", "ComplexNode", "nsXY");
        JAXBElement testJAXBElement = new JAXBElement(name, ComplexNode.class, (Object)this.createComplexNode("123"));
        Source saxSource = new JaxbBuilder((Object)testJAXBElement).build();
        String xmlString = this.toString(saxSource);
        if (this.isJdk6()) {
            MatcherAssert.assertThat((Object)xmlString, (Matcher)CoreMatchers.containsString((String)":ComplexNode"));
        } else {
            MatcherAssert.assertThat((Object)xmlString, (Matcher)CoreMatchers.startsWith((String)"<test:ComplexNode"));
        }
        MatcherAssert.assertThat((Object)xmlString, (Matcher)CoreMatchers.containsString((String)"<Id>123</Id>"));
    }

    private String toString(Source saxSource) throws Exception {
        Document document = Convert.toDocument((Source)saxSource);
        DOMSource domSource = new DOMSource(document);
        StringWriter writer = new StringWriter();
        StreamResult result = new StreamResult(writer);
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer transformer = tf.newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        transformer.transform(domSource, result);
        return writer.toString();
    }

    private RootNode createRootNode(String id) {
        RootNode rootNode = new RootNode();
        rootNode.getIds().add(id);
        return rootNode;
    }

    private ComplexNode createComplexNode(String id) {
        ComplexNode complexNode = new ComplexNode();
        complexNode.setId(id);
        return complexNode;
    }

    private boolean isJdk6() {
        String javaVersion = System.getProperty("java.version").trim();
        return javaVersion.startsWith("1.6");
    }
}

