/*
 * Decompiled with CFR 0.152.
 */
package org.xmlunit.diff;

import javax.xml.transform.Source;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.xmlunit.diff.AbstractDifferenceEngine;
import org.xmlunit.diff.Comparison;
import org.xmlunit.diff.ComparisonController;
import org.xmlunit.diff.ComparisonListener;
import org.xmlunit.diff.ComparisonListenerSupportTest;
import org.xmlunit.diff.ComparisonResult;
import org.xmlunit.diff.ComparisonType;
import org.xmlunit.diff.Difference;
import org.xmlunit.diff.DifferenceEvaluator;

public abstract class AbstractDifferenceEngineTest {
    protected abstract AbstractDifferenceEngine getDifferenceEngine();

    @Test
    public void compareTwoNulls() {
        ResultGrabber g = new ResultGrabber();
        AbstractDifferenceEngine d = this.getDifferenceEngine();
        d.setDifferenceEvaluator((DifferenceEvaluator)g);
        Assert.assertEquals((Object)AbstractDifferenceEngineTest.wrap(ComparisonResult.EQUAL), (Object)d.compare(new Comparison(ComparisonType.HAS_DOCTYPE_DECLARATION, null, null, null, null, null, null, null, null)));
        Assert.assertEquals((Object)ComparisonResult.EQUAL, (Object)g.outcome);
    }

    @Test
    public void compareControlNullTestNonNull() {
        ResultGrabber g = new ResultGrabber();
        AbstractDifferenceEngine d = this.getDifferenceEngine();
        d.setDifferenceEvaluator((DifferenceEvaluator)g);
        Assert.assertEquals((Object)AbstractDifferenceEngineTest.wrap(ComparisonResult.DIFFERENT), (Object)d.compare(new Comparison(ComparisonType.HAS_DOCTYPE_DECLARATION, null, null, null, null, null, null, (Object)"", null)));
        Assert.assertEquals((Object)ComparisonResult.DIFFERENT, (Object)g.outcome);
    }

    @Test
    public void compareControlNonNullTestNull() {
        ResultGrabber g = new ResultGrabber();
        AbstractDifferenceEngine d = this.getDifferenceEngine();
        d.setDifferenceEvaluator((DifferenceEvaluator)g);
        Assert.assertEquals((Object)AbstractDifferenceEngineTest.wrap(ComparisonResult.DIFFERENT), (Object)d.compare(new Comparison(ComparisonType.HAS_DOCTYPE_DECLARATION, null, null, (Object)"", null, null, null, null, null)));
        Assert.assertEquals((Object)ComparisonResult.DIFFERENT, (Object)g.outcome);
    }

    @Test
    public void compareTwoDifferentNonNulls() {
        ResultGrabber g = new ResultGrabber();
        AbstractDifferenceEngine d = this.getDifferenceEngine();
        d.setDifferenceEvaluator((DifferenceEvaluator)g);
        Assert.assertEquals((Object)AbstractDifferenceEngineTest.wrap(ComparisonResult.DIFFERENT), (Object)d.compare(new Comparison(ComparisonType.HAS_DOCTYPE_DECLARATION, null, null, (Object)new Short("1"), null, null, null, (Object)new Short("2"), null)));
        Assert.assertEquals((Object)ComparisonResult.DIFFERENT, (Object)g.outcome);
    }

    @Test
    public void compareTwoEqualNonNulls() {
        ResultGrabber g = new ResultGrabber();
        AbstractDifferenceEngine d = this.getDifferenceEngine();
        d.setDifferenceEvaluator((DifferenceEvaluator)g);
        Assert.assertEquals((Object)AbstractDifferenceEngineTest.wrap(ComparisonResult.EQUAL), (Object)d.compare(new Comparison(ComparisonType.HAS_DOCTYPE_DECLARATION, null, null, (Object)new Short("2"), null, null, null, (Object)new Short("2"), null)));
        Assert.assertEquals((Object)ComparisonResult.EQUAL, (Object)g.outcome);
    }

    @Test
    public void compareNotifiesComparisonListener() {
        AbstractDifferenceEngine d = this.getDifferenceEngine();
        ComparisonListenerSupportTest.Listener l = new ComparisonListenerSupportTest.Listener(ComparisonResult.EQUAL);
        d.addComparisonListener((ComparisonListener)l);
        Assert.assertEquals((Object)AbstractDifferenceEngineTest.wrap(ComparisonResult.EQUAL), (Object)d.compare(new Comparison(ComparisonType.HAS_DOCTYPE_DECLARATION, null, null, (Object)new Short("2"), null, null, null, (Object)new Short("2"), null)));
        Assert.assertEquals((long)1L, (long)l.getInvocations());
    }

    @Test
    public void compareNotifiesMatchListener() {
        AbstractDifferenceEngine d = this.getDifferenceEngine();
        ComparisonListenerSupportTest.Listener l = new ComparisonListenerSupportTest.Listener(ComparisonResult.EQUAL);
        d.addMatchListener((ComparisonListener)l);
        Assert.assertEquals((Object)AbstractDifferenceEngineTest.wrap(ComparisonResult.EQUAL), (Object)d.compare(new Comparison(ComparisonType.HAS_DOCTYPE_DECLARATION, null, null, (Object)new Short("2"), null, null, null, (Object)new Short("2"), null)));
        Assert.assertEquals((long)1L, (long)l.getInvocations());
    }

    @Test
    public void compareNotifiesDifferenceListener() {
        AbstractDifferenceEngine d = this.getDifferenceEngine();
        ComparisonListenerSupportTest.Listener l = new ComparisonListenerSupportTest.Listener(ComparisonResult.SIMILAR);
        d.addDifferenceListener((ComparisonListener)l);
        Assert.assertEquals((Object)AbstractDifferenceEngineTest.wrap(ComparisonResult.SIMILAR), (Object)d.compare(new Comparison(ComparisonType.HAS_DOCTYPE_DECLARATION, null, null, (Object)new Short("2"), null, null, null, (Object)new Short("3"), null)));
        Assert.assertEquals((long)1L, (long)l.getInvocations());
    }

    @Test
    public void compareUsesResultOfEvaluator() {
        AbstractDifferenceEngine d = this.getDifferenceEngine();
        ComparisonListenerSupportTest.Listener l = new ComparisonListenerSupportTest.Listener(ComparisonResult.SIMILAR);
        d.addComparisonListener((ComparisonListener)l);
        d.setDifferenceEvaluator(new DifferenceEvaluator(){

            public ComparisonResult evaluate(Comparison comparison, ComparisonResult outcome) {
                return ComparisonResult.SIMILAR;
            }
        });
        Assert.assertEquals((Object)AbstractDifferenceEngineTest.wrap(ComparisonResult.SIMILAR), (Object)d.compare(new Comparison(ComparisonType.HAS_DOCTYPE_DECLARATION, null, null, (Object)new Short("2"), null, null, null, (Object)new Short("2"), null)));
        Assert.assertEquals((long)1L, (long)l.getInvocations());
    }

    @Test
    public void compareUsesResultOfController() {
        AbstractDifferenceEngine d = this.getDifferenceEngine();
        ComparisonListenerSupportTest.Listener l = new ComparisonListenerSupportTest.Listener(ComparisonResult.SIMILAR);
        d.addComparisonListener((ComparisonListener)l);
        d.setComparisonController(new ComparisonController(){

            public boolean stopDiffing(Difference ignored) {
                return true;
            }
        });
        Assert.assertEquals((Object)AbstractDifferenceEngineTest.wrapAndStop(ComparisonResult.SIMILAR), (Object)d.compare(new Comparison(ComparisonType.HAS_DOCTYPE_DECLARATION, null, null, (Object)new Short("1"), null, null, null, (Object)new Short("2"), null)));
        Assert.assertEquals((long)1L, (long)l.getInvocations());
    }

    @Test
    public void ongoingComparisonStateBasics() {
        AbstractDifferenceEngine.ComparisonState cs = AbstractDifferenceEngineTest.wrap(ComparisonResult.EQUAL);
        Assert.assertEquals((Object)cs, (Object)new WrapHelper().empty());
    }

    @Test
    public void andThenUsesCurrentFinishedFlag() {
        AbstractDifferenceEngine.ComparisonState cs = AbstractDifferenceEngineTest.wrapAndStop(ComparisonResult.SIMILAR);
        Assert.assertEquals((Object)AbstractDifferenceEngineTest.wrapAndStop(ComparisonResult.SIMILAR), (Object)cs.andThen(new AbstractDifferenceEngine.DeferredComparison(){

            public AbstractDifferenceEngine.ComparisonState apply() {
                return AbstractDifferenceEngineTest.wrap(ComparisonResult.EQUAL);
            }
        }));
        cs = AbstractDifferenceEngineTest.wrap(ComparisonResult.SIMILAR);
        Assert.assertEquals((Object)AbstractDifferenceEngineTest.wrap(ComparisonResult.EQUAL), (Object)cs.andThen(new AbstractDifferenceEngine.DeferredComparison(){

            public AbstractDifferenceEngine.ComparisonState apply() {
                return AbstractDifferenceEngineTest.wrap(ComparisonResult.EQUAL);
            }
        }));
    }

    @Test
    public void andIfTrueThenUsesCurrentFinishedFlag() {
        AbstractDifferenceEngine.ComparisonState cs = AbstractDifferenceEngineTest.wrapAndStop(ComparisonResult.SIMILAR);
        Assert.assertEquals((Object)AbstractDifferenceEngineTest.wrapAndStop(ComparisonResult.SIMILAR), (Object)cs.andIfTrueThen(true, new AbstractDifferenceEngine.DeferredComparison(){

            public AbstractDifferenceEngine.ComparisonState apply() {
                return AbstractDifferenceEngineTest.wrap(ComparisonResult.EQUAL);
            }
        }));
        cs = AbstractDifferenceEngineTest.wrap(ComparisonResult.SIMILAR);
        Assert.assertEquals((Object)AbstractDifferenceEngineTest.wrap(ComparisonResult.EQUAL), (Object)cs.andIfTrueThen(true, new AbstractDifferenceEngine.DeferredComparison(){

            public AbstractDifferenceEngine.ComparisonState apply() {
                return AbstractDifferenceEngineTest.wrap(ComparisonResult.EQUAL);
            }
        }));
    }

    @Test
    public void andIfTrueThenIsNoopIfFirstArgIsFalse() {
        AbstractDifferenceEngine.ComparisonState cs = AbstractDifferenceEngineTest.wrapAndStop(ComparisonResult.SIMILAR);
        Assert.assertEquals((Object)AbstractDifferenceEngineTest.wrapAndStop(ComparisonResult.SIMILAR), (Object)cs.andIfTrueThen(false, new AbstractDifferenceEngine.DeferredComparison(){

            public AbstractDifferenceEngine.ComparisonState apply() {
                return AbstractDifferenceEngineTest.wrap(ComparisonResult.EQUAL);
            }
        }));
        cs = AbstractDifferenceEngineTest.wrap(ComparisonResult.SIMILAR);
        Assert.assertEquals((Object)AbstractDifferenceEngineTest.wrap(ComparisonResult.SIMILAR), (Object)cs.andIfTrueThen(false, new AbstractDifferenceEngine.DeferredComparison(){

            public AbstractDifferenceEngine.ComparisonState apply() {
                return AbstractDifferenceEngineTest.wrap(ComparisonResult.EQUAL);
            }
        }));
    }

    @Test(expected=IllegalArgumentException.class)
    public void cantAddNullComparisonListener() {
        this.getDifferenceEngine().addComparisonListener(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void cantAddNullMatchListener() {
        this.getDifferenceEngine().addMatchListener(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void cantAddNullDifferenceListener() {
        this.getDifferenceEngine().addDifferenceListener(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void cantSetNullNodeMatcher() {
        this.getDifferenceEngine().setNodeMatcher(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void cantSetNullComparisonController() {
        this.getDifferenceEngine().setComparisonController(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void cantSetNullDifferenceEvaluator() {
        this.getDifferenceEngine().setDifferenceEvaluator(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void cantSetNullAttributeFilter() {
        this.getDifferenceEngine().setAttributeFilter(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void cantSetNullNodeFilter() {
        this.getDifferenceEngine().setNodeFilter(null);
    }

    @Test
    public void comparisonStateEqualsLooksAtType() {
        WrapHelper w = new WrapHelper();
        Assert.assertNotEquals((Object)w.wrap(ComparisonResult.SIMILAR), (Object)w.myOngoing());
    }

    @Test
    public void comparisonStateEqualsLooksAtResult() {
        Assert.assertNotEquals((Object)AbstractDifferenceEngineTest.wrap(ComparisonResult.SIMILAR), (Object)AbstractDifferenceEngineTest.wrap(ComparisonResult.DIFFERENT));
    }

    @Test
    public void hashCodeLooksAtFinished() {
        Assert.assertNotEquals((long)AbstractDifferenceEngineTest.wrap(ComparisonResult.SIMILAR).hashCode(), (long)AbstractDifferenceEngineTest.wrapAndStop(ComparisonResult.SIMILAR).hashCode());
    }

    @Test
    public void trivialComparisonStateToString() {
        String s = AbstractDifferenceEngineTest.wrap(ComparisonResult.SIMILAR).toString();
        Assert.assertThat((Object)s, (Matcher)Matchers.containsString((String)"OngoingComparisonState"));
        Assert.assertThat((Object)s, (Matcher)Matchers.containsString((String)"SIMILAR"));
    }

    protected static AbstractDifferenceEngine.ComparisonState wrap(ComparisonResult c) {
        return new WrapHelper().wrap(c);
    }

    protected static AbstractDifferenceEngine.ComparisonState wrapAndStop(ComparisonResult c) {
        return new WrapHelper().wrapAndStop(c);
    }

    private static class WrapHelper
    extends AbstractDifferenceEngine {
        private WrapHelper() {
        }

        private AbstractDifferenceEngine.ComparisonState empty() {
            return new AbstractDifferenceEngine.OngoingComparisonState((AbstractDifferenceEngine)this);
        }

        private AbstractDifferenceEngine.ComparisonState wrap(ComparisonResult r) {
            return new AbstractDifferenceEngine.OngoingComparisonState((AbstractDifferenceEngine)this, r);
        }

        private AbstractDifferenceEngine.ComparisonState wrapAndStop(ComparisonResult r) {
            return new AbstractDifferenceEngine.FinishedComparisonState((AbstractDifferenceEngine)this, r);
        }

        private AbstractDifferenceEngine.ComparisonState myOngoing() {
            return new AbstractDifferenceEngine.ComparisonState(false, ComparisonResult.SIMILAR){};
        }

        public void compare(Source control, Source test) {
        }
    }

    private static class ResultGrabber
    implements DifferenceEvaluator {
        private ComparisonResult outcome = ComparisonResult.SIMILAR;

        private ResultGrabber() {
        }

        public ComparisonResult evaluate(Comparison comparison, ComparisonResult outcome) {
            this.outcome = outcome;
            return outcome;
        }
    }
}

