/*
 * Decompiled with CFR 0.152.
 */
package org.xmlunit.diff;

import javax.xml.parsers.DocumentBuilderFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xmlunit.builder.DiffBuilder;
import org.xmlunit.diff.ByNameAndTextRecSelector;
import org.xmlunit.diff.ComparisonFormatter;
import org.xmlunit.diff.DefaultComparisonFormatter;
import org.xmlunit.diff.DefaultNodeMatcher;
import org.xmlunit.diff.Diff;
import org.xmlunit.diff.ElementSelector;
import org.xmlunit.diff.ElementSelectors;
import org.xmlunit.diff.ElementSelectorsTest;
import org.xmlunit.diff.NodeMatcher;

public class ByNameAndTextRecSelectorTest {
    private Document doc;

    @Before
    public void createDoc() throws Exception {
        this.doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
    }

    @Test
    public void byNameAndTextRec_NamePart() {
        ElementSelectorsTest.pureElementNameComparisons((ElementSelector)new ByNameAndTextRecSelector(), this.doc);
    }

    @Test
    public void byNameAndTextRec_Single() {
        ElementSelectorsTest.byNameAndText_SingleLevel((ElementSelector)new ByNameAndTextRecSelector(), this.doc);
    }

    @Test
    public void byNameAndTextRec() {
        Element control = this.doc.createElement("foo");
        Element child = this.doc.createElement("bar");
        control.appendChild(child);
        child.appendChild(this.doc.createTextNode("bar"));
        Element equal = this.doc.createElement("foo");
        Element child2 = this.doc.createElement("bar");
        equal.appendChild(child2);
        child2.appendChild(this.doc.createTextNode("bar"));
        Element equalC = this.doc.createElement("foo");
        Element child3 = this.doc.createElement("bar");
        equalC.appendChild(child3);
        child3.appendChild(this.doc.createCDATASection("bar"));
        Element noText = this.doc.createElement("foo");
        Element differentLevel = this.doc.createElement("foo");
        differentLevel.appendChild(this.doc.createTextNode("bar"));
        Element differentElement = this.doc.createElement("foo");
        Element child4 = this.doc.createElement("foo");
        differentElement.appendChild(child4);
        child4.appendChild(this.doc.createTextNode("bar"));
        Element differentText = this.doc.createElement("foo");
        Element child5 = this.doc.createElement("bar");
        differentText.appendChild(child5);
        child5.appendChild(this.doc.createTextNode("foo"));
        ByNameAndTextRecSelector s = new ByNameAndTextRecSelector();
        Assert.assertTrue((boolean)s.canBeCompared(control, equal));
        Assert.assertTrue((boolean)s.canBeCompared(control, equalC));
        Assert.assertFalse((boolean)s.canBeCompared(control, noText));
        Assert.assertFalse((boolean)s.canBeCompared(control, differentLevel));
        Assert.assertFalse((boolean)s.canBeCompared(control, differentElement));
        Assert.assertFalse((boolean)s.canBeCompared(control, differentText));
    }

    @Test
    public void byNameAndTextRec_Multilevel() throws Exception {
        Document control = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        Element root = control.createElement("root");
        control.appendChild(root);
        Element controlSub = control.createElement("sub");
        root.appendChild(controlSub);
        Element controlSubSubValue = control.createElement("value");
        controlSub.appendChild(controlSubSubValue);
        controlSubSubValue.appendChild(control.createTextNode("1"));
        controlSubSubValue = control.createElement("value");
        controlSub.appendChild(controlSubSubValue);
        controlSubSubValue.appendChild(control.createTextNode("2"));
        controlSub = control.createElement("sub");
        root.appendChild(controlSub);
        controlSubSubValue = control.createElement("value");
        controlSub.appendChild(controlSubSubValue);
        controlSubSubValue.appendChild(control.createTextNode("3"));
        controlSubSubValue = control.createElement("value");
        controlSub.appendChild(controlSubSubValue);
        controlSubSubValue.appendChild(control.createTextNode("4"));
        Document test = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        Element root2 = test.createElement("root");
        test.appendChild(root2);
        Element testSub = test.createElement("sub");
        root2.appendChild(testSub);
        Element testSubValue = test.createElement("value");
        testSub.appendChild(testSubValue);
        testSubValue.appendChild(test.createTextNode("1"));
        testSubValue = test.createElement("value");
        testSub.appendChild(testSubValue);
        testSubValue.appendChild(test.createTextNode("2"));
        testSub = test.createElement("sub");
        root2.appendChild(testSub);
        testSubValue = test.createElement("value");
        testSub.appendChild(testSubValue);
        testSubValue.appendChild(test.createTextNode("4"));
        testSubValue = test.createElement("value");
        testSub.appendChild(testSubValue);
        testSubValue.appendChild(test.createTextNode("3"));
        DiffBuilder builder = DiffBuilder.compare((Object)control).withTest((Object)test).checkForSimilar().withNodeMatcher((NodeMatcher)new DefaultNodeMatcher(new ElementSelector[]{ElementSelectors.or((ElementSelector[])new ElementSelector[]{new ByNameAndTextRecSelector(), ElementSelectors.byName})}));
        Diff d = builder.build();
        Assert.assertTrue((String)d.toString((ComparisonFormatter)new DefaultComparisonFormatter()), (boolean)d.hasDifferences());
        builder = DiffBuilder.compare((Object)control).withTest((Object)test).checkForSimilar().withNodeMatcher((NodeMatcher)new DefaultNodeMatcher(new ElementSelector[]{new ByNameAndTextRecSelector(), ElementSelectors.byName}));
        d = builder.build();
        Assert.assertFalse((String)d.toString((ComparisonFormatter)new DefaultComparisonFormatter()), (boolean)d.hasDifferences());
    }
}

