/*
 * Decompiled with CFR 0.152.
 */
package org.xmlunit.diff;

import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import javax.xml.parsers.DocumentBuilderFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xmlunit.diff.ChildNodeXPathContextProvider;
import org.xmlunit.diff.ElementSelectors;
import org.xmlunit.diff.XPathContext;
import org.xmlunit.util.Linqy;
import org.xmlunit.util.Mapper;

public class ChildNodeXPathContextProviderTest {
    private Document doc;
    private XPathContext ctx;
    private List<Node> elements;

    @Before
    public void init() throws Exception {
        this.doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        this.elements = new ArrayList<Node>();
        this.elements.add(this.doc.createElement("foo"));
        this.elements.add(this.doc.createElement("foo"));
        this.elements.add(this.doc.createElement("bar"));
        this.elements.add(this.doc.createElement("foo"));
        this.ctx = new XPathContext();
        this.ctx.setChildren(Linqy.map(this.elements, (Mapper)ElementSelectors.TO_NODE_INFO));
    }

    @Test
    public void shouldReturnACopyOfOriginalXPathContext() {
        ChildNodeXPathContextProvider p = new ChildNodeXPathContextProvider(this.ctx, this.elements);
        XPathContext provided = p.apply(this.elements.get(0));
        Assert.assertNotSame((Object)this.ctx, (Object)provided);
    }

    @Test
    public void shouldFindCorrectChildIndex() {
        ChildNodeXPathContextProvider p = new ChildNodeXPathContextProvider(this.ctx, this.elements);
        XPathContext provided = p.apply(this.elements.get(1));
        Assert.assertEquals((Object)"/foo[2]", (Object)provided.getXPath());
    }

    @Test(expected=NoSuchElementException.class)
    public void shouldThrowIfNodeIsNotInInitialList() throws Exception {
        ChildNodeXPathContextProvider p = new ChildNodeXPathContextProvider(this.ctx, this.elements);
        XPathContext provided = p.apply((Node)this.doc.createElement("foo"));
    }
}

