/*
 * Decompiled with CFR 0.152.
 */
package org.xmlunit.diff;

import java.util.Arrays;
import java.util.HashSet;
import org.junit.Assert;
import org.junit.Test;
import org.xmlunit.diff.Comparison;
import org.xmlunit.diff.ComparisonListener;
import org.xmlunit.diff.ComparisonListenerSupport;
import org.xmlunit.diff.ComparisonResult;

public class ComparisonListenerSupportTest {
    @Test
    public void dispatchesOnOutcome() {
        ComparisonListenerSupport s = new ComparisonListenerSupport();
        Listener c = new Listener(ComparisonResult.EQUAL, ComparisonResult.SIMILAR, ComparisonResult.DIFFERENT);
        s.addComparisonListener((ComparisonListener)c);
        Listener m = new Listener(ComparisonResult.EQUAL);
        s.addMatchListener((ComparisonListener)m);
        Listener d = new Listener(ComparisonResult.SIMILAR, ComparisonResult.DIFFERENT);
        s.addDifferenceListener((ComparisonListener)d);
        for (ComparisonResult r : new ComparisonResult[]{ComparisonResult.EQUAL, ComparisonResult.SIMILAR, ComparisonResult.DIFFERENT}) {
            s.fireComparisonPerformed(null, r);
        }
        Assert.assertEquals((long)3L, (long)c.invocations);
        Assert.assertEquals((long)1L, (long)m.invocations);
        Assert.assertEquals((long)2L, (long)d.invocations);
    }

    @Test
    public void noListenersDontCauseProblems() {
        ComparisonListenerSupport s = new ComparisonListenerSupport();
        s.fireComparisonPerformed(null, ComparisonResult.EQUAL);
    }

    static class Listener
    implements ComparisonListener {
        private final HashSet<ComparisonResult> acceptable = new HashSet();
        private int invocations = 0;

        Listener(ComparisonResult ... accept) {
            this.acceptable.addAll(Arrays.asList(accept));
        }

        public void comparisonPerformed(Comparison comparison, ComparisonResult outcome) {
            ++this.invocations;
            if (!this.acceptable.contains(outcome)) {
                Assert.fail((String)("unexpected outcome: " + outcome));
            }
        }

        int getInvocations() {
            return this.invocations;
        }
    }
}

