/*
 * Decompiled with CFR 0.152.
 */
package org.xmlunit.diff;

import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.xmlunit.NullNode;
import org.xmlunit.builder.Input;
import org.xmlunit.diff.AbstractDifferenceEngine;
import org.xmlunit.diff.AbstractDifferenceEngineTest;
import org.xmlunit.diff.Comparison;
import org.xmlunit.diff.ComparisonControllers;
import org.xmlunit.diff.ComparisonListener;
import org.xmlunit.diff.ComparisonResult;
import org.xmlunit.diff.ComparisonType;
import org.xmlunit.diff.DOMDifferenceEngine;
import org.xmlunit.diff.DefaultNodeMatcher;
import org.xmlunit.diff.DifferenceEvaluator;
import org.xmlunit.diff.ElementSelector;
import org.xmlunit.diff.ElementSelectors;
import org.xmlunit.diff.NodeMatcher;
import org.xmlunit.diff.XPathContext;
import org.xmlunit.util.Convert;
import org.xmlunit.util.Predicate;

public class DOMDifferenceEngineTest
extends AbstractDifferenceEngineTest {
    private Document doc;

    @Override
    protected AbstractDifferenceEngine getDifferenceEngine() {
        return new DOMDifferenceEngine();
    }

    @Before
    public void createDoc() throws Exception {
        this.doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
    }

    @Test
    public void diffExpecterParentXPath() {
        DiffExpecter ex = new DiffExpecter(ComparisonType.ATTR_NAME_LOOKUP);
        Assert.assertEquals((Object)"/bla/blubb", (Object)ex.getParentXPath("/bla/blubb/x[1]"));
        Assert.assertEquals((Object)"/bla/blubb", (Object)ex.getParentXPath("/bla/blubb/@attr"));
        Assert.assertEquals((Object)"/", (Object)ex.getParentXPath("/bla[1]"));
        Assert.assertEquals((Object)"/", (Object)ex.getParentXPath("/@attr"));
        Assert.assertEquals((Object)"", (Object)ex.getParentXPath("/"));
        Assert.assertEquals((Object)"", (Object)ex.getParentXPath(""));
        Assert.assertEquals(null, (Object)ex.getParentXPath(null));
    }

    @Test
    public void compareXPathOfDifferentRootElements() {
        DOMDifferenceEngine d = new DOMDifferenceEngine();
        DiffExpecter ex = new DiffExpecter(ComparisonType.ELEMENT_TAG_NAME, "/x[1]", "/y[1]");
        d.addDifferenceListener((ComparisonListener)ex);
        d.setComparisonController(ComparisonControllers.StopWhenDifferent);
        d.compare((Source)new DOMSource(this.doc.createElement("x")), (Source)new DOMSource(this.doc.createElement("y")));
        Assert.assertEquals((long)1L, (long)ex.invoked);
    }

    @Test
    public void compareNodesOfDifferentType() {
        DOMDifferenceEngine d = new DOMDifferenceEngine();
        DiffExpecter ex = new DiffExpecter(ComparisonType.NODE_TYPE);
        d.addDifferenceListener((ComparisonListener)ex);
        d.setComparisonController(ComparisonControllers.StopWhenDifferent);
        Assert.assertEquals((Object)DOMDifferenceEngineTest.wrapAndStop(ComparisonResult.DIFFERENT), (Object)d.compareNodes((Node)this.doc.createElement("x"), new XPathContext(), (Node)this.doc.createComment("x"), new XPathContext()));
        Assert.assertEquals((long)1L, (long)ex.invoked);
    }

    @Test
    public void compareNodesWithoutNS() {
        DOMDifferenceEngine d = new DOMDifferenceEngine();
        DiffExpecter ex = new DiffExpecter(ComparisonType.NODE_TYPE, 0);
        d.addDifferenceListener((ComparisonListener)ex);
        d.setComparisonController(ComparisonControllers.StopWhenDifferent);
        Assert.assertEquals((Object)DOMDifferenceEngineTest.wrap(ComparisonResult.EQUAL), (Object)d.compareNodes((Node)this.doc.createElement("x"), new XPathContext(), (Node)this.doc.createElement("x"), new XPathContext()));
        Assert.assertEquals((long)0L, (long)ex.invoked);
    }

    @Test
    public void compareNodesDifferentNS() {
        DOMDifferenceEngine d = new DOMDifferenceEngine();
        DiffExpecter ex = new DiffExpecter(ComparisonType.NAMESPACE_URI);
        d.addDifferenceListener((ComparisonListener)ex);
        d.setComparisonController(ComparisonControllers.StopWhenDifferent);
        Assert.assertEquals((Object)DOMDifferenceEngineTest.wrapAndStop(ComparisonResult.DIFFERENT), (Object)d.compareNodes((Node)this.doc.createElementNS("x", "y"), new XPathContext(), (Node)this.doc.createElementNS("z", "y"), new XPathContext()));
        Assert.assertEquals((long)1L, (long)ex.invoked);
    }

    @Test
    public void compareNodesDifferentPrefix() {
        DOMDifferenceEngine d = new DOMDifferenceEngine();
        DiffExpecter ex = new DiffExpecter(ComparisonType.NAMESPACE_PREFIX);
        d.addDifferenceListener((ComparisonListener)ex);
        d.setDifferenceEvaluator(new DifferenceEvaluator(){

            public ComparisonResult evaluate(Comparison comparison, ComparisonResult outcome) {
                if (comparison.getType() == ComparisonType.NAMESPACE_PREFIX) {
                    Assert.assertEquals((Object)ComparisonResult.DIFFERENT, (Object)outcome);
                    return ComparisonResult.DIFFERENT;
                }
                Assert.assertEquals((Object)ComparisonResult.EQUAL, (Object)outcome);
                return ComparisonResult.EQUAL;
            }
        });
        d.setComparisonController(ComparisonControllers.StopWhenDifferent);
        Assert.assertEquals((Object)DOMDifferenceEngineTest.wrapAndStop(ComparisonResult.DIFFERENT), (Object)d.compareNodes((Node)this.doc.createElementNS("x", "x:y"), new XPathContext(), (Node)this.doc.createElementNS("x", "z:y"), new XPathContext()));
        Assert.assertEquals((long)1L, (long)ex.invoked);
    }

    @Test
    public void compareNodesDifferentNumberOfChildren() {
        DOMDifferenceEngine d = new DOMDifferenceEngine();
        DiffExpecter ex = new DiffExpecter(ComparisonType.CHILD_NODELIST_LENGTH, 2);
        d.addDifferenceListener((ComparisonListener)ex);
        d.setComparisonController(ComparisonControllers.StopWhenDifferent);
        Element e1 = this.doc.createElement("x");
        Element e2 = this.doc.createElement("x");
        Assert.assertEquals((Object)DOMDifferenceEngineTest.wrap(ComparisonResult.EQUAL), (Object)d.compareNodes((Node)e1, new XPathContext(), (Node)e2, new XPathContext()));
        e1.appendChild(this.doc.createElement("x"));
        Assert.assertEquals((Object)DOMDifferenceEngineTest.wrapAndStop(ComparisonResult.DIFFERENT), (Object)d.compareNodes((Node)e1, new XPathContext(), (Node)e2, new XPathContext()));
        Assert.assertEquals((long)1L, (long)ex.invoked);
        e2.appendChild(this.doc.createElement("x"));
        Assert.assertEquals((Object)DOMDifferenceEngineTest.wrap(ComparisonResult.EQUAL), (Object)d.compareNodes((Node)e1, new XPathContext(), (Node)e2, new XPathContext()));
        e2.appendChild(this.doc.createElement("x"));
        Assert.assertEquals((Object)DOMDifferenceEngineTest.wrapAndStop(ComparisonResult.DIFFERENT), (Object)d.compareNodes((Node)e1, new XPathContext(), (Node)e2, new XPathContext()));
        Assert.assertEquals((long)2L, (long)ex.invoked);
    }

    @Test
    public void compareCharacterData() {
        DOMDifferenceEngine d = new DOMDifferenceEngine();
        DiffExpecter ex = new DiffExpecter(ComparisonType.TEXT_VALUE, 9);
        d.addDifferenceListener((ComparisonListener)ex);
        d.setDifferenceEvaluator(new DifferenceEvaluator(){

            public ComparisonResult evaluate(Comparison comparison, ComparisonResult outcome) {
                if (comparison.getType() == ComparisonType.NODE_TYPE && (outcome == ComparisonResult.EQUAL || comparison.getControlDetails().getTarget() instanceof CharacterData && comparison.getTestDetails().getTarget() instanceof CharacterData)) {
                    return ComparisonResult.EQUAL;
                }
                return outcome;
            }
        });
        d.setComparisonController(ComparisonControllers.StopWhenDifferent);
        Comment fooComment = this.doc.createComment("foo");
        Comment barComment = this.doc.createComment("bar");
        Text fooText = this.doc.createTextNode("foo");
        Text barText = this.doc.createTextNode("bar");
        CDATASection fooCDATASection = this.doc.createCDATASection("foo");
        CDATASection barCDATASection = this.doc.createCDATASection("bar");
        Assert.assertEquals((Object)DOMDifferenceEngineTest.wrap(ComparisonResult.EQUAL), (Object)d.compareNodes((Node)fooComment, new XPathContext(), (Node)fooComment, new XPathContext()));
        Assert.assertEquals((Object)DOMDifferenceEngineTest.wrapAndStop(ComparisonResult.DIFFERENT), (Object)d.compareNodes((Node)fooComment, new XPathContext(), (Node)barComment, new XPathContext()));
        Assert.assertEquals((Object)DOMDifferenceEngineTest.wrap(ComparisonResult.EQUAL), (Object)d.compareNodes((Node)fooText, new XPathContext(), (Node)fooText, new XPathContext()));
        Assert.assertEquals((Object)DOMDifferenceEngineTest.wrapAndStop(ComparisonResult.DIFFERENT), (Object)d.compareNodes((Node)fooText, new XPathContext(), (Node)barText, new XPathContext()));
        Assert.assertEquals((Object)DOMDifferenceEngineTest.wrap(ComparisonResult.EQUAL), (Object)d.compareNodes((Node)fooCDATASection, new XPathContext(), (Node)fooCDATASection, new XPathContext()));
        Assert.assertEquals((Object)DOMDifferenceEngineTest.wrapAndStop(ComparisonResult.DIFFERENT), (Object)d.compareNodes((Node)fooCDATASection, new XPathContext(), (Node)barCDATASection, new XPathContext()));
        Assert.assertEquals((Object)DOMDifferenceEngineTest.wrap(ComparisonResult.EQUAL), (Object)d.compareNodes((Node)fooComment, new XPathContext(), (Node)fooText, new XPathContext()));
        Assert.assertEquals((Object)DOMDifferenceEngineTest.wrapAndStop(ComparisonResult.DIFFERENT), (Object)d.compareNodes((Node)fooComment, new XPathContext(), (Node)barText, new XPathContext()));
        Assert.assertEquals((Object)DOMDifferenceEngineTest.wrap(ComparisonResult.EQUAL), (Object)d.compareNodes((Node)fooComment, new XPathContext(), (Node)fooCDATASection, new XPathContext()));
        Assert.assertEquals((Object)DOMDifferenceEngineTest.wrapAndStop(ComparisonResult.DIFFERENT), (Object)d.compareNodes((Node)fooComment, new XPathContext(), (Node)barCDATASection, new XPathContext()));
        Assert.assertEquals((Object)DOMDifferenceEngineTest.wrap(ComparisonResult.EQUAL), (Object)d.compareNodes((Node)fooText, new XPathContext(), (Node)fooComment, new XPathContext()));
        Assert.assertEquals((Object)DOMDifferenceEngineTest.wrapAndStop(ComparisonResult.DIFFERENT), (Object)d.compareNodes((Node)fooText, new XPathContext(), (Node)barComment, new XPathContext()));
        Assert.assertEquals((Object)DOMDifferenceEngineTest.wrap(ComparisonResult.EQUAL), (Object)d.compareNodes((Node)fooText, new XPathContext(), (Node)fooCDATASection, new XPathContext()));
        Assert.assertEquals((Object)DOMDifferenceEngineTest.wrapAndStop(ComparisonResult.DIFFERENT), (Object)d.compareNodes((Node)fooText, new XPathContext(), (Node)barCDATASection, new XPathContext()));
        Assert.assertEquals((Object)DOMDifferenceEngineTest.wrap(ComparisonResult.EQUAL), (Object)d.compareNodes((Node)fooCDATASection, new XPathContext(), (Node)fooText, new XPathContext()));
        Assert.assertEquals((Object)DOMDifferenceEngineTest.wrapAndStop(ComparisonResult.DIFFERENT), (Object)d.compareNodes((Node)fooCDATASection, new XPathContext(), (Node)barText, new XPathContext()));
        Assert.assertEquals((Object)DOMDifferenceEngineTest.wrap(ComparisonResult.EQUAL), (Object)d.compareNodes((Node)fooCDATASection, new XPathContext(), (Node)fooComment, new XPathContext()));
        Assert.assertEquals((Object)DOMDifferenceEngineTest.wrapAndStop(ComparisonResult.DIFFERENT), (Object)d.compareNodes((Node)fooCDATASection, new XPathContext(), (Node)barComment, new XPathContext()));
        Assert.assertEquals((long)9L, (long)ex.invoked);
    }

    @Test
    public void compareProcessingInstructions() {
        DOMDifferenceEngine d = new DOMDifferenceEngine();
        DiffExpecter ex = new DiffExpecter(ComparisonType.PROCESSING_INSTRUCTION_TARGET);
        d.addDifferenceListener((ComparisonListener)ex);
        d.setComparisonController(ComparisonControllers.StopWhenDifferent);
        ProcessingInstruction foo1 = this.doc.createProcessingInstruction("foo", "1");
        ProcessingInstruction bar1 = this.doc.createProcessingInstruction("bar", "1");
        Assert.assertEquals((Object)DOMDifferenceEngineTest.wrap(ComparisonResult.EQUAL), (Object)d.compareNodes((Node)foo1, new XPathContext(), (Node)foo1, new XPathContext()));
        Assert.assertEquals((Object)DOMDifferenceEngineTest.wrapAndStop(ComparisonResult.DIFFERENT), (Object)d.compareNodes((Node)foo1, new XPathContext(), (Node)bar1, new XPathContext()));
        Assert.assertEquals((long)1L, (long)ex.invoked);
        d = new DOMDifferenceEngine();
        ex = new DiffExpecter(ComparisonType.PROCESSING_INSTRUCTION_DATA);
        d.addDifferenceListener((ComparisonListener)ex);
        d.setComparisonController(ComparisonControllers.StopWhenDifferent);
        ProcessingInstruction foo2 = this.doc.createProcessingInstruction("foo", "2");
        Assert.assertEquals((Object)DOMDifferenceEngineTest.wrap(ComparisonResult.EQUAL), (Object)d.compareNodes((Node)foo1, new XPathContext(), (Node)foo1, new XPathContext()));
        Assert.assertEquals((Object)DOMDifferenceEngineTest.wrapAndStop(ComparisonResult.DIFFERENT), (Object)d.compareNodes((Node)foo1, new XPathContext(), (Node)foo2, new XPathContext()));
        Assert.assertEquals((long)1L, (long)ex.invoked);
    }

    @Test
    public void compareDocuments() {
        DOMDifferenceEngine d = new DOMDifferenceEngine();
        DiffExpecter ex = new DiffExpecter(ComparisonType.HAS_DOCTYPE_DECLARATION);
        d.addDifferenceListener((ComparisonListener)ex);
        d.setDifferenceEvaluator(new DifferenceEvaluator(){

            public ComparisonResult evaluate(Comparison comparison, ComparisonResult outcome) {
                if (comparison.getType() == ComparisonType.HAS_DOCTYPE_DECLARATION) {
                    Assert.assertEquals((Object)ComparisonResult.DIFFERENT, (Object)outcome);
                    return ComparisonResult.DIFFERENT;
                }
                Assert.assertEquals((String)("Expected EQUAL for " + comparison.getType() + " comparison."), (Object)ComparisonResult.EQUAL, (Object)outcome);
                return ComparisonResult.EQUAL;
            }
        });
        d.setComparisonController(ComparisonControllers.StopWhenDifferent);
        Document d1 = Convert.toDocument((Source)Input.fromString((String)"<Book/>").build());
        Document d2 = Convert.toDocument((Source)Input.fromString((String)"<!DOCTYPE Book PUBLIC \"XMLUNIT/TEST/PUB\" \"../test-resources/Book.dtd\"><Book/>").build());
        Assert.assertEquals((Object)DOMDifferenceEngineTest.wrapAndStop(ComparisonResult.DIFFERENT), (Object)d.compareNodes((Node)d1, new XPathContext(), (Node)d2, new XPathContext()));
        Assert.assertEquals((long)1L, (long)ex.invoked);
        d = new DOMDifferenceEngine();
        ex = new DiffExpecter(ComparisonType.XML_VERSION);
        d.addDifferenceListener((ComparisonListener)ex);
        d.setComparisonController(ComparisonControllers.StopWhenDifferent);
        d1 = Convert.toDocument((Source)Input.fromString((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><Book/>").build());
        d2 = Convert.toDocument((Source)Input.fromString((String)"<?xml version=\"1.1\" encoding=\"UTF-8\"?><Book/>").build());
        Assert.assertEquals((Object)DOMDifferenceEngineTest.wrapAndStop(ComparisonResult.DIFFERENT), (Object)d.compareNodes((Node)d1, new XPathContext(), (Node)d2, new XPathContext()));
        Assert.assertEquals((long)1L, (long)ex.invoked);
        d = new DOMDifferenceEngine();
        ex = new DiffExpecter(ComparisonType.XML_STANDALONE);
        d.addDifferenceListener((ComparisonListener)ex);
        d.setComparisonController(ComparisonControllers.StopWhenDifferent);
        d1 = Convert.toDocument((Source)Input.fromString((String)"<?xml version=\"1.0\" standalone=\"yes\"?><Book/>").build());
        d2 = Convert.toDocument((Source)Input.fromString((String)"<?xml version=\"1.0\" standalone=\"no\"?><Book/>").build());
        Assert.assertEquals((Object)DOMDifferenceEngineTest.wrapAndStop(ComparisonResult.DIFFERENT), (Object)d.compareNodes((Node)d1, new XPathContext(), (Node)d2, new XPathContext()));
        Assert.assertEquals((long)1L, (long)ex.invoked);
        d = new DOMDifferenceEngine();
        ex = new DiffExpecter(ComparisonType.XML_ENCODING);
        d.addDifferenceListener((ComparisonListener)ex);
        d.setDifferenceEvaluator(new DifferenceEvaluator(){

            public ComparisonResult evaluate(Comparison comparison, ComparisonResult outcome) {
                if (comparison.getType() == ComparisonType.XML_ENCODING) {
                    Assert.assertEquals((Object)ComparisonResult.DIFFERENT, (Object)outcome);
                    return ComparisonResult.DIFFERENT;
                }
                Assert.assertEquals((Object)ComparisonResult.EQUAL, (Object)outcome);
                return ComparisonResult.EQUAL;
            }
        });
        d.setComparisonController(ComparisonControllers.StopWhenDifferent);
        d1 = Convert.toDocument((Source)Input.fromString((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><Book/>").build());
        d2 = Convert.toDocument((Source)Input.fromString((String)"<?xml version=\"1.0\" encoding=\"UTF-16\"?><Book/>").build());
        Assert.assertEquals((Object)DOMDifferenceEngineTest.wrapAndStop(ComparisonResult.DIFFERENT), (Object)d.compareNodes((Node)d1, new XPathContext(), (Node)d2, new XPathContext()));
        Assert.assertEquals((long)1L, (long)ex.invoked);
    }

    @Test
    public void compareDocTypes() {
        DOMDifferenceEngine d = new DOMDifferenceEngine();
        DiffExpecter ex = new DiffExpecter(ComparisonType.DOCTYPE_NAME);
        d.addDifferenceListener((ComparisonListener)ex);
        d.setComparisonController(ComparisonControllers.StopWhenDifferent);
        DocType dt1 = new DocType("name", "pub", "system");
        DocType dt2 = new DocType("name2", "pub", "system");
        Assert.assertEquals((Object)DOMDifferenceEngineTest.wrapAndStop(ComparisonResult.DIFFERENT), (Object)d.compareNodes((Node)dt1, new XPathContext(), (Node)dt2, new XPathContext()));
        Assert.assertEquals((long)1L, (long)ex.invoked);
        d = new DOMDifferenceEngine();
        ex = new DiffExpecter(ComparisonType.DOCTYPE_PUBLIC_ID);
        d.addDifferenceListener((ComparisonListener)ex);
        d.setComparisonController(ComparisonControllers.StopWhenDifferent);
        dt2 = new DocType("name", "pub2", "system");
        Assert.assertEquals((Object)DOMDifferenceEngineTest.wrapAndStop(ComparisonResult.DIFFERENT), (Object)d.compareNodes((Node)dt1, new XPathContext(), (Node)dt2, new XPathContext()));
        Assert.assertEquals((long)1L, (long)ex.invoked);
        d = new DOMDifferenceEngine();
        ex = new DiffExpecter(ComparisonType.DOCTYPE_SYSTEM_ID);
        d.addDifferenceListener((ComparisonListener)ex);
        d.setDifferenceEvaluator(new DifferenceEvaluator(){

            public ComparisonResult evaluate(Comparison comparison, ComparisonResult outcome) {
                if (comparison.getType() == ComparisonType.DOCTYPE_SYSTEM_ID) {
                    Assert.assertEquals((Object)ComparisonResult.DIFFERENT, (Object)outcome);
                    return ComparisonResult.DIFFERENT;
                }
                Assert.assertEquals((Object)ComparisonResult.EQUAL, (Object)outcome);
                return ComparisonResult.EQUAL;
            }
        });
        d.setComparisonController(ComparisonControllers.StopWhenDifferent);
        dt2 = new DocType("name", "pub", "system2");
        Assert.assertEquals((Object)DOMDifferenceEngineTest.wrapAndStop(ComparisonResult.DIFFERENT), (Object)d.compareNodes((Node)dt1, new XPathContext(), (Node)dt2, new XPathContext()));
        Assert.assertEquals((long)1L, (long)ex.invoked);
    }

    @Test
    public void compareElements() {
        DOMDifferenceEngine d = new DOMDifferenceEngine();
        DiffExpecter ex = new DiffExpecter(ComparisonType.ELEMENT_TAG_NAME);
        d.addDifferenceListener((ComparisonListener)ex);
        d.setComparisonController(ComparisonControllers.StopWhenDifferent);
        Element e1 = this.doc.createElement("foo");
        Element e2 = this.doc.createElement("foo");
        Element e3 = this.doc.createElement("bar");
        Assert.assertEquals((Object)DOMDifferenceEngineTest.wrap(ComparisonResult.EQUAL), (Object)d.compareNodes((Node)e1, new XPathContext(), (Node)e2, new XPathContext()));
        Assert.assertEquals((Object)DOMDifferenceEngineTest.wrapAndStop(ComparisonResult.DIFFERENT), (Object)d.compareNodes((Node)e1, new XPathContext(), (Node)e3, new XPathContext()));
        Assert.assertEquals((long)1L, (long)ex.invoked);
        d = new DOMDifferenceEngine();
        ex = new DiffExpecter(ComparisonType.ELEMENT_NUM_ATTRIBUTES);
        e1.setAttribute("attr1", "value1");
        d.addDifferenceListener((ComparisonListener)ex);
        d.setComparisonController(ComparisonControllers.StopWhenDifferent);
        Assert.assertEquals((Object)DOMDifferenceEngineTest.wrapAndStop(ComparisonResult.DIFFERENT), (Object)d.compareNodes((Node)e1, new XPathContext(), (Node)e2, new XPathContext()));
        Assert.assertEquals((long)1L, (long)ex.invoked);
        d = new DOMDifferenceEngine();
        ex = new DiffExpecter(ComparisonType.ATTR_NAME_LOOKUP, "/@attr1", "/");
        e2.setAttributeNS("urn:xmlunit:test", "attr1", "value1");
        d.addDifferenceListener((ComparisonListener)ex);
        d.setComparisonController(ComparisonControllers.StopWhenDifferent);
        Assert.assertEquals((Object)DOMDifferenceEngineTest.wrapAndStop(ComparisonResult.DIFFERENT), (Object)d.compareNodes((Node)e1, new XPathContext(), (Node)e2, new XPathContext()));
        Assert.assertEquals((long)1L, (long)ex.invoked);
        d = new DOMDifferenceEngine();
        d.addDifferenceListener(new ComparisonListener(){

            public void comparisonPerformed(Comparison comparison, ComparisonResult outcome) {
                Assert.fail((String)("unexpected Comparison of type " + comparison.getType() + " with outcome " + outcome + " and values '" + comparison.getControlDetails().getValue() + "' and '" + comparison.getTestDetails().getValue() + "'"));
            }
        });
        e1.setAttributeNS("urn:xmlunit:test", "attr1", "value1");
        e2.setAttributeNS(null, "attr1", "value1");
        d.addDifferenceListener((ComparisonListener)ex);
        d.setComparisonController(ComparisonControllers.StopWhenDifferent);
        Assert.assertEquals((Object)DOMDifferenceEngineTest.wrap(ComparisonResult.EQUAL), (Object)d.compareNodes((Node)e1, new XPathContext(), (Node)e2, new XPathContext()));
    }

    @Test
    public void compareAttributes() {
        Attr a1 = this.doc.createAttribute("foo");
        Attr a2 = this.doc.createAttribute("foo");
        DOMDifferenceEngine d = new DOMDifferenceEngine();
        DiffExpecter ex = new DiffExpecter(ComparisonType.ATTR_VALUE_EXPLICITLY_SPECIFIED);
        ex = new DiffExpecter(ComparisonType.ATTR_VALUE);
        d.addDifferenceListener((ComparisonListener)ex);
        d.setComparisonController(ComparisonControllers.StopWhenDifferent);
        Attr a3 = this.doc.createAttribute("foo");
        a1.setValue("foo");
        a2.setValue("foo");
        a3.setValue("bar");
        Assert.assertEquals((Object)DOMDifferenceEngineTest.wrap(ComparisonResult.EQUAL), (Object)d.compareNodes((Node)a1, new XPathContext(), (Node)a2, new XPathContext()));
        Assert.assertEquals((Object)DOMDifferenceEngineTest.wrapAndStop(ComparisonResult.DIFFERENT), (Object)d.compareNodes((Node)a1, new XPathContext(), (Node)a3, new XPathContext()));
        Assert.assertEquals((long)1L, (long)ex.invoked);
    }

    @Test
    public void compareAttributesWithAttributeFilter() {
        DOMDifferenceEngine d = new DOMDifferenceEngine();
        d.setAttributeFilter((Predicate)new Predicate<Attr>(){

            public boolean test(Attr a) {
                return "x".equals(a.getName());
            }
        });
        DiffExpecter ex = new DiffExpecter(ComparisonType.ATTR_VALUE);
        d.addDifferenceListener((ComparisonListener)ex);
        d.setComparisonController(ComparisonControllers.StopWhenDifferent);
        Element e1 = this.doc.createElement("foo");
        e1.setAttribute("x", "1");
        e1.setAttribute("a", "xxx");
        Element e2 = this.doc.createElement("foo");
        e2.setAttribute("x", "1");
        e2.setAttribute("b", "xxx");
        e2.setAttribute("c", "xxx");
        Element e3 = this.doc.createElement("foo");
        e3.setAttribute("x", "3");
        Assert.assertEquals((Object)DOMDifferenceEngineTest.wrap(ComparisonResult.EQUAL), (Object)d.compareNodes((Node)e1, new XPathContext(), (Node)e2, new XPathContext()));
        Assert.assertEquals((Object)DOMDifferenceEngineTest.wrapAndStop(ComparisonResult.DIFFERENT), (Object)d.compareNodes((Node)e1, new XPathContext(), (Node)e3, new XPathContext()));
        Assert.assertEquals((long)1L, (long)ex.invoked);
    }

    @Test
    public void compareNodesWithNodeFilter() {
        DOMDifferenceEngine d = new DOMDifferenceEngine();
        d.setNodeFilter((Predicate)new Predicate<Node>(){

            public boolean test(Node n) {
                return "x".equals(n.getNodeName()) || "foo".equals(n.getNodeName());
            }
        });
        DiffExpecter ex = new DiffExpecter(ComparisonType.CHILD_NODELIST_LENGTH, "/", "/");
        d.addDifferenceListener((ComparisonListener)ex);
        d.setComparisonController(ComparisonControllers.StopWhenDifferent);
        Element e1 = this.doc.createElement("foo");
        e1.appendChild(this.doc.createElement("x"));
        e1.appendChild(this.doc.createElement("y"));
        Element e2 = this.doc.createElement("foo");
        e2.appendChild(this.doc.createElement("x"));
        e2.appendChild(this.doc.createElement("y"));
        e2.appendChild(this.doc.createElement("z"));
        Element e3 = this.doc.createElement("foo");
        e3.appendChild(this.doc.createElement("y"));
        Assert.assertEquals((Object)DOMDifferenceEngineTest.wrap(ComparisonResult.EQUAL), (Object)d.compareNodes((Node)e1, new XPathContext(), (Node)e2, new XPathContext()));
        Assert.assertEquals((Object)DOMDifferenceEngineTest.wrapAndStop(ComparisonResult.DIFFERENT), (Object)d.compareNodes((Node)e1, new XPathContext(), (Node)e3, new XPathContext()));
        Assert.assertEquals((long)1L, (long)ex.invoked);
    }

    @Test
    public void naiveRecursion() {
        Element e1 = this.doc.createElement("foo");
        Element e2 = this.doc.createElement("foo");
        Element c1 = this.doc.createElement("bar");
        e1.appendChild(c1);
        DOMDifferenceEngine d = new DOMDifferenceEngine();
        DiffExpecter ex = new DiffExpecter(ComparisonType.CHILD_LOOKUP, "/bar[1]", null).withParentXPath("/", "/");
        d.addDifferenceListener((ComparisonListener)ex);
        DifferenceEvaluator ev = new DifferenceEvaluator(){

            public ComparisonResult evaluate(Comparison comparison, ComparisonResult outcome) {
                if (comparison.getType() == ComparisonType.CHILD_NODELIST_LENGTH) {
                    return ComparisonResult.EQUAL;
                }
                return outcome;
            }
        };
        d.setDifferenceEvaluator(ev);
        d.setComparisonController(ComparisonControllers.StopWhenDifferent);
        Assert.assertEquals((Object)DOMDifferenceEngineTest.wrapAndStop(ComparisonResult.DIFFERENT), (Object)d.compareNodes((Node)e1, new XPathContext(), (Node)e2, new XPathContext()));
        Assert.assertEquals((long)1L, (long)ex.invoked);
        d = new DOMDifferenceEngine();
        ex = new DiffExpecter(ComparisonType.CHILD_LOOKUP, null, "/bar[1]").withParentXPath("/", "/");
        d.addDifferenceListener((ComparisonListener)ex);
        d.setDifferenceEvaluator(ev);
        d.setComparisonController(ComparisonControllers.StopWhenDifferent);
        Assert.assertEquals((Object)DOMDifferenceEngineTest.wrapAndStop(ComparisonResult.DIFFERENT), (Object)d.compareNodes((Node)e2, new XPathContext(), (Node)e1, new XPathContext()));
        Assert.assertEquals((long)1L, (long)ex.invoked);
        Element c2 = this.doc.createElement("bar");
        e2.appendChild(c2);
        d = new DOMDifferenceEngine();
        ex = new DiffExpecter(ComparisonType.CHILD_LOOKUP);
        d.addDifferenceListener((ComparisonListener)ex);
        d.setDifferenceEvaluator(ev);
        Assert.assertEquals((Object)DOMDifferenceEngineTest.wrap(ComparisonResult.EQUAL), (Object)d.compareNodes((Node)e1, new XPathContext(), (Node)e2, new XPathContext()));
        Assert.assertEquals((Object)DOMDifferenceEngineTest.wrap(ComparisonResult.EQUAL), (Object)d.compareNodes((Node)e2, new XPathContext(), (Node)e1, new XPathContext()));
        Assert.assertEquals((long)0L, (long)ex.invoked);
    }

    @Test
    public void textAndCDataMatchRecursively() {
        Element e1 = this.doc.createElement("foo");
        Element e2 = this.doc.createElement("foo");
        Text fooText = this.doc.createTextNode("foo");
        e1.appendChild(fooText);
        CDATASection fooCDATASection = this.doc.createCDATASection("foo");
        e2.appendChild(fooCDATASection);
        DOMDifferenceEngine d = new DOMDifferenceEngine();
        Assert.assertEquals((Object)DOMDifferenceEngineTest.wrap(ComparisonResult.EQUAL), (Object)d.compareNodes((Node)e1, new XPathContext(), (Node)e2, new XPathContext()));
        Assert.assertEquals((Object)DOMDifferenceEngineTest.wrap(ComparisonResult.EQUAL), (Object)d.compareNodes((Node)e2, new XPathContext(), (Node)e1, new XPathContext()));
    }

    @Test
    public void recursionUsesElementSelector() {
        Element e1 = this.doc.createElement("foo");
        Element e2 = this.doc.createElement("foo");
        Element e3 = this.doc.createElement("bar");
        e1.appendChild(e3);
        Element e4 = this.doc.createElement("baz");
        e2.appendChild(e4);
        DOMDifferenceEngine d = new DOMDifferenceEngine();
        DiffExpecter ex = new DiffExpecter(ComparisonType.ELEMENT_TAG_NAME, "/bar[1]", "/baz[1]");
        d.addDifferenceListener((ComparisonListener)ex);
        d.setComparisonController(ComparisonControllers.StopWhenDifferent);
        Assert.assertEquals((Object)DOMDifferenceEngineTest.wrapAndStop(ComparisonResult.DIFFERENT), (Object)d.compareNodes((Node)e1, new XPathContext(), (Node)e2, new XPathContext()));
        Assert.assertEquals((long)1L, (long)ex.invoked);
        d = new DOMDifferenceEngine();
        d.setNodeMatcher((NodeMatcher)new DefaultNodeMatcher(new ElementSelector[]{ElementSelectors.byName}));
        ex = new DiffExpecter(ComparisonType.CHILD_LOOKUP, "/bar[1]", null).withParentXPath("/", "/");
        d.addDifferenceListener((ComparisonListener)ex);
        d.setComparisonController(ComparisonControllers.StopWhenDifferent);
        Assert.assertEquals((Object)DOMDifferenceEngineTest.wrapAndStop(ComparisonResult.DIFFERENT), (Object)d.compareNodes((Node)e1, new XPathContext(), (Node)e2, new XPathContext()));
        Assert.assertEquals((long)1L, (long)ex.invoked);
    }

    @Test
    public void schemaLocationDifferences() {
        Element e1 = this.doc.createElement("foo");
        Element e2 = this.doc.createElement("foo");
        e1.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "schemaLocation", "somewhere");
        e2.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "schemaLocation", "somewhere else");
        DOMDifferenceEngine d = new DOMDifferenceEngine();
        DiffExpecter ex = new DiffExpecter(ComparisonType.SCHEMA_LOCATION);
        d.addDifferenceListener((ComparisonListener)ex);
        d.setDifferenceEvaluator(new DifferenceEvaluator(){

            public ComparisonResult evaluate(Comparison comparison, ComparisonResult outcome) {
                if (comparison.getType() == ComparisonType.SCHEMA_LOCATION) {
                    Assert.assertEquals((Object)ComparisonResult.DIFFERENT, (Object)outcome);
                    return ComparisonResult.DIFFERENT;
                }
                Assert.assertEquals((Object)ComparisonResult.EQUAL, (Object)outcome);
                return ComparisonResult.EQUAL;
            }
        });
        d.setComparisonController(ComparisonControllers.StopWhenDifferent);
        Assert.assertEquals((Object)DOMDifferenceEngineTest.wrapAndStop(ComparisonResult.DIFFERENT), (Object)d.compareNodes((Node)e1, new XPathContext(), (Node)e2, new XPathContext()));
        Assert.assertEquals((long)1L, (long)ex.invoked);
        e1 = this.doc.createElement("foo");
        e2 = this.doc.createElement("foo");
        e1.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "noNamespaceSchemaLocation", "somewhere");
        e2.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "noNamespaceSchemaLocation", "somewhere else");
        d = new DOMDifferenceEngine();
        ex = new DiffExpecter(ComparisonType.NO_NAMESPACE_SCHEMA_LOCATION);
        d.addDifferenceListener((ComparisonListener)ex);
        d.setDifferenceEvaluator(new DifferenceEvaluator(){

            public ComparisonResult evaluate(Comparison comparison, ComparisonResult outcome) {
                if (comparison.getType() == ComparisonType.NO_NAMESPACE_SCHEMA_LOCATION) {
                    Assert.assertEquals((Object)ComparisonResult.DIFFERENT, (Object)outcome);
                    return ComparisonResult.DIFFERENT;
                }
                Assert.assertEquals((Object)ComparisonResult.EQUAL, (Object)outcome);
                return ComparisonResult.EQUAL;
            }
        });
        d.setComparisonController(ComparisonControllers.StopWhenDifferent);
        Assert.assertEquals((Object)DOMDifferenceEngineTest.wrapAndStop(ComparisonResult.DIFFERENT), (Object)d.compareNodes((Node)e1, new XPathContext(), (Node)e2, new XPathContext()));
        Assert.assertEquals((long)1L, (long)ex.invoked);
    }

    @Test
    public void compareElementsNS() {
        DOMDifferenceEngine d = new DOMDifferenceEngine();
        DiffExpecter ex = new DiffExpecter(ComparisonType.ELEMENT_TAG_NAME);
        d.addDifferenceListener((ComparisonListener)ex);
        DifferenceEvaluator ev = new DifferenceEvaluator(){

            public ComparisonResult evaluate(Comparison comparison, ComparisonResult outcome) {
                if (comparison.getType() == ComparisonType.NAMESPACE_PREFIX) {
                    return ComparisonResult.EQUAL;
                }
                return outcome;
            }
        };
        d.setComparisonController(ComparisonControllers.StopWhenDifferent);
        d.setDifferenceEvaluator(ev);
        Element e1 = this.doc.createElementNS("urn:xmlunit:test", "foo");
        e1.setPrefix("p1");
        Element e2 = this.doc.createElementNS("urn:xmlunit:test", "foo");
        e2.setPrefix("p2");
        Assert.assertEquals((Object)DOMDifferenceEngineTest.wrap(ComparisonResult.EQUAL), (Object)d.compareNodes((Node)e1, new XPathContext(), (Node)e2, new XPathContext()));
        Assert.assertEquals((long)0L, (long)ex.invoked);
    }

    @Test
    public void childNodeListSequence() {
        Element e1 = this.doc.createElement("foo");
        Element e3 = this.doc.createElement("bar");
        Element e4 = this.doc.createElement("baz");
        e1.appendChild(e3);
        e1.appendChild(e4);
        Element e2 = this.doc.createElement("foo");
        Element e5 = this.doc.createElement("bar");
        Element e6 = this.doc.createElement("baz");
        e2.appendChild(e6);
        e2.appendChild(e5);
        DOMDifferenceEngine d = new DOMDifferenceEngine();
        DiffExpecter ex = new DiffExpecter(ComparisonType.CHILD_NODELIST_SEQUENCE, "/bar[1]", "/bar[1]");
        d.addDifferenceListener((ComparisonListener)ex);
        DifferenceEvaluator ev = new DifferenceEvaluator(){

            public ComparisonResult evaluate(Comparison comparison, ComparisonResult outcome) {
                if (outcome != ComparisonResult.EQUAL && comparison.getType() == ComparisonType.CHILD_NODELIST_SEQUENCE) {
                    return ComparisonResult.DIFFERENT;
                }
                return outcome;
            }
        };
        d.setComparisonController(ComparisonControllers.StopWhenDifferent);
        d.setDifferenceEvaluator(ev);
        d.setNodeMatcher((NodeMatcher)new DefaultNodeMatcher(new ElementSelector[]{ElementSelectors.byName}));
        Assert.assertEquals((Object)DOMDifferenceEngineTest.wrapAndStop(ComparisonResult.DIFFERENT), (Object)d.compareNodes((Node)e1, new XPathContext(), (Node)e2, new XPathContext()));
        Assert.assertEquals((long)1L, (long)ex.invoked);
    }

    @Test
    public void xsiTypesWithDifferentPrefixes() {
        Document d1 = this.documentForString("<foo xsi:type='p1:Foo' xmlns:p1='urn:xmlunit:test' xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance'/>");
        Document d2 = this.documentForString("<foo xsi:type='p2:Foo' xmlns:p2='urn:xmlunit:test' xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance'/>");
        DOMDifferenceEngine d = new DOMDifferenceEngine();
        DiffExpecter ex = new DiffExpecter(ComparisonType.ATTR_VALUE);
        d.addDifferenceListener((ComparisonListener)ex);
        d.setComparisonController(ComparisonControllers.StopWhenDifferent);
        Assert.assertEquals((Object)DOMDifferenceEngineTest.wrap(ComparisonResult.EQUAL), (Object)d.compareNodes((Node)d1, new XPathContext(), (Node)d2, new XPathContext()));
    }

    @Test
    public void xsiTypesWithDefaultNamespace() {
        Document d1 = this.documentForString("<a:foo xsi:type='Foo' xmlns='urn:xmlunit:test' xmlns:a='urn:xmlunit:test2' xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance'/>");
        Document d2 = this.documentForString("<a:foo xsi:type='p2:Foo' xmlns:p2='urn:xmlunit:test' xmlns:a='urn:xmlunit:test2' xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance'/>");
        DOMDifferenceEngine d = new DOMDifferenceEngine();
        DiffExpecter ex = new DiffExpecter(ComparisonType.ATTR_VALUE);
        d.addDifferenceListener((ComparisonListener)ex);
        d.setComparisonController(ComparisonControllers.StopWhenDifferent);
        Assert.assertEquals((Object)DOMDifferenceEngineTest.wrap(ComparisonResult.EQUAL), (Object)d.compareNodes((Node)d1, new XPathContext(), (Node)d2, new XPathContext()));
    }

    @Test
    public void xsiTypesWithDifferentLocalNames() {
        Document d1 = this.documentForString("<foo xsi:type='p1:Bar' xmlns:p1='urn:xmlunit:test' xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance'/>");
        Document d2 = this.documentForString("<foo xsi:type='p1:Foo' xmlns:p1='urn:xmlunit:test' xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance'/>");
        DOMDifferenceEngine d = new DOMDifferenceEngine();
        DiffExpecter ex = new DiffExpecter(ComparisonType.ATTR_VALUE);
        d.addDifferenceListener((ComparisonListener)ex);
        d.setComparisonController(ComparisonControllers.StopWhenDifferent);
        Assert.assertEquals((Object)DOMDifferenceEngineTest.wrapAndStop(ComparisonResult.DIFFERENT), (Object)d.compareNodes((Node)d1, new XPathContext(), (Node)d2, new XPathContext()));
    }

    @Test
    public void xsiTypesWithDifferentNamespaceURIs() {
        Document d1 = this.documentForString("<foo xsi:type='p1:Foo' xmlns:p1='urn:xmlunit:test' xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance'/>");
        Document d2 = this.documentForString("<foo xsi:type='p1:Foo' xmlns:p1='urn:xmlunit:test2' xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance'/>");
        DOMDifferenceEngine d = new DOMDifferenceEngine();
        DiffExpecter ex = new DiffExpecter(ComparisonType.ATTR_VALUE);
        d.addDifferenceListener((ComparisonListener)ex);
        d.setComparisonController(ComparisonControllers.StopWhenDifferent);
        Assert.assertEquals((Object)DOMDifferenceEngineTest.wrapAndStop(ComparisonResult.DIFFERENT), (Object)d.compareNodes((Node)d1, new XPathContext(), (Node)d2, new XPathContext()));
    }

    @Test
    public void xsiTypesWithNamespaceDeclarationOnDifferentLevels() {
        Document d1 = this.documentForString("<bar xmlns:p1='urn:xmlunit:test'><foo xsi:type='p1:Foo' xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance'/></bar>");
        Document d2 = this.documentForString("<bar><foo xsi:type='p1:Foo' xmlns:p1='urn:xmlunit:test' xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance'/></bar>");
        DOMDifferenceEngine d = new DOMDifferenceEngine();
        DiffExpecter ex = new DiffExpecter(ComparisonType.ATTR_VALUE);
        d.addDifferenceListener((ComparisonListener)ex);
        d.setComparisonController(ComparisonControllers.StopWhenDifferent);
        Assert.assertEquals((Object)DOMDifferenceEngineTest.wrap(ComparisonResult.EQUAL), (Object)d.compareNodes((Node)d1, new XPathContext(), (Node)d2, new XPathContext()));
    }

    @Test
    public void xsiNil() {
        Document d1 = this.documentForString("<foo xsi:nil='true' xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance'/>");
        Document d2 = this.documentForString("<foo xsi:nil='false' xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance'/>");
        DOMDifferenceEngine d = new DOMDifferenceEngine();
        DiffExpecter ex = new DiffExpecter(ComparisonType.ATTR_VALUE);
        d.addDifferenceListener((ComparisonListener)ex);
        d.setComparisonController(ComparisonControllers.StopWhenDifferent);
        Assert.assertEquals((Object)DOMDifferenceEngineTest.wrapAndStop(ComparisonResult.DIFFERENT), (Object)d.compareNodes((Node)d1, new XPathContext(), (Node)d2, new XPathContext()));
    }

    @Test
    public void shouldDetectCommentInPrelude() {
        DOMDifferenceEngine d = new DOMDifferenceEngine();
        Document d1 = Convert.toDocument((Source)Input.fromFile((String)"../test-resources/BookXsdGenerated.xml").build());
        Document d2 = Convert.toDocument((Source)Input.fromFile((String)"../test-resources/BookXsdGeneratedWithComment.xml").build());
        DiffExpecter ex = new DiffExpecter(ComparisonType.CHILD_NODELIST_LENGTH, "/", "/");
        d.addDifferenceListener((ComparisonListener)ex);
        d.setComparisonController(ComparisonControllers.StopWhenDifferent);
        Assert.assertEquals((Object)DOMDifferenceEngineTest.wrapAndStop(ComparisonResult.DIFFERENT), (Object)d.compareNodes((Node)d1, new XPathContext(), (Node)d2, new XPathContext()));
    }

    @Test
    public void shouldDetectMissingXsiType() {
        DOMDifferenceEngine d = new DOMDifferenceEngine();
        Document d1 = Convert.toDocument((Source)Input.fromString((String)"<doc xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><effectiveTime xsi:type=\"IVL_TS\"></effectiveTime></doc>").build());
        Document d2 = Convert.toDocument((Source)Input.fromString((String)"<doc xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><effectiveTime></effectiveTime></doc>").build());
        DiffExpecter ex = new DiffExpecter(ComparisonType.ATTR_NAME_LOOKUP, "/doc[1]/effectiveTime[1]/@type", "/doc[1]/effectiveTime[1]");
        d.addDifferenceListener((ComparisonListener)ex);
        d.setComparisonController(ComparisonControllers.StopWhenDifferent);
        Assert.assertEquals((Object)DOMDifferenceEngineTest.wrapAndStop(ComparisonResult.DIFFERENT), (Object)d.compareNodes((Node)d1, new XPathContext(), (Node)d2, new XPathContext()));
    }

    private Document documentForString(String s) {
        return Convert.toDocument((Source)Input.fromString((String)s).build());
    }

    private static class DocType
    extends NullNode
    implements DocumentType {
        private final String name;
        private final String publicId;
        private final String systemId;

        private DocType(String name, String publicId, String systemId) {
            this.name = name;
            this.publicId = publicId;
            this.systemId = systemId;
        }

        @Override
        public short getNodeType() {
            return 10;
        }

        @Override
        public NamedNodeMap getEntities() {
            return null;
        }

        @Override
        public String getInternalSubset() {
            return null;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public NamedNodeMap getNotations() {
            return null;
        }

        @Override
        public String getPublicId() {
            return this.publicId;
        }

        @Override
        public String getSystemId() {
            return this.systemId;
        }
    }

    private static class DiffExpecter
    implements ComparisonListener {
        private int invoked = 0;
        private final int expectedInvocations;
        private final ComparisonType type;
        private final boolean withXPath;
        private final String controlXPath;
        private final String testXPath;
        private boolean withParentXPath;
        private String controlParentXPath;
        private String testParentXPath;

        private DiffExpecter(ComparisonType type) {
            this(type, 1);
        }

        private DiffExpecter(ComparisonType type, int expected) {
            this(type, expected, false, null, null);
        }

        private DiffExpecter(ComparisonType type, String controlXPath, String testXPath) {
            this(type, 1, true, controlXPath, testXPath);
        }

        private DiffExpecter(ComparisonType type, int expected, boolean withXPath, String controlXPath, String testXPath) {
            this.type = type;
            this.expectedInvocations = expected;
            this.withXPath = withXPath;
            this.controlXPath = controlXPath;
            this.testXPath = testXPath;
            this.withParentXPath = withXPath;
            this.controlParentXPath = this.getParentXPath(controlXPath);
            this.testParentXPath = this.getParentXPath(testXPath);
        }

        public DiffExpecter withParentXPath(String controlParentXPath, String testParentXPath) {
            this.withParentXPath = true;
            this.controlParentXPath = controlParentXPath;
            this.testParentXPath = testParentXPath;
            return this;
        }

        public void comparisonPerformed(Comparison comparison, ComparisonResult outcome) {
            Assert.assertTrue((String)(this.invoked + " should be less than " + this.expectedInvocations), (this.invoked < this.expectedInvocations ? 1 : 0) != 0);
            ++this.invoked;
            Assert.assertEquals((Object)this.type, (Object)comparison.getType());
            Assert.assertEquals((Object)ComparisonResult.DIFFERENT, (Object)outcome);
            if (this.withXPath) {
                Assert.assertEquals((String)"Control XPath", (Object)this.controlXPath, (Object)comparison.getControlDetails().getXPath());
                Assert.assertEquals((String)"Test XPath", (Object)this.testXPath, (Object)comparison.getTestDetails().getXPath());
            }
            if (this.withParentXPath) {
                Assert.assertEquals((String)"Control Parent XPath", (Object)this.controlParentXPath, (Object)comparison.getControlDetails().getParentXPath());
                Assert.assertEquals((String)"Test Parent XPath", (Object)this.testParentXPath, (Object)comparison.getTestDetails().getParentXPath());
            }
        }

        private String getParentXPath(String xPath) {
            if (xPath == null) {
                return null;
            }
            if (xPath.equals("/") || xPath.equals("")) {
                return "";
            }
            int i = xPath.lastIndexOf(47);
            if (i == xPath.indexOf(47)) {
                return "/";
            }
            return i >= 0 ? xPath.substring(0, i) : xPath;
        }
    }
}

