/*
 * Decompiled with CFR 0.152.
 */
package org.xmlunit.diff;

import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Document;
import org.xmlunit.builder.DiffBuilder;
import org.xmlunit.builder.Input;
import org.xmlunit.diff.Comparison;
import org.xmlunit.diff.ComparisonType;
import org.xmlunit.diff.DefaultComparisonFormatter;
import org.xmlunit.diff.DefaultNodeMatcher;
import org.xmlunit.diff.Diff;
import org.xmlunit.diff.Difference;
import org.xmlunit.diff.ElementSelector;
import org.xmlunit.diff.ElementSelectors;
import org.xmlunit.diff.NodeMatcher;
import org.xmlunit.util.Convert;

public class DefaultComparisonFormatterTest {
    private DefaultComparisonFormatter compFormatter = new DefaultComparisonFormatter();

    @Test
    public void testComparisonType_XML_VERSION() {
        Diff diff = DiffBuilder.compare((Object)"<?xml version=\"1.0\"?><a/>").withTest((Object)"<?xml version=\"1.1\"?><a/>").build();
        this.assertPreRequirements(diff, ComparisonType.XML_VERSION);
        Comparison firstDiff = ((Difference)diff.getDifferences().iterator().next()).getComparison();
        String description = this.compFormatter.getDescription(firstDiff);
        String controlDetails = this.getDetails(firstDiff.getControlDetails(), firstDiff.getType());
        String testDetails = this.getDetails(firstDiff.getTestDetails(), firstDiff.getType());
        Assert.assertEquals((Object)"Expected xml version '1.0' but was '1.1' - comparing <a...> at / to <?xml version=\"1.1\"?><a...> at /", (Object)description);
        DefaultComparisonFormatterTest.assertEquals("<a/>", controlDetails);
        DefaultComparisonFormatterTest.assertEquals("<?xml version=\"1.1\"?>\n<a/>", testDetails);
    }

    @Test
    public void testComparisonType_XML_STANDALONE() {
        Diff diff = DiffBuilder.compare((Object)"<?xml version=\"1.0\" standalone=\"yes\"?><a b=\"x\"><b/></a>").withTest((Object)"<?xml version=\"1.0\" standalone=\"no\"?><a b=\"x\"><b/></a>").build();
        this.assertPreRequirements(diff, ComparisonType.XML_STANDALONE);
        Comparison firstDiff = ((Difference)diff.getDifferences().iterator().next()).getComparison();
        String description = this.compFormatter.getDescription(firstDiff);
        String controlDetails = this.getDetails(firstDiff.getControlDetails(), firstDiff.getType());
        String testDetails = this.getDetails(firstDiff.getTestDetails(), firstDiff.getType());
        Assert.assertEquals((Object)"Expected xml standalone 'true' but was 'false' - comparing <?xml version=\"1.0\" standalone=\"yes\"?><a...> at / to <a...> at /", (Object)description);
        DefaultComparisonFormatterTest.assertEquals("<?xml version=\"1.0\" standalone=\"yes\"?>\n<a b=\"x\">\n  ...", controlDetails);
        DefaultComparisonFormatterTest.assertEquals("<a b=\"x\">\n  ...", testDetails);
    }

    @Test
    public void testComparisonType_XML_ENCODING() {
        Diff diff = DiffBuilder.compare((Object)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><a/>").withTest((Object)"<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?><a/>").build();
        this.assertPreRequirements(diff, ComparisonType.XML_ENCODING);
        Comparison firstDiff = ((Difference)diff.getDifferences().iterator().next()).getComparison();
        String description = this.compFormatter.getDescription(firstDiff);
        String controlDetails = this.getDetails(firstDiff.getControlDetails(), firstDiff.getType());
        String testDetails = this.getDetails(firstDiff.getTestDetails(), firstDiff.getType());
        Assert.assertEquals((Object)"Expected xml encoding 'UTF-8' but was 'ISO-8859-1' - comparing <?xml version=\"1.0\" encoding=\"UTF-8\"?><a...> at / to <?xml version=\"1.0\" encoding=\"ISO-8859-1\"?><a...> at /", (Object)description);
        DefaultComparisonFormatterTest.assertEquals("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<a/>", controlDetails);
        DefaultComparisonFormatterTest.assertEquals("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n<a/>", testDetails);
    }

    @Test
    public void testComparisonType_HAS_DOCTYPE_DECLARATION() throws Exception {
        DocumentBuilderFactory dbf = this.getDocumentBuilderFactoryWithoutValidation();
        Document controlDoc = Convert.toDocument((Source)Input.fromString((String)"<!DOCTYPE Book><a/>").build(), (DocumentBuilderFactory)dbf);
        Diff diff = DiffBuilder.compare((Object)controlDoc).withTest((Object)"<a/>").build();
        this.assertPreRequirements(diff, ComparisonType.HAS_DOCTYPE_DECLARATION);
        Comparison firstDiff = ((Difference)diff.getDifferences().iterator().next()).getComparison();
        String description = this.compFormatter.getDescription(firstDiff);
        String controlDetails = this.getDetails(firstDiff.getControlDetails(), firstDiff.getType());
        String testDetails = this.getDetails(firstDiff.getTestDetails(), firstDiff.getType());
        Assert.assertEquals((Object)"Expected has doctype declaration 'true' but was 'false' - comparing <!DOCTYPE Book><a...> at / to <a...> at /", (Object)description);
        DefaultComparisonFormatterTest.assertEquals("<!DOCTYPE Book>\n<a/>", controlDetails);
        DefaultComparisonFormatterTest.assertEquals("<a/>", testDetails);
    }

    @Test
    public void testComparisonType_DOCTYPE_NAME() throws Exception {
        DocumentBuilderFactory dbf = this.getDocumentBuilderFactoryWithoutValidation();
        Document controlDoc = Convert.toDocument((Source)Input.fromString((String)"<!DOCTYPE Book ><a/>").build(), (DocumentBuilderFactory)dbf);
        Document testDoc = Convert.toDocument((Source)Input.fromString((String)"<!DOCTYPE XY ><a/>").build(), (DocumentBuilderFactory)dbf);
        Diff diff = DiffBuilder.compare((Object)controlDoc).withTest((Object)testDoc).build();
        this.assertPreRequirements(diff, ComparisonType.DOCTYPE_NAME);
        Comparison firstDiff = ((Difference)diff.getDifferences().iterator().next()).getComparison();
        String description = this.compFormatter.getDescription(firstDiff);
        String controlDetails = this.getDetails(firstDiff.getControlDetails(), firstDiff.getType());
        String testDetails = this.getDetails(firstDiff.getTestDetails(), firstDiff.getType());
        Assert.assertEquals((Object)"Expected doctype name 'Book' but was 'XY' - comparing <!DOCTYPE Book><a...> at / to <!DOCTYPE XY><a...> at /", (Object)description);
        DefaultComparisonFormatterTest.assertEquals("<!DOCTYPE Book>\n<a/>", controlDetails);
        DefaultComparisonFormatterTest.assertEquals("<!DOCTYPE XY>\n<a/>", testDetails);
    }

    @Test
    public void testComparisonType_DOCTYPE_PUBLIC_ID() throws Exception {
        DocumentBuilderFactory dbf = this.getDocumentBuilderFactoryWithoutValidation();
        Document controlDoc = Convert.toDocument((Source)Input.fromString((String)"<!DOCTYPE Book PUBLIC \"XMLUNIT/TEST/PUB\" \"http://example.org/nonsense\"><a/>").build(), (DocumentBuilderFactory)dbf);
        Document testDoc = Convert.toDocument((Source)Input.fromString((String)"<!DOCTYPE Book SYSTEM \"http://example.org/nonsense\"><a/>").build(), (DocumentBuilderFactory)dbf);
        Diff diff = DiffBuilder.compare((Object)controlDoc).withTest((Object)testDoc).build();
        this.assertPreRequirements(diff, ComparisonType.DOCTYPE_PUBLIC_ID);
        Comparison firstDiff = ((Difference)diff.getDifferences().iterator().next()).getComparison();
        String description = this.compFormatter.getDescription(firstDiff);
        String controlDetails = this.getDetails(firstDiff.getControlDetails(), firstDiff.getType());
        String testDetails = this.getDetails(firstDiff.getTestDetails(), firstDiff.getType());
        Assert.assertEquals((Object)"Expected doctype public id 'XMLUNIT/TEST/PUB' but was 'null' - comparing <!DOCTYPE Book PUBLIC \"XMLUNIT/TEST/PUB\" \"http://example.org/nonsense\"><a...> at / to <!DOCTYPE Book SYSTEM \"http://example.org/nonsense\"><a...> at /", (Object)description);
        DefaultComparisonFormatterTest.assertEquals("<!DOCTYPE Book PUBLIC \"XMLUNIT/TEST/PUB\" \"http://example.org/nonsense\">\n<a/>", controlDetails);
        DefaultComparisonFormatterTest.assertEquals("<!DOCTYPE Book SYSTEM \"http://example.org/nonsense\">\n<a/>", testDetails);
    }

    @Test
    public void testComparisonType_DOCTYPE_SYSTEM_ID() throws Exception {
        DocumentBuilderFactory dbf = this.getDocumentBuilderFactoryWithoutValidation();
        Document controlDoc = Convert.toDocument((Source)Input.fromString((String)"<!DOCTYPE Book PUBLIC \"XMLUNIT/TEST/PUB\" \"http://example.org/nonsense\"><a/>").build(), (DocumentBuilderFactory)dbf);
        Document testDoc = Convert.toDocument((Source)Input.fromString((String)"<!DOCTYPE Book PUBLIC \"XMLUNIT/TEST/PUB\" \"http://example.org/404\"><a/>").build(), (DocumentBuilderFactory)dbf);
        Diff diff = DiffBuilder.compare((Object)controlDoc).withTest((Object)testDoc).build();
        this.assertPreRequirements(diff, ComparisonType.DOCTYPE_SYSTEM_ID);
        Comparison firstDiff = ((Difference)diff.getDifferences().iterator().next()).getComparison();
        String description = this.compFormatter.getDescription(firstDiff);
        String controlDetails = this.getDetails(firstDiff.getControlDetails(), firstDiff.getType());
        String testDetails = this.getDetails(firstDiff.getTestDetails(), firstDiff.getType());
        Assert.assertEquals((Object)"Expected doctype system id 'http://example.org/nonsense' but was 'http://example.org/404' - comparing <!DOCTYPE Book PUBLIC \"XMLUNIT/TEST/PUB\" \"http://example.org/nonsense\"><a...> to <!DOCTYPE Book PUBLIC \"XMLUNIT/TEST/PUB\" \"http://example.org/404\"><a...>", (Object)description);
        DefaultComparisonFormatterTest.assertEquals("<!DOCTYPE Book PUBLIC \"XMLUNIT/TEST/PUB\" \"http://example.org/nonsense\">\n<a/>", controlDetails);
        DefaultComparisonFormatterTest.assertEquals("<!DOCTYPE Book PUBLIC \"XMLUNIT/TEST/PUB\" \"http://example.org/404\">\n<a/>", testDetails);
    }

    @Test
    public void testComparisonType_SCHEMA_LOCATION() {
        Diff diff = DiffBuilder.compare((Object)"<a xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.publishing.org Book.xsd\"/>").withTest((Object)"<a />").build();
        this.assertPreRequirements(diff, ComparisonType.SCHEMA_LOCATION);
        Comparison firstDiff = ((Difference)diff.getDifferences().iterator().next()).getComparison();
        String description = this.compFormatter.getDescription(firstDiff);
        String controlDetails = this.getDetails(firstDiff.getControlDetails(), firstDiff.getType());
        String testDetails = this.getDetails(firstDiff.getTestDetails(), firstDiff.getType());
        Assert.assertEquals((Object)"Expected schema location 'http://www.publishing.org Book.xsd' but was 'null' - comparing <a...> at /a[1] to <a...> at /a[1]", (Object)description);
        DefaultComparisonFormatterTest.assertEquals("<a xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.publishing.org Book.xsd\"/>", controlDetails);
        DefaultComparisonFormatterTest.assertEquals("<a/>", testDetails);
    }

    @Test
    public void testComparisonType_NO_NAMESPACE_SCHEMA_LOCATION() {
        Diff diff = DiffBuilder.compare((Object)"<a xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:noNamespaceSchemaLocation=\"Book.xsd\"/>").withTest((Object)"<a xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:noNamespaceSchemaLocation=\"Telephone.xsd\"/>").build();
        this.assertPreRequirements(diff, ComparisonType.NO_NAMESPACE_SCHEMA_LOCATION);
        Comparison firstDiff = ((Difference)diff.getDifferences().iterator().next()).getComparison();
        String description = this.compFormatter.getDescription(firstDiff);
        String controlDetails = this.getDetails(firstDiff.getControlDetails(), firstDiff.getType());
        String testDetails = this.getDetails(firstDiff.getTestDetails(), firstDiff.getType());
        Assert.assertEquals((Object)"Expected no namespace schema location 'Book.xsd' but was 'Telephone.xsd' - comparing <a...> at /a[1] to <a...> at /a[1]", (Object)description);
        DefaultComparisonFormatterTest.assertEquals("<a xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:noNamespaceSchemaLocation=\"Book.xsd\"/>", controlDetails);
        DefaultComparisonFormatterTest.assertEquals("<a xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:noNamespaceSchemaLocation=\"Telephone.xsd\"/>", testDetails);
    }

    @Test
    public void testComparisonType_NODE_TYPE_similar() {
        Diff diff = DiffBuilder.compare((Object)"<a>Text</a>").withTest((Object)"<a><![CDATA[Text]]></a>").build();
        this.assertPreRequirements(diff, ComparisonType.NODE_TYPE);
        Comparison firstDiff = ((Difference)diff.getDifferences().iterator().next()).getComparison();
        String description = this.compFormatter.getDescription(firstDiff);
        String controlDetails = this.getDetails(firstDiff.getControlDetails(), firstDiff.getType());
        String testDetails = this.getDetails(firstDiff.getTestDetails(), firstDiff.getType());
        Assert.assertEquals((Object)"Expected node type 'Text' but was 'CDATA Section' - comparing <a ...>Text</a> at /a[1]/text()[1] to <a ...><![CDATA[Text]]></a> at /a[1]/text()[1]", (Object)description);
        DefaultComparisonFormatterTest.assertEquals("<a>Text</a>", controlDetails);
        DefaultComparisonFormatterTest.assertEquals("<a><![CDATA[Text]]></a>", testDetails);
    }

    @Test
    public void testComparisonType_NAMESPACE_PREFIX() {
        Diff diff = DiffBuilder.compare((Object)"<ns1:a xmlns:ns1=\"test\">Text</ns1:a>").withTest((Object)"<test:a xmlns:test=\"test\">Text</test:a>").build();
        this.assertPreRequirements(diff, ComparisonType.NAMESPACE_PREFIX);
        Comparison firstDiff = ((Difference)diff.getDifferences().iterator().next()).getComparison();
        String description = this.compFormatter.getDescription(firstDiff);
        String controlDetails = this.getDetails(firstDiff.getControlDetails(), firstDiff.getType());
        String testDetails = this.getDetails(firstDiff.getTestDetails(), firstDiff.getType());
        Assert.assertEquals((Object)"Expected namespace prefix 'ns1' but was 'test' - comparing <ns1:a...> at /a[1] to <test:a...> at /a[1]", (Object)description);
        DefaultComparisonFormatterTest.assertEquals("<ns1:a xmlns:ns1=\"test\">Text</ns1:a>", controlDetails);
        DefaultComparisonFormatterTest.assertEquals("<test:a xmlns:test=\"test\">Text</test:a>", testDetails);
    }

    @Test
    public void testComparisonType_NAMESPACE_URI() {
        Diff diff = DiffBuilder.compare((Object)"<test:a xmlns:test=\"test.org\">Text</test:a>").withTest((Object)"<test:a xmlns:test=\"test.net\">Text</test:a>").build();
        this.assertPreRequirements(diff, ComparisonType.NAMESPACE_URI);
        Comparison firstDiff = ((Difference)diff.getDifferences().iterator().next()).getComparison();
        String description = this.compFormatter.getDescription(firstDiff);
        String controlDetails = this.getDetails(firstDiff.getControlDetails(), firstDiff.getType());
        String testDetails = this.getDetails(firstDiff.getTestDetails(), firstDiff.getType());
        Assert.assertEquals((Object)"Expected namespace uri 'test.org' but was 'test.net' - comparing <test:a...> at /a[1] to <test:a...> at /a[1]", (Object)description);
        DefaultComparisonFormatterTest.assertEquals("<test:a xmlns:test=\"test.org\">Text</test:a>", controlDetails);
        DefaultComparisonFormatterTest.assertEquals("<test:a xmlns:test=\"test.net\">Text</test:a>", testDetails);
    }

    @Test
    public void testComparisonType_TEXT_VALUE() {
        Diff diff = DiffBuilder.compare((Object)"<a>Text one</a>").withTest((Object)"<a>Text two</a>").build();
        this.assertPreRequirements(diff, ComparisonType.TEXT_VALUE);
        Comparison firstDiff = ((Difference)diff.getDifferences().iterator().next()).getComparison();
        String description = this.compFormatter.getDescription(firstDiff);
        String controlDetails = this.getDetails(firstDiff.getControlDetails(), firstDiff.getType());
        String testDetails = this.getDetails(firstDiff.getTestDetails(), firstDiff.getType());
        Assert.assertEquals((Object)"Expected text value 'Text one' but was 'Text two' - comparing <a ...>Text one</a> at /a[1]/text()[1] to <a ...>Text two</a> at /a[1]/text()[1]", (Object)description);
        DefaultComparisonFormatterTest.assertEquals("<a>Text one</a>", controlDetails);
        DefaultComparisonFormatterTest.assertEquals("<a>Text two</a>", testDetails);
    }

    @Test
    public void testComparisonType_PROCESSING_INSTRUCTION_TARGET() {
        Diff diff = DiffBuilder.compare((Object)"<?xml-stylesheet type=\"text/xsl\" href=\"animal.xsl\" ?><a>Text one</a>").withTest((Object)"<?xml-xy type=\"text/xsl\" href=\"animal.xsl\" ?><a>Text one</a>").build();
        this.assertPreRequirements(diff, ComparisonType.PROCESSING_INSTRUCTION_TARGET);
        Comparison firstDiff = ((Difference)diff.getDifferences().iterator().next()).getComparison();
        String description = this.compFormatter.getDescription(firstDiff);
        String controlDetails = this.getDetails(firstDiff.getControlDetails(), firstDiff.getType());
        String testDetails = this.getDetails(firstDiff.getTestDetails(), firstDiff.getType());
        Assert.assertEquals((Object)"Expected processing instruction target 'xml-stylesheet' but was 'xml-xy' - comparing <?xml-stylesheet type=\"text/xsl\" href=\"animal.xsl\" ?> at /processing-instruction()[1] to <?xml-xy type=\"text/xsl\" href=\"animal.xsl\" ?> at /processing-instruction()[1]", (Object)description);
        DefaultComparisonFormatterTest.assertEquals("<?xml-stylesheet type=\"text/xsl\" href=\"animal.xsl\" ?>", controlDetails);
        DefaultComparisonFormatterTest.assertEquals("<?xml-xy type=\"text/xsl\" href=\"animal.xsl\" ?>", testDetails);
    }

    @Test
    public void testComparisonType_PROCESSING_INSTRUCTION_DATA() {
        Diff diff = DiffBuilder.compare((Object)"<?xml-stylesheet type=\"text/xsl\" href=\"animal.xsl\" ?><a>Text one</a>").withTest((Object)"<?xml-stylesheet type=\"text/xsl\" href=\"animal.css\" ?><a>Text one</a>").build();
        this.assertPreRequirements(diff, ComparisonType.PROCESSING_INSTRUCTION_DATA);
        Comparison firstDiff = ((Difference)diff.getDifferences().iterator().next()).getComparison();
        String description = this.compFormatter.getDescription(firstDiff);
        String controlDetails = this.getDetails(firstDiff.getControlDetails(), firstDiff.getType());
        String testDetails = this.getDetails(firstDiff.getTestDetails(), firstDiff.getType());
        Assert.assertEquals((Object)"Expected processing instruction data 'type=\"text/xsl\" href=\"animal.xsl\" ' but was 'type=\"text/xsl\" href=\"animal.css\" ' - comparing <?xml-stylesheet type=\"text/xsl\" href=\"animal.xsl\" ?> at /processing-instruction()[1] to <?xml-stylesheet type=\"text/xsl\" href=\"animal.css\" ?> at /processing-instruction()[1]", (Object)description);
        DefaultComparisonFormatterTest.assertEquals("<?xml-stylesheet type=\"text/xsl\" href=\"animal.xsl\" ?>", controlDetails);
        DefaultComparisonFormatterTest.assertEquals("<?xml-stylesheet type=\"text/xsl\" href=\"animal.css\" ?>", testDetails);
    }

    @Test
    public void testComparisonType_ELEMENT_TAG_NAME() {
        Diff diff = DiffBuilder.compare((Object)"<a></a>").withTest((Object)"<b></b>").build();
        this.assertPreRequirements(diff, ComparisonType.ELEMENT_TAG_NAME);
        Comparison firstDiff = ((Difference)diff.getDifferences().iterator().next()).getComparison();
        String description = this.compFormatter.getDescription(firstDiff);
        String controlDetails = this.getDetails(firstDiff.getControlDetails(), firstDiff.getType());
        String testDetails = this.getDetails(firstDiff.getTestDetails(), firstDiff.getType());
        Assert.assertEquals((Object)"Expected element tag name 'a' but was 'b' - comparing <a...> at /a[1] to <b...> at /b[1]", (Object)description);
        DefaultComparisonFormatterTest.assertEquals("<a/>", controlDetails);
        DefaultComparisonFormatterTest.assertEquals("<b/>", testDetails);
    }

    @Test
    public void testComparisonType_ATTR_VALUE_EXPLICITLY_SPECIFIED() {
        Diff diff = DiffBuilder.compare((Object)"<?xml version=\"1.0\" ?><!DOCTYPE root [<!ELEMENT root ANY><!ATTLIST root c CDATA #FIXED \"xxx\">]><root/>").withTest((Object)"<?xml version=\"1.0\" ?><!DOCTYPE root [<!ELEMENT root ANY><!ATTLIST root c CDATA #FIXED \"xxx\">]><root c=\"xxx\"/>").build();
        this.assertPreRequirements(diff, ComparisonType.ATTR_VALUE_EXPLICITLY_SPECIFIED);
        Comparison firstDiff = ((Difference)diff.getDifferences().iterator().next()).getComparison();
        String description = this.compFormatter.getDescription(firstDiff);
        String controlDetails = this.getDetails(firstDiff.getControlDetails(), firstDiff.getType());
        String testDetails = this.getDetails(firstDiff.getTestDetails(), firstDiff.getType());
        Assert.assertEquals((Object)"Expected attribute value explicitly specified 'false' but was 'true' - comparing <root c=\"xxx\"...> at /root[1]/@c to <root c=\"xxx\"...> at /root[1]/@c", (Object)description);
        DefaultComparisonFormatterTest.assertEquals("<root c=\"xxx\"/>", controlDetails);
        DefaultComparisonFormatterTest.assertEquals("<root c=\"xxx\"/>", testDetails);
    }

    @Test
    public void testComparisonType_ELEMENT_NUM_ATTRIBUTES() {
        Diff diff = DiffBuilder.compare((Object)"<a b=\"xxx\"></a>").withTest((Object)"<a b=\"xxx\" c=\"xxx\"></a>").build();
        this.assertPreRequirements(diff, ComparisonType.ELEMENT_NUM_ATTRIBUTES);
        Comparison firstDiff = ((Difference)diff.getDifferences().iterator().next()).getComparison();
        String description = this.compFormatter.getDescription(firstDiff);
        String controlDetails = this.getDetails(firstDiff.getControlDetails(), firstDiff.getType());
        String testDetails = this.getDetails(firstDiff.getTestDetails(), firstDiff.getType());
        Assert.assertEquals((Object)"Expected number of attributes '1' but was '2' - comparing <a...> at /a[1] to <a...> at /a[1]", (Object)description);
        DefaultComparisonFormatterTest.assertEquals("<a b=\"xxx\"/>", controlDetails);
        DefaultComparisonFormatterTest.assertEquals("<a b=\"xxx\" c=\"xxx\"/>", testDetails);
    }

    @Test
    public void testComparisonType_ATTR_VALUE() {
        Diff diff = DiffBuilder.compare((Object)"<a b=\"xxx\"></a>").withTest((Object)"<a b=\"yyy\"></a>").build();
        this.assertPreRequirements(diff, ComparisonType.ATTR_VALUE);
        Comparison firstDiff = ((Difference)diff.getDifferences().iterator().next()).getComparison();
        String description = this.compFormatter.getDescription(firstDiff);
        String controlDetails = this.getDetails(firstDiff.getControlDetails(), firstDiff.getType());
        String testDetails = this.getDetails(firstDiff.getTestDetails(), firstDiff.getType());
        Assert.assertEquals((Object)"Expected attribute value 'xxx' but was 'yyy' - comparing <a b=\"xxx\"...> at /a[1]/@b to <a b=\"yyy\"...> at /a[1]/@b", (Object)description);
        DefaultComparisonFormatterTest.assertEquals("<a b=\"xxx\"/>", controlDetails);
        DefaultComparisonFormatterTest.assertEquals("<a b=\"yyy\"/>", testDetails);
    }

    @Test
    public void testComparisonType_CHILD_NODELIST_LENGTH() {
        Diff diff = DiffBuilder.compare((Object)"<a><b/></a>").withTest((Object)"<a><b/><c/></a>").build();
        this.assertPreRequirements(diff, ComparisonType.CHILD_NODELIST_LENGTH);
        Comparison firstDiff = ((Difference)diff.getDifferences().iterator().next()).getComparison();
        String description = this.compFormatter.getDescription(firstDiff);
        String controlDetails = this.getDetails(firstDiff.getControlDetails(), firstDiff.getType());
        String testDetails = this.getDetails(firstDiff.getTestDetails(), firstDiff.getType());
        Assert.assertEquals((Object)"Expected child nodelist length '1' but was '2' - comparing <a...> at /a[1] to <a...> at /a[1]", (Object)description);
        DefaultComparisonFormatterTest.assertEquals("<a>\n  <b/>\n</a>", controlDetails);
        DefaultComparisonFormatterTest.assertEquals("<a>\n  <b/>\n  <c/>\n</a>", testDetails);
    }

    @Test
    public void testComparisonType_CHILD_NODELIST_SEQUENCE() {
        Diff diff = DiffBuilder.compare((Object)"<a><b>XXX</b><b>YYY</b></a>").withTest((Object)"<a><b>YYY</b><b>XXX</b></a>").withNodeMatcher((NodeMatcher)new DefaultNodeMatcher(new ElementSelector[]{ElementSelectors.byNameAndText})).build();
        this.assertPreRequirements(diff, ComparisonType.CHILD_NODELIST_SEQUENCE);
        Comparison firstDiff = ((Difference)diff.getDifferences().iterator().next()).getComparison();
        String description = this.compFormatter.getDescription(firstDiff);
        String controlDetails = this.getDetails(firstDiff.getControlDetails(), firstDiff.getType());
        String testDetails = this.getDetails(firstDiff.getTestDetails(), firstDiff.getType());
        Assert.assertEquals((Object)"Expected child nodelist sequence '0' but was '1' - comparing <b...> at /a[1]/b[1] to <b...> at /a[1]/b[2]", (Object)description);
        DefaultComparisonFormatterTest.assertEquals("<a>\n  <b>XXX</b>\n  <b>YYY</b>\n</a>", controlDetails);
        DefaultComparisonFormatterTest.assertEquals("<a>\n  <b>YYY</b>\n  <b>XXX</b>\n</a>", testDetails);
    }

    @Test
    public void testComparisonType_CHILD_LOOKUP() {
        Diff diff = DiffBuilder.compare((Object)"<a>Text</a>").withTest((Object)"<a><Element/></a>").build();
        this.assertPreRequirements(diff, ComparisonType.CHILD_LOOKUP);
        Comparison firstDiff = ((Difference)diff.getDifferences().iterator().next()).getComparison();
        String description = this.compFormatter.getDescription(firstDiff);
        String controlDetails = this.getDetails(firstDiff.getControlDetails(), firstDiff.getType());
        String testDetails = this.getDetails(firstDiff.getTestDetails(), firstDiff.getType());
        Assert.assertEquals((Object)"Expected child '#text' but was 'null' - comparing <a ...>Text</a> at /a[1]/text()[1] to <NULL>", (Object)description);
        DefaultComparisonFormatterTest.assertEquals("<a>Text</a>", controlDetails);
        DefaultComparisonFormatterTest.assertEquals("<NULL>", testDetails);
    }

    @Test
    public void testComparisonType_ATTR_NAME_LOOKUP() {
        Diff diff = DiffBuilder.compare((Object)"<a b=\"xxx\"></a>").withTest((Object)"<a c=\"yyy\"></a>").build();
        this.assertPreRequirements(diff, ComparisonType.ATTR_NAME_LOOKUP);
        Comparison firstDiff = ((Difference)diff.getDifferences().iterator().next()).getComparison();
        String description = this.compFormatter.getDescription(firstDiff);
        String controlDetails = this.getDetails(firstDiff.getControlDetails(), firstDiff.getType());
        String testDetails = this.getDetails(firstDiff.getTestDetails(), firstDiff.getType());
        Assert.assertEquals((Object)"Expected attribute name '/a[1]/@b' - comparing <a...> at /a[1]/@b to <a...> at /a[1]", (Object)description);
        DefaultComparisonFormatterTest.assertEquals("<a b=\"xxx\"/>", controlDetails);
        DefaultComparisonFormatterTest.assertEquals("<a c=\"yyy\"/>", testDetails);
    }

    @Test
    public void testComparisonType_Comment() {
        Diff diff = DiffBuilder.compare((Object)"<a><!--XXX--></a>").withTest((Object)"<a><!--YYY--></a>").build();
        this.assertPreRequirements(diff, ComparisonType.TEXT_VALUE);
        Comparison firstDiff = ((Difference)diff.getDifferences().iterator().next()).getComparison();
        String description = this.compFormatter.getDescription(firstDiff);
        String controlDetails = this.getDetails(firstDiff.getControlDetails(), firstDiff.getType());
        String testDetails = this.getDetails(firstDiff.getTestDetails(), firstDiff.getType());
        Assert.assertEquals((Object)"Expected text value 'XXX' but was 'YYY' - comparing <!--XXX--> at /a[1]/comment()[1] to <!--YYY--> at /a[1]/comment()[1]", (Object)description);
        DefaultComparisonFormatterTest.assertEquals("<a>\n  <!--XXX-->\n</a>", controlDetails);
        DefaultComparisonFormatterTest.assertEquals("<a>\n  <!--YYY-->\n</a>", testDetails);
    }

    @Test
    public void testComparisonType_WhitespacesAndUnformattedDetails() {
        Diff diff = DiffBuilder.compare((Object)"<a><b/></a>").withTest((Object)"<a>\n  <b/>\n</a>").build();
        this.assertPreRequirements(diff, ComparisonType.CHILD_NODELIST_LENGTH);
        Comparison firstDiff = ((Difference)diff.getDifferences().iterator().next()).getComparison();
        String description = this.compFormatter.getDescription(firstDiff);
        String controlDetails = this.getDetails(firstDiff.getControlDetails(), firstDiff.getType());
        String testDetails = this.getDetails(firstDiff.getTestDetails(), firstDiff.getType());
        String controlDetailsUnformatted = this.compFormatter.getDetails(firstDiff.getControlDetails(), firstDiff.getType(), false);
        String testDetailsUnformatted = this.compFormatter.getDetails(firstDiff.getTestDetails(), firstDiff.getType(), false);
        Assert.assertEquals((Object)"Expected child nodelist length '1' but was '3' - comparing <a...> at /a[1] to <a...> at /a[1]", (Object)description);
        DefaultComparisonFormatterTest.assertEquals("<a>\n  <b/>\n</a>", controlDetails);
        DefaultComparisonFormatterTest.assertEquals("<a>\n  <b/>\n</a>", testDetails);
        DefaultComparisonFormatterTest.assertEquals("<a><b/></a>", controlDetailsUnformatted);
        DefaultComparisonFormatterTest.assertEquals("<a>\n  <b/>\n</a>", testDetailsUnformatted);
    }

    private DocumentBuilderFactory getDocumentBuilderFactoryWithoutValidation() throws ParserConfigurationException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setValidating(false);
        dbf.setNamespaceAware(true);
        dbf.setFeature("http://xml.org/sax/features/namespaces", false);
        dbf.setFeature("http://xml.org/sax/features/validation", false);
        dbf.setFeature("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
        dbf.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        return dbf;
    }

    public static void assertEquals(String expected, String actual) {
        Assert.assertEquals((Object)expected, (Object)actual.replace("\r", ""));
    }

    private void assertPreRequirements(Diff diff, ComparisonType comparisonType) {
        MatcherAssert.assertThat(diff.getDifferences().iterator().next(), (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)((Difference)diff.getDifferences().iterator().next()).getComparison().getType(), (Matcher)CoreMatchers.is((Object)comparisonType));
    }

    private String getDetails(Comparison.Detail difference, ComparisonType type) {
        return this.compFormatter.getDetails(difference, type, true);
    }
}

