/*
 * Decompiled with CFR 0.152.
 */
package org.xmlunit.diff;

import java.util.ArrayList;
import java.util.List;
import javax.xml.transform.Source;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.xmlunit.builder.Input;
import org.xmlunit.diff.Comparison;
import org.xmlunit.diff.ComparisonListener;
import org.xmlunit.diff.ComparisonResult;
import org.xmlunit.diff.ComparisonType;
import org.xmlunit.diff.DOMDifferenceEngine;
import org.xmlunit.diff.DifferenceEvaluator;
import org.xmlunit.diff.DifferenceEvaluators;

public class DifferenceEvaluatorsTest {
    @Test
    public void emptyFirstJustWorks() {
        DifferenceEvaluator d = DifferenceEvaluators.first((DifferenceEvaluator[])new DifferenceEvaluator[0]);
        Assert.assertEquals((Object)ComparisonResult.DIFFERENT, (Object)d.evaluate(null, ComparisonResult.DIFFERENT));
    }

    @Test
    public void firstChangeWinsInFirst() {
        Evaluator e1 = new Evaluator(ComparisonResult.DIFFERENT);
        Evaluator e2 = new Evaluator(ComparisonResult.EQUAL);
        DifferenceEvaluator d = DifferenceEvaluators.first((DifferenceEvaluator[])new DifferenceEvaluator[]{e1, e2});
        Assert.assertEquals((Object)ComparisonResult.DIFFERENT, (Object)d.evaluate(null, ComparisonResult.SIMILAR));
        Assert.assertTrue((boolean)e1.called);
        Assert.assertFalse((boolean)e2.called);
        e1.called = false;
        Assert.assertEquals((Object)ComparisonResult.EQUAL, (Object)d.evaluate(null, ComparisonResult.DIFFERENT));
        Assert.assertTrue((boolean)e1.called);
        Assert.assertTrue((boolean)e2.called);
    }

    @Test
    public void allEvaluatorsAreCalledInSequence() {
        Evaluator e1 = new Evaluator(ComparisonResult.SIMILAR);
        Evaluator e2 = new Evaluator(ComparisonResult.EQUAL);
        DifferenceEvaluator d = DifferenceEvaluators.chain((DifferenceEvaluator[])new DifferenceEvaluator[]{e1, e2});
        Assert.assertEquals((Object)ComparisonResult.EQUAL, (Object)d.evaluate(null, ComparisonResult.DIFFERENT));
        Assert.assertTrue((boolean)e1.called);
        Assert.assertThat((Object)e1.orig, (Matcher)CoreMatchers.is((Object)ComparisonResult.DIFFERENT));
        Assert.assertTrue((boolean)e2.called);
        Assert.assertThat((Object)e2.orig, (Matcher)CoreMatchers.is((Object)ComparisonResult.SIMILAR));
    }

    @Test
    public void downgradeDifferencesToEqualDowngradesMatchingTypes() {
        DifferenceEvaluator d = DifferenceEvaluators.downgradeDifferencesToEqual((ComparisonType[])new ComparisonType[]{ComparisonType.XML_VERSION, ComparisonType.XML_STANDALONE});
        Assert.assertEquals((Object)ComparisonResult.EQUAL, (Object)d.evaluate(new Comparison(ComparisonType.XML_VERSION, null, null, null, null, null, null, null, null), ComparisonResult.SIMILAR));
    }

    @Test
    public void downgradeDifferencesToEqualLeavesUnknownTypesAlone() {
        DifferenceEvaluator d = DifferenceEvaluators.downgradeDifferencesToEqual((ComparisonType[])new ComparisonType[]{ComparisonType.XML_VERSION, ComparisonType.XML_STANDALONE});
        Assert.assertEquals((Object)ComparisonResult.SIMILAR, (Object)d.evaluate(new Comparison(ComparisonType.XML_ENCODING, null, null, null, null, null, null, null, null), ComparisonResult.SIMILAR));
    }

    @Test
    public void downgradeDifferencesToSimilarDowngradesMatchingTypes() {
        DifferenceEvaluator d = DifferenceEvaluators.downgradeDifferencesToSimilar((ComparisonType[])new ComparisonType[]{ComparisonType.XML_VERSION, ComparisonType.XML_STANDALONE});
        Assert.assertEquals((Object)ComparisonResult.SIMILAR, (Object)d.evaluate(new Comparison(ComparisonType.XML_VERSION, null, null, null, null, null, null, null, null), ComparisonResult.DIFFERENT));
    }

    @Test
    public void downgradeDifferencesToSimilarLeavesUnknownTypesAlone() {
        DifferenceEvaluator d = DifferenceEvaluators.downgradeDifferencesToSimilar((ComparisonType[])new ComparisonType[]{ComparisonType.XML_VERSION, ComparisonType.XML_STANDALONE});
        Assert.assertEquals((Object)ComparisonResult.DIFFERENT, (Object)d.evaluate(new Comparison(ComparisonType.XML_ENCODING, null, null, null, null, null, null, null, null), ComparisonResult.DIFFERENT));
    }

    @Test
    public void downgradeDifferencesToSimilarLeavesEqualResultsAlone() {
        DifferenceEvaluator d = DifferenceEvaluators.downgradeDifferencesToSimilar((ComparisonType[])new ComparisonType[]{ComparisonType.XML_VERSION, ComparisonType.XML_STANDALONE});
        Assert.assertEquals((Object)ComparisonResult.EQUAL, (Object)d.evaluate(new Comparison(ComparisonType.XML_VERSION, null, null, null, null, null, null, null, null), ComparisonResult.EQUAL));
    }

    @Test
    public void upgradeDifferencesToDifferentUpgradesMatchingTypes() {
        DifferenceEvaluator d = DifferenceEvaluators.upgradeDifferencesToDifferent((ComparisonType[])new ComparisonType[]{ComparisonType.XML_VERSION, ComparisonType.XML_STANDALONE});
        Assert.assertEquals((Object)ComparisonResult.DIFFERENT, (Object)d.evaluate(new Comparison(ComparisonType.XML_VERSION, null, null, null, null, null, null, null, null), ComparisonResult.SIMILAR));
    }

    @Test
    public void upgradeDifferencesToDifferentLeavesUnknownTypesAlone() {
        DifferenceEvaluator d = DifferenceEvaluators.upgradeDifferencesToDifferent((ComparisonType[])new ComparisonType[]{ComparisonType.XML_VERSION, ComparisonType.XML_STANDALONE});
        Assert.assertEquals((Object)ComparisonResult.SIMILAR, (Object)d.evaluate(new Comparison(ComparisonType.XML_ENCODING, null, null, null, null, null, null, null, null), ComparisonResult.SIMILAR));
    }

    @Test
    public void upgradeDifferencesToDifferentLeavesEqualResultsAlone() {
        DifferenceEvaluator d = DifferenceEvaluators.upgradeDifferencesToDifferent((ComparisonType[])new ComparisonType[]{ComparisonType.XML_VERSION, ComparisonType.XML_STANDALONE});
        Assert.assertEquals((Object)ComparisonResult.EQUAL, (Object)d.evaluate(new Comparison(ComparisonType.XML_VERSION, null, null, null, null, null, null, null, null), ComparisonResult.EQUAL));
    }

    @Test
    public void ignorePrologIgnoresAdditionalContentInProlog() {
        List<Comparison> differences = this.compare("<?xml version = \"1.0\" encoding = \"UTF-8\"?><!-- some comment --><?foo some PI ?>\n<bar/>", "<bar/>");
        Assert.assertThat(differences, (Matcher)Matchers.hasSize((int)0));
    }

    @Test
    public void ignorePrologIgnoresXMLDeclarationDifferences() {
        List<Comparison> differences = this.compare("<?xml version = \"1.0\" encoding = \"UTF-8\"?><!-- some comment --><?foo some PI ?>\n<bar/>", "<?xml version = \"1.0\" encoding = \"UTF-8\"?><!-- some comment --><?foo some PI ?>\n<bar/>");
        Assert.assertThat(differences, (Matcher)Matchers.hasSize((int)0));
    }

    @Test
    public void ignorePrologIgnoresPrologCommentDifferences() {
        List<Comparison> differences = this.compare("<?xml version = \"1.0\" encoding = \"UTF-8\"?><!-- some comment --><?foo some PI ?>\n<bar/>", "<?xml version = \"1.0\" encoding = \"UTF-8\"?><?foo some PI ?>\n<!-- some other comment --><bar/>");
        Assert.assertThat(differences, (Matcher)Matchers.hasSize((int)0));
    }

    @Test
    public void ignorePrologIgnoresPrologProcessingInstructionDifferences() {
        List<Comparison> differences = this.compare("<?xml version = \"1.0\" encoding = \"UTF-8\"?><!-- some comment --><?foo some PI ?>\n<bar/>", "<?xml version = \"1.0\" encoding = \"UTF-8\"?><!-- some comment --><?foo some other PI ?>\n<bar/>");
        Assert.assertThat(differences, (Matcher)Matchers.hasSize((int)0));
    }

    @Test
    public void ignorePrologIgnoresPrologWhitespaceDifferences() {
        List<Comparison> differences = this.compare("<?xml version = \"1.0\" encoding = \"UTF-8\"?><!-- some comment --><?foo some PI ?>\n<bar/>", "<?xml version = \"1.0\" encoding = \"UTF-8\"?><!-- some comment --> <?foo some PI ?><bar/>");
        Assert.assertThat(differences, (Matcher)Matchers.hasSize((int)0));
    }

    @Test
    public void ignorePrologIgnoresDoesntIgnoreElementName() {
        List<Comparison> differences = this.compare("<?xml version = \"1.0\" encoding = \"UTF-8\"?><!-- some comment --><?foo some PI ?>\n<foo/>", "<?xml version = \"1.0\" encoding = \"UTF-8\"?><!-- some comment --><?foo some PI ?>\n<bar/>");
        Assert.assertThat(differences, (Matcher)CoreMatchers.not((Matcher)Matchers.hasSize((int)0)));
    }

    @Test
    public void ignorePrologDoesntIgnoreCommentsOutsideOfProlog() {
        List<Comparison> differences = this.compare("<?xml version = \"1.0\" encoding = \"UTF-8\"?><foo><!-- some comment --></foo>", "<?xml version = \"1.0\" encoding = \"UTF-8\"?><foo><!-- some other comment --></foo>");
        Assert.assertThat(differences, (Matcher)CoreMatchers.not((Matcher)Matchers.hasSize((int)0)));
    }

    @Test
    public void ignorePrologDoesntIgnorePIsOutsideOfProlog() {
        List<Comparison> differences = this.compare("<?xml version = \"1.0\" encoding = \"UTF-8\"?><foo><?foo some PI ?>\n</foo>", "<?xml version = \"1.0\" encoding = \"UTF-8\"?><foo><?foo some other PI ?>\n</foo>");
        Assert.assertThat(differences, (Matcher)CoreMatchers.not((Matcher)Matchers.hasSize((int)0)));
    }

    @Test
    public void ignorePrologDoesntIgnoreWhitespaceOutsideOfProlog() {
        List<Comparison> differences = this.compare("<?xml version = \"1.0\" encoding = \"UTF-8\"?><foo>\n</foo>", "<?xml version = \"1.0\" encoding = \"UTF-8\"?><foo></foo>");
        Assert.assertThat(differences, (Matcher)CoreMatchers.not((Matcher)Matchers.hasSize((int)0)));
    }

    @Test
    public void ignorePrologIgnoresPresenceOfDoctype() {
        List<Comparison> differences = this.compare("<!DOCTYPE test [<!ELEMENT bar EMPTY>]><bar/>", "<bar/>");
        Assert.assertThat(differences, (Matcher)Matchers.hasSize((int)0));
    }

    @Test
    public void ignorePrologIgnoresNameOfDoctype() {
        List<Comparison> differences = this.compare("<!DOCTYPE foo [<!ELEMENT bar EMPTY>]><bar/>", "<!DOCTYPE test [<!ELEMENT bar EMPTY>]><bar/>");
        Assert.assertThat(differences, (Matcher)Matchers.hasSize((int)0));
    }

    @Test
    public void ignorePrologExceptDoctypeIgnoresAdditionalContentInProlog() {
        List<Comparison> differences = this.compare("<?xml version = \"1.0\" encoding = \"UTF-8\"?><!-- some comment --><?foo some PI ?>\n<bar/>", "<bar/>");
        Assert.assertThat(differences, (Matcher)Matchers.hasSize((int)0));
    }

    @Test
    public void ignorePrologExceptDoctypeIgnoresXMLDeclarationDifferences() {
        List<Comparison> differences = this.compare("<?xml version = \"1.0\" encoding = \"UTF-8\"?><!-- some comment --><?foo some PI ?>\n<bar/>", "<?xml version = \"1.0\" encoding = \"UTF-8\"?><!-- some comment --><?foo some PI ?>\n<bar/>", false);
        Assert.assertThat(differences, (Matcher)Matchers.hasSize((int)0));
    }

    @Test
    public void ignorePrologExceptDoctypeIgnoresPrologCommentDifferences() {
        List<Comparison> differences = this.compare("<?xml version = \"1.0\" encoding = \"UTF-8\"?><!-- some comment --><?foo some PI ?>\n<bar/>", "<?xml version = \"1.0\" encoding = \"UTF-8\"?><?foo some PI ?>\n<!-- some other comment --><bar/>", false);
        Assert.assertThat(differences, (Matcher)Matchers.hasSize((int)0));
    }

    @Test
    public void ignorePrologExceptDoctypeIgnoresPrologProcessingInstructionDifferences() {
        List<Comparison> differences = this.compare("<?xml version = \"1.0\" encoding = \"UTF-8\"?><!-- some comment --><?foo some PI ?>\n<bar/>", "<?xml version = \"1.0\" encoding = \"UTF-8\"?><!-- some comment --><?foo some other PI ?>\n<bar/>", false);
        Assert.assertThat(differences, (Matcher)Matchers.hasSize((int)0));
    }

    @Test
    public void ignorePrologExceptDoctypeIgnoresPrologWhitespaceDifferences() {
        List<Comparison> differences = this.compare("<?xml version = \"1.0\" encoding = \"UTF-8\"?><!-- some comment --><?foo some PI ?>\n<bar/>", "<?xml version = \"1.0\" encoding = \"UTF-8\"?><!-- some comment --> <?foo some PI ?><bar/>", false);
        Assert.assertThat(differences, (Matcher)Matchers.hasSize((int)0));
    }

    @Test
    public void ignorePrologExceptDoctypeIgnoresDoesntIgnoreElementName() {
        List<Comparison> differences = this.compare("<?xml version = \"1.0\" encoding = \"UTF-8\"?><!-- some comment --><?foo some PI ?>\n<foo/>", "<?xml version = \"1.0\" encoding = \"UTF-8\"?><!-- some comment --><?foo some PI ?>\n<bar/>", false);
        Assert.assertThat(differences, (Matcher)CoreMatchers.not((Matcher)Matchers.hasSize((int)0)));
    }

    @Test
    public void ignorePrologExceptDoctypeDoesntIgnoreCommentsOutsideOfProlog() {
        List<Comparison> differences = this.compare("<?xml version = \"1.0\" encoding = \"UTF-8\"?><foo><!-- some comment --></foo>", "<?xml version = \"1.0\" encoding = \"UTF-8\"?><foo><!-- some other comment --></foo>", false);
        Assert.assertThat(differences, (Matcher)CoreMatchers.not((Matcher)Matchers.hasSize((int)0)));
    }

    @Test
    public void ignorePrologExceptDoctypeDoesntIgnorePIsOutsideOfProlog() {
        List<Comparison> differences = this.compare("<?xml version = \"1.0\" encoding = \"UTF-8\"?><foo><?foo some PI ?>\n</foo>", "<?xml version = \"1.0\" encoding = \"UTF-8\"?><foo><?foo some other PI ?>\n</foo>", false);
        Assert.assertThat(differences, (Matcher)CoreMatchers.not((Matcher)Matchers.hasSize((int)0)));
    }

    @Test
    public void ignorePrologExceptDoctypeDoesntIgnoreWhitespaceOutsideOfProlog() {
        List<Comparison> differences = this.compare("<?xml version = \"1.0\" encoding = \"UTF-8\"?><foo>\n</foo>", "<?xml version = \"1.0\" encoding = \"UTF-8\"?><foo></foo>", false);
        Assert.assertThat(differences, (Matcher)CoreMatchers.not((Matcher)Matchers.hasSize((int)0)));
    }

    @Test
    public void ignorePrologExceptDoctypeDoesntIgnorePresenceOfDoctype() {
        List<Comparison> differences = this.compare("<!DOCTYPE test [<!ELEMENT bar EMPTY>]><bar/>", "<bar/>", false);
        Assert.assertThat(differences, (Matcher)CoreMatchers.not((Matcher)Matchers.hasSize((int)0)));
    }

    @Test
    public void ignorePrologExceptDoctypeDoesntIgnoreNameOfDoctype() {
        List<Comparison> differences = this.compare("<!DOCTYPE foo [<!ELEMENT bar EMPTY>]><bar/>", "<!DOCTYPE test [<!ELEMENT bar EMPTY>]><bar/>", false);
        Assert.assertThat(differences, (Matcher)CoreMatchers.not((Matcher)Matchers.hasSize((int)0)));
    }

    private List<Comparison> compare(String controlXml, String testXml) {
        return this.compare(controlXml, testXml, true);
    }

    private List<Comparison> compare(String controlXml, String testXml, boolean ignoreDoctypeDeclarationAsWell) {
        Source control = Input.from((Object)controlXml).build();
        Source test = Input.from((Object)testXml).build();
        DOMDifferenceEngine e = new DOMDifferenceEngine();
        if (ignoreDoctypeDeclarationAsWell) {
            e.setDifferenceEvaluator(DifferenceEvaluators.ignorePrologDifferences());
        } else {
            e.setDifferenceEvaluator(DifferenceEvaluators.ignorePrologDifferencesExceptDoctype());
        }
        final ArrayList<Comparison> differences = new ArrayList<Comparison>();
        e.addDifferenceListener(new ComparisonListener(){

            public void comparisonPerformed(Comparison comparison, ComparisonResult outcome) {
                differences.add(comparison);
            }
        });
        e.compare(control, test);
        return differences;
    }

    private static class Evaluator
    implements DifferenceEvaluator {
        private boolean called = false;
        private final ComparisonResult ret;
        private ComparisonResult orig;

        private Evaluator(ComparisonResult ret) {
            this.ret = ret;
        }

        public ComparisonResult evaluate(Comparison comparison, ComparisonResult orig) {
            this.called = true;
            this.orig = orig;
            return this.ret;
        }
    }
}

