/*
 * Decompiled with CFR 0.152.
 */
package org.xmlunit.diff;

import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xmlunit.diff.ElementSelector;
import org.xmlunit.diff.ElementSelectors;
import org.xmlunit.util.IsNullPredicate;
import org.xmlunit.util.Predicate;

public class ElementSelectorsTest {
    static final String FOO = "foo";
    static final String BAR = "bar";
    static final String SOME_URI = "urn:some:uri";
    private Document doc;

    @Before
    public void createDoc() throws Exception {
        this.doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
    }

    private void pureElementNameComparisons(ElementSelector s) {
        ElementSelectorsTest.pureElementNameComparisons(s, this.doc);
    }

    static void pureElementNameComparisons(ElementSelector s, Document doc) {
        Element control = doc.createElement(FOO);
        Element equal = doc.createElement(FOO);
        Element different = doc.createElement(BAR);
        Element controlNS = doc.createElementNS(SOME_URI, FOO);
        controlNS.setPrefix(BAR);
        Assert.assertFalse((boolean)s.canBeCompared(null, null));
        Assert.assertFalse((boolean)s.canBeCompared(null, control));
        Assert.assertFalse((boolean)s.canBeCompared(control, null));
        Assert.assertTrue((boolean)s.canBeCompared(control, equal));
        Assert.assertFalse((boolean)s.canBeCompared(control, different));
        Assert.assertFalse((boolean)s.canBeCompared(control, controlNS));
        Assert.assertTrue((boolean)s.canBeCompared(doc.createElementNS(SOME_URI, FOO), controlNS));
    }

    @Test
    public void byName() {
        this.pureElementNameComparisons(ElementSelectors.byName);
    }

    @Test
    public void byNameAndText_NamePart() {
        this.pureElementNameComparisons(ElementSelectors.byNameAndText);
    }

    static void byNameAndText_SingleLevel(ElementSelector s, Document doc) {
        Element control = doc.createElement(FOO);
        control.appendChild(doc.createTextNode(BAR));
        Element equal = doc.createElement(FOO);
        equal.appendChild(doc.createTextNode(BAR));
        Element equalC = doc.createElement(FOO);
        equalC.appendChild(doc.createCDATASection(BAR));
        Element noText = doc.createElement(FOO);
        Element differentText = doc.createElement(FOO);
        differentText.appendChild(doc.createTextNode(BAR));
        differentText.appendChild(doc.createTextNode(BAR));
        Assert.assertTrue((boolean)s.canBeCompared(control, equal));
        Assert.assertTrue((boolean)s.canBeCompared(control, equalC));
        Assert.assertFalse((boolean)s.canBeCompared(control, noText));
        Assert.assertFalse((boolean)s.canBeCompared(control, differentText));
    }

    @Test
    public void byNameAndText() {
        ElementSelectorsTest.byNameAndText_SingleLevel(ElementSelectors.byNameAndText, this.doc);
    }

    @Test
    public void byNameAndAllAttributes_NamePart() {
        this.pureElementNameComparisons(ElementSelectors.byNameAndAllAttributes);
    }

    @Test
    public void byNameAndAllAttributes() {
        Element control = this.doc.createElement(FOO);
        control.setAttribute(BAR, BAR);
        Element equal = this.doc.createElement(FOO);
        equal.setAttribute(BAR, BAR);
        Element noAttributes = this.doc.createElement(FOO);
        Element differentValue = this.doc.createElement(FOO);
        differentValue.setAttribute(BAR, FOO);
        Element differentName = this.doc.createElement(FOO);
        differentName.setAttribute(FOO, FOO);
        Element differentNS = this.doc.createElement(FOO);
        differentNS.setAttributeNS(SOME_URI, BAR, BAR);
        Assert.assertTrue((boolean)ElementSelectors.byNameAndAllAttributes.canBeCompared(control, equal));
        Assert.assertFalse((boolean)ElementSelectors.byNameAndAllAttributes.canBeCompared(control, noAttributes));
        Assert.assertFalse((boolean)ElementSelectors.byNameAndAllAttributes.canBeCompared(noAttributes, control));
        Assert.assertFalse((boolean)ElementSelectors.byNameAndAllAttributes.canBeCompared(control, differentValue));
        Assert.assertFalse((boolean)ElementSelectors.byNameAndAllAttributes.canBeCompared(control, differentName));
        Assert.assertFalse((boolean)ElementSelectors.byNameAndAllAttributes.canBeCompared(control, differentNS));
    }

    @Test
    public void byNameAndAttributes_NamePart() {
        this.pureElementNameComparisons(ElementSelectors.byNameAndAttributes((String[])new String[0]));
        this.pureElementNameComparisons(ElementSelectors.byNameAndAttributes((QName[])new QName[0]));
        this.pureElementNameComparisons(ElementSelectors.byNameAndAttributes((String[])new String[]{BAR}));
        this.pureElementNameComparisons(ElementSelectors.byNameAndAttributes((QName[])new QName[]{new QName(SOME_URI, BAR)}));
    }

    @Test
    public void byNameAndAttributes_String() {
        Element control = this.doc.createElement(FOO);
        control.setAttribute(BAR, BAR);
        Element equal = this.doc.createElement(FOO);
        equal.setAttribute(BAR, BAR);
        Element noAttributes = this.doc.createElement(FOO);
        Element differentValue = this.doc.createElement(FOO);
        differentValue.setAttribute(BAR, FOO);
        Element differentName = this.doc.createElement(FOO);
        differentName.setAttribute(FOO, FOO);
        Element differentNS = this.doc.createElement(FOO);
        differentNS.setAttributeNS(SOME_URI, BAR, BAR);
        Assert.assertTrue((boolean)ElementSelectors.byNameAndAttributes((String[])new String[]{BAR}).canBeCompared(control, equal));
        Assert.assertFalse((boolean)ElementSelectors.byNameAndAttributes((String[])new String[]{BAR}).canBeCompared(control, noAttributes));
        Assert.assertTrue((boolean)ElementSelectors.byNameAndAttributes((String[])new String[]{FOO}).canBeCompared(control, noAttributes));
        Assert.assertTrue((boolean)ElementSelectors.byNameAndAttributes((String[])new String[0]).canBeCompared(control, noAttributes));
        Assert.assertFalse((boolean)ElementSelectors.byNameAndAttributes((String[])new String[]{BAR}).canBeCompared(noAttributes, control));
        Assert.assertFalse((boolean)ElementSelectors.byNameAndAttributes((String[])new String[]{BAR}).canBeCompared(control, differentValue));
        Assert.assertFalse((boolean)ElementSelectors.byNameAndAttributes((String[])new String[]{BAR}).canBeCompared(control, differentName));
        Assert.assertFalse((boolean)ElementSelectors.byNameAndAttributes((String[])new String[]{BAR}).canBeCompared(control, differentNS));
    }

    @Test
    public void byNameAndAttributes_QName() {
        Element control = this.doc.createElement(FOO);
        control.setAttribute(BAR, BAR);
        Element equal = this.doc.createElement(FOO);
        equal.setAttribute(BAR, BAR);
        Element noAttributes = this.doc.createElement(FOO);
        Element differentValue = this.doc.createElement(FOO);
        differentValue.setAttribute(BAR, FOO);
        Element differentName = this.doc.createElement(FOO);
        differentName.setAttribute(FOO, FOO);
        Element differentNS = this.doc.createElement(FOO);
        differentNS.setAttributeNS(SOME_URI, BAR, BAR);
        Assert.assertTrue((boolean)ElementSelectors.byNameAndAttributes((QName[])new QName[]{new QName(BAR)}).canBeCompared(control, equal));
        Assert.assertFalse((boolean)ElementSelectors.byNameAndAttributes((QName[])new QName[]{new QName(BAR)}).canBeCompared(control, noAttributes));
        Assert.assertTrue((boolean)ElementSelectors.byNameAndAttributes((QName[])new QName[]{new QName(FOO)}).canBeCompared(control, noAttributes));
        Assert.assertTrue((boolean)ElementSelectors.byNameAndAttributes((QName[])new QName[0]).canBeCompared(control, noAttributes));
        Assert.assertFalse((boolean)ElementSelectors.byNameAndAttributes((QName[])new QName[]{new QName(BAR)}).canBeCompared(noAttributes, control));
        Assert.assertFalse((boolean)ElementSelectors.byNameAndAttributes((QName[])new QName[]{new QName(BAR)}).canBeCompared(control, differentValue));
        Assert.assertFalse((boolean)ElementSelectors.byNameAndAttributes((QName[])new QName[]{new QName(BAR)}).canBeCompared(control, differentName));
        Assert.assertFalse((boolean)ElementSelectors.byNameAndAttributes((QName[])new QName[]{new QName(BAR)}).canBeCompared(control, differentNS));
    }

    @Test
    public void byNameAndAttributesControlNS_NamePart() {
        this.pureElementNameComparisons(ElementSelectors.byNameAndAttributesControlNS((String[])new String[0]));
        this.pureElementNameComparisons(ElementSelectors.byNameAndAttributesControlNS((String[])new String[]{BAR}));
    }

    @Test
    public void byNameAndAttributesControlNS() {
        Element control = this.doc.createElement(FOO);
        control.setAttributeNS(SOME_URI, BAR, BAR);
        Element equal = this.doc.createElement(FOO);
        equal.setAttributeNS(SOME_URI, BAR, BAR);
        Element noAttributes = this.doc.createElement(FOO);
        Element differentValue = this.doc.createElement(FOO);
        differentValue.setAttributeNS(SOME_URI, BAR, FOO);
        Element differentName = this.doc.createElement(FOO);
        differentName.setAttributeNS(SOME_URI, FOO, FOO);
        Element differentNS = this.doc.createElement(FOO);
        differentNS.setAttributeNS("urn:some:uri2", BAR, BAR);
        Element noNS = this.doc.createElement(FOO);
        noNS.setAttribute(BAR, BAR);
        Assert.assertTrue((boolean)ElementSelectors.byNameAndAttributesControlNS((String[])new String[]{BAR}).canBeCompared(control, equal));
        Assert.assertFalse((boolean)ElementSelectors.byNameAndAttributesControlNS((String[])new String[]{BAR}).canBeCompared(control, noAttributes));
        Assert.assertTrue((boolean)ElementSelectors.byNameAndAttributesControlNS((String[])new String[]{FOO}).canBeCompared(control, noAttributes));
        Assert.assertTrue((boolean)ElementSelectors.byNameAndAttributesControlNS((String[])new String[0]).canBeCompared(control, noAttributes));
        Assert.assertTrue((boolean)ElementSelectors.byNameAndAttributesControlNS((String[])new String[]{BAR}).canBeCompared(noAttributes, control));
        Assert.assertFalse((boolean)ElementSelectors.byNameAndAttributesControlNS((String[])new String[]{BAR}).canBeCompared(noAttributes, noNS));
        Assert.assertFalse((boolean)ElementSelectors.byNameAndAttributesControlNS((String[])new String[]{BAR}).canBeCompared(control, differentValue));
        Assert.assertFalse((boolean)ElementSelectors.byNameAndAttributesControlNS((String[])new String[]{BAR}).canBeCompared(control, differentName));
        Assert.assertFalse((boolean)ElementSelectors.byNameAndAttributesControlNS((String[])new String[]{BAR}).canBeCompared(control, differentNS));
        Assert.assertFalse((boolean)ElementSelectors.byNameAndAttributesControlNS((String[])new String[]{BAR}).canBeCompared(control, noNS));
    }

    @Test
    public void not() {
        Element control = this.doc.createElement(FOO);
        Element equal = this.doc.createElement(FOO);
        Element different = this.doc.createElement(BAR);
        Assert.assertFalse((boolean)ElementSelectors.not((ElementSelector)ElementSelectors.byName).canBeCompared(control, equal));
        Assert.assertTrue((boolean)ElementSelectors.not((ElementSelector)ElementSelectors.byName).canBeCompared(control, different));
    }

    @Test
    public void or() {
        Element control = this.doc.createElement(FOO);
        Element test = this.doc.createElement(BAR);
        Assert.assertFalse((boolean)ElementSelectors.or((ElementSelector[])new ElementSelector[]{ElementSelectors.byName}).canBeCompared(control, test));
        Assert.assertTrue((boolean)ElementSelectors.or((ElementSelector[])new ElementSelector[]{ElementSelectors.byName, ElementSelectors.Default}).canBeCompared(control, test));
    }

    @Test
    public void and() {
        Element control = this.doc.createElement(FOO);
        control.setAttributeNS(SOME_URI, BAR, BAR);
        Element test = this.doc.createElement(FOO);
        Assert.assertTrue((boolean)ElementSelectors.and((ElementSelector[])new ElementSelector[]{ElementSelectors.byName}).canBeCompared(control, test));
        Assert.assertTrue((boolean)ElementSelectors.and((ElementSelector[])new ElementSelector[]{ElementSelectors.byName, ElementSelectors.Default}).canBeCompared(control, test));
        Assert.assertFalse((boolean)ElementSelectors.and((ElementSelector[])new ElementSelector[]{ElementSelectors.byName, ElementSelectors.Default, ElementSelectors.byNameAndAllAttributes}).canBeCompared(control, test));
    }

    @Test
    public void xor() {
        Element control = this.doc.createElement(FOO);
        Element test = this.doc.createElement(BAR);
        Element test2 = this.doc.createElement(FOO);
        Assert.assertFalse((boolean)ElementSelectors.xor((ElementSelector)ElementSelectors.byName, (ElementSelector)ElementSelectors.byNameAndAllAttributes).canBeCompared(control, test));
        Assert.assertTrue((boolean)ElementSelectors.xor((ElementSelector)ElementSelectors.byName, (ElementSelector)ElementSelectors.Default).canBeCompared(control, test));
        Assert.assertFalse((boolean)ElementSelectors.xor((ElementSelector)ElementSelectors.byName, (ElementSelector)ElementSelectors.Default).canBeCompared(control, test2));
    }

    @Test
    public void conditionalReturnsFalseIfConditionIsNotMet() {
        Element control = this.doc.createElement(FOO);
        Element test = this.doc.createElement(FOO);
        Assert.assertFalse((boolean)ElementSelectors.conditionalSelector((Predicate)new Predicate<Object>(){

            public boolean test(Object o) {
                return false;
            }
        }, (ElementSelector)ElementSelectors.byName).canBeCompared(control, test));
    }

    @Test
    public void conditionalAsksWrappedSelectorIfConditionIsMet() {
        Element control = this.doc.createElement(FOO);
        Element test = this.doc.createElement(BAR);
        Element test2 = this.doc.createElement(FOO);
        Assert.assertFalse((boolean)ElementSelectors.conditionalSelector((Predicate)new Predicate<Object>(){

            public boolean test(Object o) {
                return true;
            }
        }, (ElementSelector)ElementSelectors.byName).canBeCompared(control, test));
        Assert.assertTrue((boolean)ElementSelectors.conditionalSelector((Predicate)new Predicate<Object>(){

            public boolean test(Object o) {
                return true;
            }
        }, (ElementSelector)ElementSelectors.byName).canBeCompared(control, test2));
    }

    @Test
    public void plainStringNamed() {
        Element control = this.doc.createElement(FOO);
        Element controlNS = this.doc.createElementNS(SOME_URI, FOO);
        Element test = this.doc.createElement(FOO);
        Element testNS = this.doc.createElementNS(SOME_URI, FOO);
        Assert.assertFalse((boolean)ElementSelectors.selectorForElementNamed((String)BAR, (ElementSelector)ElementSelectors.byName).canBeCompared(control, test));
        Assert.assertTrue((boolean)ElementSelectors.selectorForElementNamed((String)FOO, (ElementSelector)ElementSelectors.byName).canBeCompared(control, test));
        Assert.assertTrue((boolean)ElementSelectors.selectorForElementNamed((String)FOO, (ElementSelector)ElementSelectors.byName).canBeCompared(controlNS, testNS));
    }

    @Test
    public void qnameNamed() {
        Element control = this.doc.createElement(FOO);
        Element controlNS = this.doc.createElementNS(SOME_URI, FOO);
        Element test = this.doc.createElement(FOO);
        Element testNS = this.doc.createElementNS(SOME_URI, FOO);
        Assert.assertFalse((boolean)ElementSelectors.selectorForElementNamed((QName)new QName(BAR), (ElementSelector)ElementSelectors.byName).canBeCompared(control, test));
        Assert.assertTrue((boolean)ElementSelectors.selectorForElementNamed((QName)new QName(FOO), (ElementSelector)ElementSelectors.byName).canBeCompared(control, test));
        Assert.assertTrue((boolean)ElementSelectors.selectorForElementNamed((QName)new QName(SOME_URI, FOO, ""), (ElementSelector)ElementSelectors.byName).canBeCompared(controlNS, testNS));
    }

    @Test
    public void xpath() {
        String BAZ = "BAZ";
        String XYZZY1 = "xyzzy1";
        String XYZZY2 = "xyzzy2";
        Element control = this.doc.createElement(FOO);
        Element bar = this.doc.createElement(BAR);
        control.appendChild(bar);
        Element baz = this.doc.createElement(BAZ);
        bar.appendChild(baz);
        baz.appendChild(this.doc.createTextNode(XYZZY1));
        baz = this.doc.createElement(BAZ);
        bar.appendChild(baz);
        baz.appendChild(this.doc.createTextNode(XYZZY2));
        Element test = this.doc.createElement(FOO);
        bar = this.doc.createElement(BAR);
        test.appendChild(bar);
        baz = this.doc.createElement(BAZ);
        bar.appendChild(baz);
        baz.appendChild(this.doc.createTextNode(XYZZY2));
        baz = this.doc.createElement(BAZ);
        bar.appendChild(baz);
        baz.appendChild(this.doc.createTextNode(XYZZY1));
        Element test2 = this.doc.createElement(FOO);
        bar = this.doc.createElement(BAR);
        test2.appendChild(bar);
        baz = this.doc.createElement(BAZ);
        bar.appendChild(baz);
        baz.appendChild(this.doc.createTextNode(XYZZY2));
        baz = this.doc.createElement(BAZ);
        bar.appendChild(baz);
        baz.appendChild(this.doc.createTextNode(XYZZY2));
        Assert.assertTrue((boolean)ElementSelectors.byXPath((String)".//BAZ", (ElementSelector)ElementSelectors.byNameAndText).canBeCompared(control, test));
        Assert.assertFalse((boolean)ElementSelectors.byXPath((String)".//BAZ", (ElementSelector)ElementSelectors.byNameAndText).canBeCompared(control, test2));
    }

    @Test
    public void conditionalBuilder() {
        Element control = this.doc.createElement(FOO);
        Element test = this.doc.createElement(BAR);
        ElementSelectors.ConditionalSelectorBuilder builder = ElementSelectors.conditionalBuilder().whenElementIsNamed(FOO).thenUse(ElementSelectors.byName);
        Assert.assertFalse((boolean)builder.build().canBeCompared(control, test));
        builder.elseUse(ElementSelectors.Default);
        Assert.assertFalse((boolean)builder.build().canBeCompared(control, test));
        Element control2 = this.doc.createElement("baz");
        Assert.assertTrue((boolean)builder.build().canBeCompared(control2, test));
    }

    @Test(expected=IllegalArgumentException.class)
    public void byNameAndAttributesDoesntLikeNullArgumentStringVersion() {
        ElementSelectors.byNameAndAttributes((String[])null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void byNameAndAttributesControlNSDoesntLikeNullArgument() {
        ElementSelectors.byNameAndAttributesControlNS((String[])null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void byNameAndAttributesDoesntLikeNullArgumentQNameVersion() {
        ElementSelectors.byNameAndAttributes((QName[])null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void byNameAndAttributesDoesntLikeNullNameStringVersion() {
        ElementSelectors.byNameAndAttributes((String[])new String[]{null});
    }

    @Test(expected=IllegalArgumentException.class)
    public void byNameAndAttributesControlNSDoesntLikeNullName() {
        ElementSelectors.byNameAndAttributesControlNS((String[])new String[]{null});
    }

    @Test(expected=IllegalArgumentException.class)
    public void byNameAndAttributesDoesntLikeNullNameQNameVersion() {
        ElementSelectors.byNameAndAttributes((QName[])new QName[]{null});
    }

    @Test(expected=IllegalArgumentException.class)
    public void notDoesntLikeNullElementSelector() {
        ElementSelectors.not(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void orDoesntLikeNullElementSelectorList() {
        ElementSelectors.or((ElementSelector[])null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void orDoesntLikeNullElementSelector() {
        ElementSelectors.or((ElementSelector[])new ElementSelector[]{null});
    }

    @Test(expected=IllegalArgumentException.class)
    public void andDoesntLikeNullElementSelectorList() {
        ElementSelectors.and((ElementSelector[])null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void andDoesntLikeNullElementSelector() {
        ElementSelectors.and((ElementSelector[])new ElementSelector[]{null});
    }

    @Test(expected=IllegalArgumentException.class)
    public void xorDoesntLikeNullElementSelector1() {
        ElementSelectors.xor(null, (ElementSelector)ElementSelectors.byName);
    }

    @Test(expected=IllegalArgumentException.class)
    public void xorDoesntLikeNullElementSelector2() {
        ElementSelectors.xor((ElementSelector)ElementSelectors.byName, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void conditionalSelectorDoesntLikeNullElementSelector() {
        ElementSelectors.conditionalSelector((Predicate)new IsNullPredicate(), null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void conditionalSelectorDoesntLikeNullPredicate() {
        ElementSelectors.conditionalSelector(null, (ElementSelector)ElementSelectors.byName);
    }

    @Test(expected=IllegalArgumentException.class)
    public void selectorForElementNamedDoesntLikeNullElementSelectorStringVersion() {
        ElementSelectors.selectorForElementNamed((String)FOO, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void selectorForElementNamedDoesntLikeNullNameStringVersion() {
        ElementSelectors.selectorForElementNamed((String)null, (ElementSelector)ElementSelectors.byName);
    }

    @Test(expected=IllegalArgumentException.class)
    public void selectorForElementNamedDoesntLikeNullElementSelectorQNameVersion() {
        ElementSelectors.selectorForElementNamed((QName)new QName(FOO), null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void selectorForElementNamedDoesntLikeNullNameQNameVersion() {
        ElementSelectors.selectorForElementNamed((QName)null, (ElementSelector)ElementSelectors.byName);
    }

    @Test(expected=IllegalStateException.class)
    public void conditionalSelectorBuilderWontAllowThenWithoutWhen() {
        ElementSelectors.ConditionalSelectorBuilderThen t = (ElementSelectors.ConditionalSelectorBuilderThen)ElementSelectors.conditionalBuilder();
        t.thenUse(ElementSelectors.byName);
    }

    @Test(expected=IllegalStateException.class)
    public void conditionalSelectorBuilderWontAllowWhensWithoutThens() {
        ElementSelectors.ConditionalSelectorBuilder b = ElementSelectors.conditionalBuilder();
        b.when((Predicate)new IsNullPredicate());
        b.build();
    }

    @Test(expected=IllegalStateException.class)
    public void conditionalSelectorBuilderWontAllowMultipleWhensWithoutInterleavingThens() {
        ElementSelectors.ConditionalSelectorBuilder b = ElementSelectors.conditionalBuilder();
        b.when((Predicate)new IsNullPredicate());
        b.whenElementIsNamed(new QName(FOO));
    }

    @Test(expected=IllegalStateException.class)
    public void conditionalSelectorBuilderWontAllowMultipleDefaults() {
        ElementSelectors.ConditionalSelectorBuilder b = ElementSelectors.conditionalBuilder();
        b.elseUse(ElementSelectors.byName);
        b.elseUse(ElementSelectors.byName);
    }
}

