/*
 * Decompiled with CFR 0.152.
 */
package org.xmlunit.diff;

import javax.xml.parsers.DocumentBuilderFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xmlunit.diff.ElementSelector;
import org.xmlunit.diff.ElementSelectorsTest;
import org.xmlunit.diff.MultiLevelByNameAndTextSelector;

public class MultiLevelByNameAndTextSelectorTest {
    private Document doc;

    @Before
    public void createDoc() throws Exception {
        this.doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
    }

    @Test
    public void singleLevel() {
        ElementSelectorsTest.byNameAndText_SingleLevel((ElementSelector)new MultiLevelByNameAndTextSelector(1), this.doc);
    }

    @Test
    public void byNameAndTextRec() {
        Element control = this.doc.createElement("foo");
        Element child = this.doc.createElement("bar");
        control.appendChild(child);
        child.appendChild(this.doc.createTextNode("bar"));
        Element equal = this.doc.createElement("foo");
        Element child2 = this.doc.createElement("bar");
        equal.appendChild(child2);
        child2.appendChild(this.doc.createTextNode("bar"));
        Element equalC = this.doc.createElement("foo");
        Element child3 = this.doc.createElement("bar");
        equalC.appendChild(child3);
        child3.appendChild(this.doc.createCDATASection("bar"));
        Element noText = this.doc.createElement("foo");
        Element differentLevel = this.doc.createElement("foo");
        differentLevel.appendChild(this.doc.createTextNode("bar"));
        Element differentElement = this.doc.createElement("foo");
        Element child4 = this.doc.createElement("foo");
        differentElement.appendChild(child4);
        child4.appendChild(this.doc.createTextNode("bar"));
        Element differentText = this.doc.createElement("foo");
        Element child5 = this.doc.createElement("bar");
        differentText.appendChild(child5);
        child5.appendChild(this.doc.createTextNode("foo"));
        MultiLevelByNameAndTextSelector s = new MultiLevelByNameAndTextSelector(2);
        Assert.assertTrue((boolean)s.canBeCompared(control, equal));
        Assert.assertTrue((boolean)s.canBeCompared(control, equalC));
        Assert.assertFalse((boolean)s.canBeCompared(control, noText));
        Assert.assertFalse((boolean)s.canBeCompared(control, differentLevel));
        Assert.assertFalse((boolean)s.canBeCompared(control, differentElement));
        Assert.assertFalse((boolean)s.canBeCompared(control, differentText));
    }

    @Test
    public void emptyTexts() {
        Element control = this.doc.createElement("foo");
        Element child = this.doc.createElement("bar");
        control.appendChild(this.doc.createTextNode(""));
        control.appendChild(child);
        child.appendChild(this.doc.createTextNode("bar"));
        Element test = this.doc.createElement("foo");
        Element child2 = this.doc.createElement("bar");
        test.appendChild(child2);
        child2.appendChild(this.doc.createTextNode("bar"));
        MultiLevelByNameAndTextSelector s = new MultiLevelByNameAndTextSelector(2);
        Assert.assertFalse((boolean)new MultiLevelByNameAndTextSelector(2).canBeCompared(control, test));
        Assert.assertTrue((boolean)new MultiLevelByNameAndTextSelector(2, true).canBeCompared(control, test));
    }
}

