/*
 * Decompiled with CFR 0.152.
 */
package org.xmlunit.diff;

import java.util.Collections;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xmlunit.diff.RecursiveXPathBuilder;

public class RecursiveXPathBuilderTest {
    private Document doc;
    private RecursiveXPathBuilder builder = new RecursiveXPathBuilder();

    @Before
    public void initialize() throws Exception {
        this.doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
    }

    @Test
    public void soleElement() {
        Assert.assertEquals((Object)"/foo[1]", (Object)this.builder.apply((Node)this.doc.createElement("foo")).getXPath());
    }

    @Test
    public void rootElement() {
        Element e = this.doc.createElement("foo");
        this.doc.appendChild(e);
        Assert.assertEquals((Object)"/foo[1]", (Object)this.builder.apply((Node)e).getXPath());
    }

    @Test
    public void deeperStructure() {
        Element e = this.doc.createElement("foo");
        this.doc.appendChild(e);
        Element e2 = this.doc.createElement("foo");
        e.appendChild(e2);
        e2.appendChild(this.doc.createElement("foo"));
        Element e3 = this.doc.createElement("foo");
        e2.appendChild(e3);
        e2.appendChild(this.doc.createComment("foo"));
        Comment c = this.doc.createComment("foo");
        e2.appendChild(c);
        Assert.assertEquals((Object)"/foo[1]/foo[1]/foo[2]", (Object)this.builder.apply((Node)e3).getXPath());
        Assert.assertEquals((Object)"/foo[1]/foo[1]/comment()[2]", (Object)this.builder.apply((Node)c).getXPath());
    }

    @Test
    public void attribute() {
        Element e = this.doc.createElement("foo");
        e.setAttribute("foo", "bar");
        e.setAttribute("baz", "xyzzy");
        Assert.assertEquals((Object)"/foo[1]/@foo", (Object)this.builder.apply((Node)e.getAttributeNode("foo")).getXPath());
    }

    @Test
    public void namespaceButNoMap() {
        Element e = this.doc.createElementNS("http://www.xmlunit.org/test", "foo");
        e.setAttributeNS("http://www.xmlunit.org/test", "foo", "bar");
        e.setAttributeNS("http://www.xmlunit.org/test", "baz", "xyzzy");
        Assert.assertEquals((Object)"/foo[1]/@foo", (Object)this.builder.apply((Node)e.getAttributeNode("foo")).getXPath());
    }

    @Test
    public void namespaceWithMap() {
        Element e = this.doc.createElementNS("http://www.xmlunit.org/test", "foo");
        e.setAttributeNS("http://www.xmlunit.org/test", "foo", "bar");
        e.setAttributeNS("http://www.xmlunit.org/test", "baz", "xyzzy");
        Map<String, String> p2u = Collections.singletonMap("x", "http://www.xmlunit.org/test");
        this.builder.setNamespaceContext(p2u);
        Assert.assertEquals((Object)"/x:foo[1]/@x:foo", (Object)this.builder.apply((Node)e.getAttributeNode("foo")).getXPath());
    }
}

