/*
 * Decompiled with CFR 0.152.
 */
package org.xmlunit.diff;

import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xmlunit.diff.XPathContext;
import org.xmlunit.util.Linqy;

public class XPathContextTest {
    @Test
    public void empty() {
        Assert.assertEquals((Object)"/", (Object)new XPathContext().getXPath());
    }

    @Test
    public void rootElement() throws Exception {
        Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        Assert.assertEquals((Object)"/foo[1]", (Object)new XPathContext((Node)doc.createElement("foo")).getXPath());
    }

    @Test
    public void oneLevelOfElements() {
        ArrayList<Element> l = new ArrayList<Element>();
        l.add(new Element("foo"));
        l.add(new Element("foo"));
        l.add(new Element("bar"));
        l.add(new Element("foo"));
        XPathContext ctx = new XPathContext();
        ctx.setChildren(l);
        ctx.navigateToChild(0);
        Assert.assertEquals((Object)"/foo[1]", (Object)ctx.getXPath());
        Assert.assertEquals((Object)"/", (Object)ctx.getParentXPath());
        ctx.navigateToParent();
        ctx.navigateToChild(1);
        Assert.assertEquals((Object)"/foo[2]", (Object)ctx.getXPath());
        Assert.assertEquals((Object)"/", (Object)ctx.getParentXPath());
        ctx.navigateToParent();
        ctx.navigateToChild(2);
        Assert.assertEquals((Object)"/bar[1]", (Object)ctx.getXPath());
        Assert.assertEquals((Object)"/", (Object)ctx.getParentXPath());
        ctx.navigateToParent();
        ctx.navigateToChild(3);
        Assert.assertEquals((Object)"/foo[3]", (Object)ctx.getXPath());
        Assert.assertEquals((Object)"/", (Object)ctx.getParentXPath());
    }

    @Test
    public void shouldCreateCopyOnClone() {
        ArrayList<Element> l = new ArrayList<Element>();
        l.add(new Element("foo"));
        l.add(new Element("foo"));
        l.add(new Element("bar"));
        XPathContext ctx = new XPathContext();
        ctx.setChildren(l);
        ctx.navigateToChild(1);
        Assert.assertEquals((Object)"/foo[2]", (Object)ctx.getXPath());
        Assert.assertEquals((Object)"/", (Object)ctx.getParentXPath());
        XPathContext clone = ctx.clone();
        Assert.assertEquals((Object)"/foo[2]", (Object)clone.getXPath());
        Assert.assertEquals((Object)"/", (Object)clone.getParentXPath());
        Assert.assertNotSame((Object)clone, (Object)ctx);
        clone.navigateToParent();
        clone.navigateToChild(2);
        Assert.assertEquals((Object)"/bar[1]", (Object)clone.getXPath());
        Assert.assertEquals((Object)"/", (Object)clone.getParentXPath());
        Assert.assertEquals((Object)"/foo[2]", (Object)ctx.getXPath());
        Assert.assertEquals((Object)"/", (Object)ctx.getParentXPath());
    }

    @Test
    public void appendChildren() {
        ArrayList<Element> l = new ArrayList<Element>();
        l.add(new Element("foo"));
        l.add(new Element("foo"));
        XPathContext ctx = new XPathContext();
        ctx.setChildren(l);
        l = new ArrayList();
        l.add(new Element("bar"));
        l.add(new Element("foo"));
        ctx.appendChildren(l);
        ctx.navigateToChild(0);
        Assert.assertEquals((Object)"/foo[1]", (Object)ctx.getXPath());
        Assert.assertEquals((Object)"/", (Object)ctx.getParentXPath());
        ctx.navigateToParent();
        ctx.navigateToChild(1);
        Assert.assertEquals((Object)"/foo[2]", (Object)ctx.getXPath());
        Assert.assertEquals((Object)"/", (Object)ctx.getParentXPath());
        ctx.navigateToParent();
        ctx.navigateToChild(2);
        Assert.assertEquals((Object)"/bar[1]", (Object)ctx.getXPath());
        Assert.assertEquals((Object)"/", (Object)ctx.getParentXPath());
        ctx.navigateToParent();
        ctx.navigateToChild(3);
        Assert.assertEquals((Object)"/foo[3]", (Object)ctx.getXPath());
        Assert.assertEquals((Object)"/", (Object)ctx.getParentXPath());
    }

    @Test
    public void appendChildrenWithNonElements() {
        ArrayList<NonElement> l = new ArrayList<NonElement>();
        l.add(new Text());
        l.add(new Comment());
        l.add(new CDATA());
        l.add(new PI());
        XPathContext ctx = new XPathContext();
        ctx.setChildren(l);
        ctx.appendChildren(l);
        ctx.navigateToChild(0);
        Assert.assertEquals((Object)"/text()[1]", (Object)ctx.getXPath());
        Assert.assertEquals((Object)"/", (Object)ctx.getParentXPath());
        ctx.navigateToParent();
        ctx.navigateToChild(1);
        Assert.assertEquals((Object)"/comment()[1]", (Object)ctx.getXPath());
        Assert.assertEquals((Object)"/", (Object)ctx.getParentXPath());
        ctx.navigateToParent();
        ctx.navigateToChild(2);
        Assert.assertEquals((Object)"/text()[2]", (Object)ctx.getXPath());
        Assert.assertEquals((Object)"/", (Object)ctx.getParentXPath());
        ctx.navigateToParent();
        ctx.navigateToChild(3);
        Assert.assertEquals((Object)"/processing-instruction()[1]", (Object)ctx.getXPath());
        Assert.assertEquals((Object)"/", (Object)ctx.getParentXPath());
        ctx.navigateToParent();
        ctx.navigateToChild(4);
        Assert.assertEquals((Object)"/text()[3]", (Object)ctx.getXPath());
        Assert.assertEquals((Object)"/", (Object)ctx.getParentXPath());
        ctx.navigateToParent();
        ctx.navigateToChild(5);
        Assert.assertEquals((Object)"/comment()[2]", (Object)ctx.getXPath());
        Assert.assertEquals((Object)"/", (Object)ctx.getParentXPath());
        ctx.navigateToParent();
        ctx.navigateToChild(6);
        Assert.assertEquals((Object)"/text()[4]", (Object)ctx.getXPath());
        Assert.assertEquals((Object)"/", (Object)ctx.getParentXPath());
        ctx.navigateToParent();
        ctx.navigateToChild(7);
        Assert.assertEquals((Object)"/processing-instruction()[2]", (Object)ctx.getXPath());
        Assert.assertEquals((Object)"/", (Object)ctx.getParentXPath());
    }

    @Test
    public void twoLevelsOfElements() {
        ArrayList<Element> l = new ArrayList<Element>();
        l.add(new Element("foo"));
        l.add(new Element("foo"));
        l.add(new Element("bar"));
        l.add(new Element("foo"));
        XPathContext ctx = new XPathContext();
        ctx.setChildren(l);
        ctx.navigateToChild(0);
        Assert.assertEquals((Object)"/foo[1]", (Object)ctx.getXPath());
        Assert.assertEquals((Object)"/", (Object)ctx.getParentXPath());
        ctx.setChildren(l);
        ctx.navigateToChild(3);
        Assert.assertEquals((Object)"/foo[1]/foo[3]", (Object)ctx.getXPath());
        Assert.assertEquals((Object)"/foo[1]", (Object)ctx.getParentXPath());
        ctx.navigateToParent();
        Assert.assertEquals((Object)"/foo[1]", (Object)ctx.getXPath());
        Assert.assertEquals((Object)"/", (Object)ctx.getParentXPath());
        ctx.navigateToParent();
        ctx.navigateToChild(2);
        Assert.assertEquals((Object)"/bar[1]", (Object)ctx.getXPath());
        Assert.assertEquals((Object)"/", (Object)ctx.getParentXPath());
    }

    @Test
    public void attributes() {
        XPathContext ctx = new XPathContext();
        ctx.setChildren(Linqy.singleton((Object)new Element("foo")));
        ctx.navigateToChild(0);
        ArrayList<QName> l = new ArrayList<QName>();
        l.add(new QName("bar"));
        ctx.addAttributes(l);
        ctx.navigateToAttribute(new QName("bar"));
        Assert.assertEquals((Object)"/foo[1]/@bar", (Object)ctx.getXPath());
        Assert.assertEquals((Object)"/foo[1]", (Object)ctx.getParentXPath());
    }

    @Test
    public void singleAttribute() {
        XPathContext ctx = new XPathContext();
        ctx.setChildren(Linqy.singleton((Object)new Element("foo")));
        ctx.navigateToChild(0);
        ctx.addAttribute(new QName("bar"));
        ctx.navigateToAttribute(new QName("bar"));
        Assert.assertEquals((Object)"/foo[1]/@bar", (Object)ctx.getXPath());
        Assert.assertEquals((Object)"/foo[1]", (Object)ctx.getParentXPath());
    }

    @Test
    public void mixed() {
        ArrayList<NonElement> l = new ArrayList<NonElement>();
        l.add(new Text());
        l.add(new Comment());
        l.add(new CDATA());
        l.add(new PI());
        l.add(new CDATA());
        l.add(new Comment());
        l.add(new PI());
        l.add(new Text());
        XPathContext ctx = new XPathContext();
        ctx.setChildren(l);
        ctx.navigateToChild(0);
        Assert.assertEquals((Object)"/text()[1]", (Object)ctx.getXPath());
        Assert.assertEquals((Object)"/", (Object)ctx.getParentXPath());
        ctx.navigateToParent();
        ctx.navigateToChild(1);
        Assert.assertEquals((Object)"/comment()[1]", (Object)ctx.getXPath());
        Assert.assertEquals((Object)"/", (Object)ctx.getParentXPath());
        ctx.navigateToParent();
        ctx.navigateToChild(2);
        Assert.assertEquals((Object)"/text()[2]", (Object)ctx.getXPath());
        Assert.assertEquals((Object)"/", (Object)ctx.getParentXPath());
        ctx.navigateToParent();
        ctx.navigateToChild(3);
        Assert.assertEquals((Object)"/processing-instruction()[1]", (Object)ctx.getXPath());
        Assert.assertEquals((Object)"/", (Object)ctx.getParentXPath());
        ctx.navigateToParent();
        ctx.navigateToChild(4);
        Assert.assertEquals((Object)"/text()[3]", (Object)ctx.getXPath());
        Assert.assertEquals((Object)"/", (Object)ctx.getParentXPath());
        ctx.navigateToParent();
        ctx.navigateToChild(5);
        Assert.assertEquals((Object)"/comment()[2]", (Object)ctx.getXPath());
        Assert.assertEquals((Object)"/", (Object)ctx.getParentXPath());
        ctx.navigateToParent();
        ctx.navigateToChild(6);
        Assert.assertEquals((Object)"/processing-instruction()[2]", (Object)ctx.getXPath());
        Assert.assertEquals((Object)"/", (Object)ctx.getParentXPath());
        ctx.navigateToParent();
        ctx.navigateToChild(7);
        Assert.assertEquals((Object)"/text()[4]", (Object)ctx.getXPath());
        Assert.assertEquals((Object)"/", (Object)ctx.getParentXPath());
    }

    @Test
    public void elementsAndNs() {
        ArrayList<Element> l = new ArrayList<Element>();
        l.add(new Element("foo", "urn:foo:foo"));
        l.add(new Element("foo"));
        l.add(new Element("foo", "urn:foo:bar"));
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("bar", "urn:foo:bar");
        XPathContext ctx = new XPathContext(m);
        ctx.setChildren(l);
        ctx.navigateToChild(0);
        Assert.assertEquals((Object)"/foo[1]", (Object)ctx.getXPath());
        Assert.assertEquals((Object)"/", (Object)ctx.getParentXPath());
        ctx.navigateToParent();
        ctx.navigateToChild(1);
        Assert.assertEquals((Object)"/foo[2]", (Object)ctx.getXPath());
        Assert.assertEquals((Object)"/", (Object)ctx.getParentXPath());
        ctx.navigateToParent();
        ctx.navigateToChild(2);
        Assert.assertEquals((Object)"/bar:foo[1]", (Object)ctx.getXPath());
        Assert.assertEquals((Object)"/", (Object)ctx.getParentXPath());
    }

    @Test
    public void attributesAndNs() {
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("bar", "urn:foo:bar");
        XPathContext ctx = new XPathContext(m);
        ctx.setChildren(Linqy.singleton((Object)new Element("foo", "urn:foo:bar")));
        ctx.navigateToChild(0);
        ArrayList<QName> l = new ArrayList<QName>();
        l.add(new QName("baz"));
        l.add(new QName("urn:foo:bar", "baz"));
        ctx.addAttributes(l);
        ctx.navigateToAttribute(new QName("baz"));
        Assert.assertEquals((Object)"/bar:foo[1]/@baz", (Object)ctx.getXPath());
        Assert.assertEquals((Object)"/bar:foo[1]", (Object)ctx.getParentXPath());
        ctx.navigateToParent();
        ctx.navigateToAttribute(new QName("urn:foo:bar", "baz"));
        Assert.assertEquals((Object)"/bar:foo[1]/@bar:baz", (Object)ctx.getXPath());
        Assert.assertEquals((Object)"/bar:foo[1]", (Object)ctx.getParentXPath());
        ctx.navigateToParent();
    }

    @Test
    public void parentXPathEdgeCases() {
        XPathContext ctx = new XPathContext();
        Assert.assertEquals((Object)"", (Object)ctx.getParentXPath());
    }

    private static class CDATA
    extends NonElement {
        private CDATA() {
        }

        public short getType() {
            return 4;
        }
    }

    private static class PI
    extends NonElement {
        private PI() {
        }

        public short getType() {
            return 7;
        }
    }

    private static class Comment
    extends NonElement {
        private Comment() {
        }

        public short getType() {
            return 8;
        }
    }

    private static class Text
    extends NonElement {
        private Text() {
        }

        public short getType() {
            return 3;
        }
    }

    private static abstract class NonElement
    implements XPathContext.NodeInfo {
        private NonElement() {
        }

        public QName getName() {
            return null;
        }
    }

    private static class Element
    implements XPathContext.NodeInfo {
        private final QName name;

        private Element(String name) {
            this.name = new QName(name);
        }

        private Element(String name, String ns) {
            this.name = new QName(ns, name);
        }

        public QName getName() {
            return this.name;
        }

        public short getType() {
            return 1;
        }
    }
}

